/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PKCSDerObject
implements Cloneable {
    protected String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSDerObject";

    public PKCSDerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSDerObject");
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSDerObject", string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSDerObject", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(byte[] byArray, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSDerObject", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String string, boolean bl) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "PKCSDerObject", objectArray);
        }
        if (bl) {
            this.readBASE64(string);
        } else {
            this.read(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public PKCSDerObject(String string, boolean bl, String string2) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PKCSDerObject", objectArray);
        }
        if (string2 != null) {
            this.provider = new String(string2);
        }
        if (bl) {
            this.readBASE64(string);
        } else {
            this.read(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSDerObject");
        }
    }

    public byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", byArray);
        }
        return byArray;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.toString().hashCode());
        }
        return this.toString().hashCode();
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", null);
        }
        return null;
    }

    public void write(String string, boolean bl) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "write", string, new Boolean(bl));
        }
        if (bl) {
            this.writeBASE64(string);
        } else {
            this.write(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    protected void decode(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", (Object)byArray);
        }
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue derValue = derInputStream.getDerValue();
            this.decode(derValue);
        }
        catch (IOException iOException) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray2 = bASE64Decoder.decodeBuffer(byteArrayInputStream);
            DerInputStream derInputStream = new DerInputStream(byArray2);
            DerValue derValue = derInputStream.getDerValue();
            this.decode(derValue);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    protected void read(String string) throws IOException {
        FileInputStream fileInputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "read", string);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "read", fileNotFoundException);
            }
            throw new IOException("File " + string + " not found.");
        }
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "read");
        }
    }

    protected void readBASE64(String string) throws IOException {
        FileInputStream fileInputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", string);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", fileNotFoundException);
            }
            throw new IOException("File " + string + " not found.");
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(fileInputStream);
        fileInputStream.close();
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }

    protected void write(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "write", string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.encode(fileOutputStream);
        fileOutputStream.close();
        if (debug != null) {
            debug.exit(16384L, className, "write");
        }
    }

    protected void writeBASE64(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        bASE64Encoder.encode(byArray, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    protected abstract void decode(DerValue var1) throws IOException;

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract String toString();

    public abstract boolean equals(Object var1);
}

