/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

final class SMIMEUtils {
    private static String crlf = "\r\n";
    private static byte[] crlfbytes = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEUtils";

    SMIMEUtils() {
    }

    static byte[] getMessageBody(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getMessageBody", (Object)byArray);
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getMessageBody_1", null);
            }
            return null;
        }
        String string = new String(byArray);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string2 = null;
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.equals("")) continue;
            bl = true;
            break;
        }
        if (bl) {
            while ((string2 = bufferedReader.readLine()) != null) {
                try {
                    byteArrayOutputStream.write(string2.getBytes("8859_1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (debug != null) {
                        debug.exception(49152L, className, "getMessageBody", unsupportedEncodingException);
                    }
                    byteArrayOutputStream.write(string2.getBytes());
                }
                byteArrayOutputStream.write(crlfbytes);
            }
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getMessageBody_2", byArray2);
        }
        return byArray2;
    }

    static byte[] getMessageBodyRemoveTrailer(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getMessageBodyRemoveTrailer", (Object)byArray);
        }
        if (byArray == null || byArray.length == 0) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getMessageBodyRemoveTrailer_1", null);
            }
            return null;
        }
        String string = new String(byArray);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string2 = null;
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!((string2 = bufferedReader.readLine()) == null || bl && string2.equals("."))) {
            try {
                byteArrayOutputStream.write(string2.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(49152L, className, "getMessageBodyRemoveTrailer", unsupportedEncodingException);
                }
                byteArrayOutputStream.write(string2.getBytes());
            }
            byteArrayOutputStream.write(crlfbytes);
            bl = true;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getMessageBodyRemoveTrailer_2", byArray2);
        }
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getContentType(Object object) {
        String string;
        block11: {
            block9: {
                block12: {
                    Content content;
                    block10: {
                        string = null;
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getContentType", object);
                        }
                        if (!(object instanceof ContentInfo)) break block9;
                        content = ((ContentInfo)object).getContent();
                        if (!(content instanceof EnvelopedData)) break block10;
                        string = "application/x-pkcs7-mime; name=\"smime.p7m\"";
                        break block11;
                    }
                    if (!(content instanceof SignedData)) break block12;
                    string = "application/x-pkcs7-mime; smime-type=signed-data; name=\"smime.p7m\"";
                    SignedData signedData = (SignedData)content;
                    if (signedData.hasCertificatesOnly()) {
                        string = "application/x-pkcs7-mime; smime-type=certs-only; name=\"smime.p7c\"";
                        break block11;
                    } else if (!signedData.hasContent()) {
                        string = "application/x-pkcs7-signature; name=\"smime.p7s\"";
                    }
                    break block11;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (object instanceof CertificationRequest) {
                string = "application/x-pkcs10; name=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getContentType", string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getContentType(Object object, boolean bl) {
        String string;
        block12: {
            block10: {
                block13: {
                    Content content;
                    block11: {
                        string = null;
                        if (!bl) {
                            return SMIMEUtils.getContentType(object);
                        }
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getContentType2", object);
                        }
                        if (!(object instanceof ContentInfo)) break block10;
                        content = ((ContentInfo)object).getContent();
                        if (!(content instanceof EnvelopedData)) break block11;
                        string = "application/pkcs7-mime; name=\"smime.p7m\"";
                        break block12;
                    }
                    if (!(content instanceof SignedData)) break block13;
                    string = "application/pkcs7-mime; smime-type=signed-data; name=\"smime.p7m\"";
                    SignedData signedData = (SignedData)content;
                    if (signedData.hasCertificatesOnly()) {
                        string = "application/pkcs7-mime; smime-type=certs-only; name=\"smime.p7c\"";
                        break block12;
                    } else if (!signedData.hasContent()) {
                        string = "application/pkcs7-signature; name=\"smime.p7s\"";
                    }
                    break block12;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (object instanceof CertificationRequest) {
                string = "application/pkcs10; name=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getContentType", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getContentType", string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getDisposition(Object object) {
        String string;
        block11: {
            block9: {
                block12: {
                    Content content;
                    block10: {
                        string = null;
                        if (debug != null) {
                            debug.entry(49152L, (Object)className, "getDisposition", object);
                        }
                        if (!(object instanceof ContentInfo)) break block9;
                        content = ((ContentInfo)object).getContent();
                        if (!(content instanceof EnvelopedData)) break block10;
                        string = "attachment; filename=\"smime.p7m\"";
                        break block11;
                    }
                    if (!(content instanceof SignedData)) break block12;
                    string = "attachment; filename=\"smime.p7m\"";
                    SignedData signedData = (SignedData)content;
                    if (signedData.hasCertificatesOnly()) {
                        string = "attachment; filename=\"smime.p7c\"";
                        break block11;
                    } else if (!signedData.hasContent()) {
                        string = "attachment; filename=\"smime.p7s\"";
                    }
                    break block11;
                }
                if (debug != null) {
                    debug.text(49152L, className, "getDisposition", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
                throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
            }
            if (object instanceof CertificationRequest) {
                string = "attachment; filename=\"smime.p10\"";
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getDisposition", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getDisposition", string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getDescription(Object object) {
        String string;
        block11: {
            block9: {
                Content content;
                block10: {
                    string = null;
                    if (debug != null) {
                        debug.entry(49152L, (Object)className, "getDescription", object);
                    }
                    if (!(object instanceof ContentInfo)) break block9;
                    content = ((ContentInfo)object).getContent();
                    if (!(content instanceof EnvelopedData)) break block10;
                    string = "S/MIME Encrypted Message";
                    break block11;
                }
                if (content instanceof SignedData) {
                    string = null;
                    SignedData signedData = (SignedData)content;
                    if (!signedData.hasCertificatesOnly() && !signedData.hasContent()) {
                        string = "S/MIME Cryptographic Signature";
                    }
                    break block11;
                } else {
                    if (debug != null) {
                        debug.text(49152L, className, "getDescription", "Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                    }
                    throw new IllegalArgumentException("Only ContentInfo objects of type SignedData or EnvelopedData are supported.");
                }
            }
            if (object instanceof CertificationRequest) {
                string = null;
            } else {
                if (debug != null) {
                    debug.text(49152L, className, "getDescription", "Only objects of type ContentInfo or CertificationRequest are supported.");
                }
                throw new IllegalArgumentException("Only objects of type ContentInfo or CertificationRequest are supported.");
            }
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "getDescription", string);
        }
        return string;
    }

    static {
        try {
            crlfbytes = crlf.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            crlfbytes = crlf.getBytes();
        }
    }
}

