/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs12.PKCS12PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Vector;

public class parsePKCS12PFX {
    static final int CERT = 1;
    static final int KEY = 2;
    static final int PWD = 3;
    static final int MAC = 4;
    static final int INP = 5;

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        String string = null;
        char[] cArray = null;
        Vector<char[]> vector = new Vector<char[]>();
        String string2 = null;
        String string3 = null;
        if (stringArray.length < 2) {
            parsePKCS12PFX.usage();
            System.exit(1);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            int n3 = 1;
            while (n < stringArray.length) {
                object6 = stringArray[n];
                if (((String)object6).equals("-c")) {
                    n3 = 1;
                    ++n;
                }
                if (((String)object6).equals("-k")) {
                    n3 = 2;
                    ++n;
                }
                if (((String)object6).equals("-p")) {
                    n3 = 3;
                    ++n;
                }
                if (((String)object6).equals("-m")) {
                    n3 = 4;
                    ++n;
                }
                if (((String)object6).equals("-f")) {
                    n3 = 5;
                    ++n;
                }
                switch (n3) {
                    case 1: {
                        if (string2 != null) {
                            System.out.println("ERROR: Certificate has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        string2 = stringArray[n];
                        break;
                    }
                    case 2: {
                        if (string3 != null) {
                            System.out.println("ERROR: Private key has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        string3 = stringArray[n];
                        break;
                    }
                    case 3: {
                        System.out.println("adding " + stringArray[n] + " to pwd vector");
                        vector.addElement(stringArray[n].toCharArray());
                        break;
                    }
                    case 4: {
                        if (cArray != null) {
                            System.out.println("ERROR: HMAC password has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        cArray = stringArray[n].toCharArray();
                        break;
                    }
                    case 5: {
                        if (string != null) {
                            System.out.println("ERROR: PFX file has already been specified.");
                            parsePKCS12PFX.usage();
                            System.exit(1);
                        }
                        string = stringArray[n];
                    }
                }
                ++n;
            }
            if (string == null) {
                System.out.println("ERROR: PFX file must be specified!");
                parsePKCS12PFX.usage();
                System.exit(1);
            }
            System.out.println("Creating a PKCS #12 PFX from " + string);
            object6 = new FileInputStream(string);
            byte[] byArray = new byte[((FileInputStream)object6).available()];
            ((FileInputStream)object6).read(byArray);
            ((FileInputStream)object6).close();
            PKCS12PFX pKCS12PFX = new PKCS12PFX(byArray);
            X509CertImpl x509CertImpl = null;
            PrivateKey privateKey = null;
            if (string2 != null) {
                System.out.println("Creating certificate from " + string2);
                object6 = new FileInputStream(string2);
                x509CertImpl = new X509CertImpl((InputStream)object6);
            }
            if (string3 != null) {
                System.out.println("Creating private key from " + string3);
                object6 = new FileInputStream(string3);
                object5 = new byte[((FileInputStream)object6).available()];
                ((FileInputStream)object6).read((byte[])object5);
                privateKey = parsePKCS12PFX.convertPrivateKey((byte[])object5);
            }
            if ((object5 = pKCS12PFX.getMacData()) != null) {
                System.out.println("Verifying HMAC.");
                if (pKCS12PFX.verifyMac(cArray)) {
                    System.out.println("HMAC is verified.");
                } else {
                    System.out.println("HMAC is not verified.");
                    System.exit(2);
                }
            } else if (pKCS12PFX.hasDigitalSignature()) {
                System.out.println("Verifying digital signature.");
                if (pKCS12PFX.verifySignature(x509CertImpl)) {
                    System.out.println("Signature is verified.");
                } else {
                    System.out.println("Signature is not verified.");
                    System.exit(2);
                }
            }
            System.out.println("Getting all certificates.");
            Vector<Certificate> vector2 = new Vector<Certificate>();
            Certificate[] certificateArray = null;
            Certificate[] certificateArray2 = null;
            certificateArray = pKCS12PFX.getCertificates(null, null, null);
            if (certificateArray != null) {
                System.out.println("Found " + certificateArray.length + " unprotected certificates.");
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    vector2.addElement(certificateArray[n2]);
                }
            }
            if (vector.size() > 0) {
                for (n = 0; n < vector.size(); ++n) {
                    object4 = (char[])vector.elementAt(n);
                    certificateArray = pKCS12PFX.getCertificates((char[])object4, null, null);
                    if (certificateArray == null) continue;
                    System.out.println("Found " + certificateArray.length + " password-protected certificates.");
                    for (n2 = 0; n2 < certificateArray.length; ++n2) {
                        vector2.addElement(certificateArray[n2]);
                    }
                }
            }
            if (x509CertImpl != null && privateKey != null && (certificateArray = pKCS12PFX.getCertificates(null, privateKey, x509CertImpl)) != null) {
                System.out.println("Found " + certificateArray.length + " pubkey-protected certificates.");
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    vector2.addElement(certificateArray[n2]);
                }
            }
            if (vector2.size() > 0) {
                certificateArray2 = new Certificate[vector2.size()];
                for (n = 0; n < vector2.size(); ++n) {
                    certificateArray2[n] = (Certificate)vector2.elementAt(n);
                }
            }
            System.out.println("Getting all shrouded keys.");
            object4 = new Vector();
            EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray = null;
            EncryptedPrivateKeyInfo[] encryptedPrivateKeyInfoArray2 = null;
            encryptedPrivateKeyInfoArray = pKCS12PFX.getShroudedKeys(null, null, null);
            if (encryptedPrivateKeyInfoArray != null) {
                System.out.println("Found " + encryptedPrivateKeyInfoArray.length + " unprotected shrouded keys.");
                for (n2 = 0; n2 < encryptedPrivateKeyInfoArray.length; ++n2) {
                    object4.addElement(encryptedPrivateKeyInfoArray[n2]);
                }
            }
            if (vector.size() > 0) {
                for (n = 0; n < vector.size(); ++n) {
                    object3 = (char[])vector.elementAt(n);
                    encryptedPrivateKeyInfoArray = pKCS12PFX.getShroudedKeys((char[])object3, null, null);
                    if (encryptedPrivateKeyInfoArray == null) continue;
                    System.out.println("Found " + encryptedPrivateKeyInfoArray.length + " password-protected shrouded keys.");
                    for (n2 = 0; n2 < encryptedPrivateKeyInfoArray.length; ++n2) {
                        object4.addElement(encryptedPrivateKeyInfoArray[n2]);
                    }
                }
            }
            if (x509CertImpl != null && privateKey != null && (encryptedPrivateKeyInfoArray = pKCS12PFX.getShroudedKeys(null, privateKey, x509CertImpl)) != null) {
                System.out.println("Found " + encryptedPrivateKeyInfoArray.length + " pubkey-protected shrouded keys.");
                for (n2 = 0; n2 < encryptedPrivateKeyInfoArray.length; ++n2) {
                    object4.addElement(encryptedPrivateKeyInfoArray[n2]);
                }
            }
            if (object4.size() > 0) {
                encryptedPrivateKeyInfoArray2 = new EncryptedPrivateKeyInfo[object4.size()];
                for (n = 0; n < object4.size(); ++n) {
                    encryptedPrivateKeyInfoArray2[n] = (EncryptedPrivateKeyInfo)object4.elementAt(n);
                }
            }
            System.out.println("Getting all private keys.");
            object3 = new Vector();
            PrivateKeyInfo[] privateKeyInfoArray = null;
            PrivateKeyInfo[] privateKeyInfoArray2 = null;
            if (encryptedPrivateKeyInfoArray2 != null) {
                System.out.println("Converting " + encryptedPrivateKeyInfoArray2.length + " shrouded keys to private keys.");
                for (n = 0; n < encryptedPrivateKeyInfoArray2.length; ++n) {
                    try {
                        object2 = encryptedPrivateKeyInfoArray2[n].decrypt(cArray);
                        object = new PrivateKeyInfo((byte[])object2);
                        object3.addElement(object);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((privateKeyInfoArray = pKCS12PFX.getPrivateKeys(null, null, null)) != null) {
                System.out.println("Found " + privateKeyInfoArray.length + " unprotected private keys.");
                for (n2 = 0; n2 < privateKeyInfoArray.length; ++n2) {
                    object3.addElement(privateKeyInfoArray[n2]);
                }
            }
            if (vector.size() > 0) {
                for (n = 0; n < vector.size(); ++n) {
                    object2 = (char[])vector.elementAt(n);
                    privateKeyInfoArray = pKCS12PFX.getPrivateKeys((char[])object2, null, null);
                    if (privateKeyInfoArray == null) continue;
                    System.out.println("Found " + privateKeyInfoArray.length + " password-protected private keys.");
                    for (n2 = 0; n2 < privateKeyInfoArray.length; ++n2) {
                        object3.addElement(privateKeyInfoArray[n2]);
                    }
                }
            }
            if (x509CertImpl != null && privateKey != null && (privateKeyInfoArray = pKCS12PFX.getPrivateKeys(null, privateKey, x509CertImpl)) != null) {
                System.out.println("Found " + privateKeyInfoArray.length + " pubkey-protected private keys.");
                for (n2 = 0; n2 < privateKeyInfoArray.length; ++n2) {
                    object3.addElement(privateKeyInfoArray[n2]);
                }
            }
            if (object3.size() > 0) {
                privateKeyInfoArray2 = new PrivateKeyInfo[object3.size()];
                for (n = 0; n < object3.size(); ++n) {
                    privateKeyInfoArray2[n] = (PrivateKeyInfo)object3.elementAt(n);
                }
            }
            if (certificateArray2 != null) {
                System.out.println("Found " + certificateArray2.length + " certificates.");
                for (n = 0; n < certificateArray2.length; ++n) {
                    object2 = "p12pfx" + n + ".cer";
                    System.out.println("Writing certificate to " + (String)object2);
                    object = certificateArray2[n].getEncoded();
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object2);
                    fileOutputStream.write((byte[])object);
                    fileOutputStream.close();
                }
            } else {
                System.out.println("Found no certificates.");
            }
            if (encryptedPrivateKeyInfoArray2 != null) {
                System.out.println("Found " + encryptedPrivateKeyInfoArray2.length + " shrouded keys.");
                for (n = 0; n < encryptedPrivateKeyInfoArray2.length; ++n) {
                    object2 = "p12pfx" + n + ".epri";
                    System.out.println("Writing shrouded key to " + (String)object2);
                    encryptedPrivateKeyInfoArray2[n].write((String)object2, false);
                }
            } else {
                System.out.println("Found no shrouded keys.");
            }
            if (privateKeyInfoArray2 != null) {
                System.out.println("Found " + privateKeyInfoArray2.length + " private keys.");
                for (n = 0; n < privateKeyInfoArray2.length; ++n) {
                    object2 = "p12pfx" + n + ".pri";
                    System.out.println("Writing private key to " + (String)object2);
                    privateKeyInfoArray2[n].write((String)object2, false);
                }
            } else {
                System.out.println("Found no private keys.");
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: parsePKCS12PFX -f PFX_file [-m mac_pwd] [-p pwd1 pwd2...]");
        System.out.println("                      [-c cf] [-k kf]");
        System.out.println("  where PFX_file is the PFX-containing file");
        System.out.println("        mac_pwd is the password used for data integrity");
        System.out.println("        -p is followed by one or more passwords to decrypt data with ");
        System.out.println("        -c is followed by a certificate file used to decrypt data ");
        System.out.println("           or verify a digital signature");
        System.out.println("        -k is followed by a private key file corresponding to the");
        System.out.println("           certificate's public key");
    }

    private static PrivateKey convertPrivateKey(byte[] byArray) throws PKCSException {
        PrivateKey privateKey = null;
        try {
            System.out.println("Trying to create the private key as a PKCS8EncodedKeySpec.");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            try {
                System.out.println("Trying to create the private key as a PrivateKeyInfo.");
                privateKey = new PrivateKeyInfo(byArray);
            }
            catch (Exception exception2) {
                throw new PKCSException(exception2, "Couldn't create private key.");
            }
        }
        if (privateKey == null) {
            throw new PKCSException("ERROR:  Could not create private key.");
        }
        return privateKey;
    }
}

