/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    DerInputBuffer(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    void rewind(int n) {
        if (n <= this.pos) {
            this.pos -= n;
        }
    }

    byte[] toByteArray() {
        int n = this.available();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        return byArray;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n = this.available();
        if (derInputBuffer.available() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.buf[this.pos + i] == derInputBuffer.buf[derInputBuffer.pos + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.available();
        int n3 = this.pos;
        for (int i = 0; i < n2; ++i) {
            n += this.buf[n3 + i] * i;
        }
        return n;
    }

    void truncate(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n;
    }

    BigInteger getBigInteger(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (n == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.skip(n);
        return new BigInteger(byArray);
    }

    int getSigned(int n) throws IOException {
        int n2 = 0;
        if (n > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        for (int i = 0; i < n; ++i) {
            n2 |= (byArray[i] & 0xFF) << 8 * (n - (i + 1));
        }
        if (n > 0 && (byArray[0] & 0x80) == 128) {
            n2 |= -1 << 8 * n;
        }
        this.skip(n);
        return n2;
    }

    byte[] getBitString(int n) throws IOException {
        if (n > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (n == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte by = this.buf[this.pos];
        if (by < 0 || by > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        byte[] byArray = new byte[n - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n - 1);
        if (by != 0) {
            int n2 = n - 2;
            byArray[n2] = (byte)(byArray[n2] & 255 << by);
        }
        this.skip(n);
        return byArray;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int n = this.available();
        int n2 = this.buf[this.pos] & 0xFF;
        if (n2 > 7) {
            throw new IOException("Invalid value for unused bits: " + n2);
        }
        byte[] byArray = new byte[n - 1];
        int n3 = byArray.length == 0 ? 0 : byArray.length * 8 - n2;
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n - 1);
        BitArray bitArray = new BitArray(n3, byArray);
        this.pos = this.count;
        return bitArray;
    }
}

