/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.CalendarDate;
import com.ibm.security.util.CalendarSystem;

public class Gregorian
implements CalendarSystem {
    public static final int EPOCH_DATE = 719163;
    private static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static CalendarDate getCalendarDate(long l) {
        long l2 = l / 86400000L;
        int n = (int)(l % 86400000L);
        if (n < 0) {
            n += 86400000;
            --l2;
        }
        CalendarDate calendarDate = Gregorian.getCalendarDateFromFixedDate(l2 += 719163L);
        calendarDate.setTimeOfDay(n);
        return calendarDate;
    }

    public static long dateToMillis(CalendarDate calendarDate) {
        long l = Gregorian.getFixedDate(calendarDate.getYear(), calendarDate.getMonth(), calendarDate.getDate());
        return (l - 719163L) * 86400000L + (long)calendarDate.getTimeOfDay();
    }

    public static long dateToMillis(int n, int n2, int n3, int n4) {
        long l = Gregorian.getFixedDate(n, n2, n3);
        return (l - 719163L) * 86400000L + (long)n4;
    }

    public static boolean validate(CalendarDate calendarDate) {
        int n = calendarDate.getMonth();
        if (n < 0 || n > 11) {
            return false;
        }
        int n2 = Gregorian.getMonthLength(calendarDate.getYear(), n);
        return calendarDate.getDate() > 0 && calendarDate.getDate() <= n2;
    }

    public static int getMonthLength(int n, int n2) {
        int n3 = days_in_month[n2];
        if (n2 == 1 && Gregorian.isLeapYear(n)) {
            ++n3;
        }
        return n3;
    }

    public static final long getFixedDate(int n, int n2, int n3) {
        int n4 = n - 1;
        long l = n4 >= 0 ? 365L * (long)n4 + (long)(n4 / 4) - (long)(n4 / 100) + (long)(n4 / 400) + (long)((367 * n2 - 362) / 12) + (long)n3 : 365L * (long)n4 + (long)Gregorian.floorDivide(n4, 4) - (long)Gregorian.floorDivide(n4, 100) + (long)Gregorian.floorDivide(n4, 400) + (long)Gregorian.floorDivide(367 * ++n2 - 362, 12) + (long)n3;
        if (n2 > 2) {
            l -= Gregorian.isLeapYear(n) ? 1L : 2L;
        }
        return l;
    }

    public static CalendarDate getCalendarDateFromFixedDate(long l) {
        int n = Gregorian.getYear(l);
        int n2 = (int)(l - Gregorian.getFixedDate(n, 0, 1));
        int n3 = 2;
        long l2 = Gregorian.getFixedDate(n, 2, 1);
        if (l < l2) {
            n3 = 0;
        } else if (l >= l2 && Gregorian.isLeapYear(n)) {
            n3 = 1;
        }
        int n4 = Gregorian.floorDivide(12 * (n2 + n3) + 373, 367) - 1;
        int n5 = (int)(l - Gregorian.getFixedDate(n, n4, 1) + 1L);
        int n6 = Gregorian.getDayOfWeekFromFixedDate(l);
        CalendarDate calendarDate = new CalendarDate(n, n4, n5);
        calendarDate.setDayOfWeek(n6);
        return calendarDate;
    }

    public static int getDayOfWeek(CalendarDate calendarDate) {
        long l = Gregorian.getFixedDate(calendarDate.getYear(), calendarDate.getMonth(), calendarDate.getDate());
        return Gregorian.getDayOfWeekFromFixedDate(l);
    }

    private static final int getDayOfWeekFromFixedDate(long l) {
        if (l >= 0L) {
            return (int)(l % 7L) + 1;
        }
        return (int)Gregorian.mod(l, 7L) + 1;
    }

    private static final int getYear(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        if (l >= 0L) {
            long l2 = l - 1L;
            n4 = (int)(l2 / 146097L);
            int n5 = (int)(l2 % 146097L);
            n3 = n5 / 36524;
            int n6 = n5 % 36524;
            n2 = n6 / 1461;
            int n7 = n6 % 1461;
            n = n7 / 365;
            int n8 = n7 % 365 + 1;
        } else {
            long l3 = l - 1L;
            n4 = (int)Gregorian.floorDivide(l3, 146097L);
            int n9 = (int)Gregorian.mod(l3, 146097L);
            n3 = Gregorian.floorDivide(n9, 36524);
            int n10 = Gregorian.mod(n9, 36524);
            n2 = Gregorian.floorDivide(n10, 1461);
            int n11 = Gregorian.mod(n10, 1461);
            n = Gregorian.floorDivide(n11, 365);
            int n12 = Gregorian.mod(n11, 365) + 1;
        }
        int n13 = 400 * n4 + 100 * n3 + 4 * n2 + n;
        if (n3 != 4 && n != 4) {
            ++n13;
        }
        return n13;
    }

    public static final boolean isLeapYear(int n) {
        if (n >= 0) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return Gregorian.mod(n, 4) == 0 && (Gregorian.mod(n, 100) != 0 || Gregorian.mod(n, 400) == 0);
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private static final int floorDivide(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    private static final long mod(long l, long l2) {
        return l - l2 * Gregorian.floorDivide(l, l2);
    }

    private static final int mod(int n, int n2) {
        return n - n2 * Gregorian.floorDivide(n, n2);
    }
}

