/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.text.Normalizer;
import com.ibm.security.x509.AVAKeyword;
import com.ibm.security.x509.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;

public final class AVA
implements DerEncoder {
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String specialCharsAll = ",=\n+<>#;\\\" ";
    private static final String hexDigits = "0123456789ABCDEF";
    private static final String digits = "0123456789ABCDEF";
    final ObjectIdentifier oid;
    final DerValue value;
    private String valueString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AVA";

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (debug != null) {
            debug.entry(16384L, className, "AVA", objectIdentifier, derValue);
        }
        this.oid = objectIdentifier;
        this.value = derValue;
        if (debug != null) {
            debug.text(16384L, className, "AVA", "AVA() oid = " + this.oid);
            debug.text(16384L, className, "AVA", "AVA() value = " + this.value);
            debug.exit(16384L, className, "AVA");
        }
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    AVA(Reader reader, int n) throws IOException {
        int n2;
        if (debug != null) {
            debug.entry(16384L, className, "AVA", reader, new Integer(n));
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = AVA.readChar(reader, "Incorrect AVA format")) != 61) {
            stringBuffer.append((char)n2);
        }
        this.oid = AVAKeyword.getOID(stringBuffer.toString(), n);
        stringBuffer.setLength(0);
        if (n == 3) {
            n2 = reader.read();
            if (n2 == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((n2 = reader.read()) == 32 || n2 == 10) {
            }
        }
        if (n2 == -1) {
            this.value = new DerValue("");
            return;
        }
        this.value = n2 == 35 ? AVA.parseHexString(reader, n) : (n2 == 34 && n != 3 ? this.parseQuotedString(reader, stringBuffer) : this.parseString(reader, n2, n, stringBuffer));
    }

    public AVA(String string) throws IOException {
        this(new StringReader(string));
    }

    AVA(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", inputStream);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseInputStream", inputStream);
        }
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                if (debug != null) {
                    debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
                }
                throw new IOException("Incorrect AVA format");
            }
            if ((char)n == '=') break;
            stringBuffer.append((char)n);
        }
        String string = stringBuffer.toString().toUpperCase().trim();
        byte by = 19;
        if (string.equals("CN")) {
            this.oid = X500Name.commonName_oid;
        } else if (string.equals("C")) {
            this.oid = X500Name.countryName_oid;
        } else if (string.equals("L")) {
            this.oid = X500Name.localityName_oid;
        } else if (string.equals("S") || string.equals("ST")) {
            this.oid = X500Name.stateName_oid;
        } else if (string.equals("O")) {
            this.oid = X500Name.orgName_oid;
        } else if (string.equals("OU")) {
            this.oid = X500Name.orgUnitName_oid;
        } else if (string.equals("T")) {
            this.oid = X500Name.title_oid;
        } else if (string.equals("IP")) {
            this.oid = X500Name.ipAddress_oid;
        } else if (string.equals("STREET")) {
            this.oid = X500Name.streetAddress_oid;
        } else if (string.equals("EMAIL") || string.equals("EMAILADDRESS")) {
            this.oid = X500Name.emailAddress_oid;
            by = 22;
        } else if (string.equals("SERIALNUMBER")) {
            this.oid = X500Name.serialNumber_oid;
        } else if (string.equals("DC")) {
            this.oid = X500Name.domainComponent_oid;
        } else if (string.startsWith("OID.")) {
            this.oid = new ObjectIdentifier(string.substring(4));
        } else if (string.equals("POSTALCODE")) {
            this.oid = X500Name.postalCode_oid;
        } else if (string.equals("DNQ")) {
            this.oid = X500Name.dnQualifier_oid;
        } else if (string.equals("SURNAME")) {
            this.oid = X500Name.surName_oid;
        } else if (string.equals("GIVENNAME")) {
            this.oid = X500Name.givenName_oid;
        } else if (string.equals("INITIALS")) {
            this.oid = X500Name.initials_oid;
        } else if (string.equals("GENERATION")) {
            this.oid = X500Name.generationQualifier_oid;
        } else if (string.equals("UID")) {
            this.oid = X500Name.userid_oid;
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "unsupported keyword " + string);
            }
            throw new IOException("unsupported keyword " + string);
        }
        stringBuffer = new StringBuffer();
        char c = (char)inputStream.read();
        while (c == ' ' || c == '\n') {
            c = (char)inputStream.read();
        }
        if (c == '\uffffffff') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
            }
            throw new IOException("Incorrect AVA format");
        }
        if (c == '#') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "AVA parse, hex values!");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            int n2 = 0;
            while (!AVA.isTerminator((short)(c = (char)inputStream.read()), 1)) {
                int n3 = "0123456789ABCDEF".indexOf(Character.toUpperCase(c));
                if (n3 == -1) {
                    throw new IOException("AVA parse, invalid hex digit: " + c);
                }
                if (n2 % 2 == 1) {
                    n = (byte)(n * 16 + (byte)n3);
                    byteArrayOutputStream.write(n);
                } else {
                    n = (byte)n3;
                }
                ++n2;
            }
            if (n2 == 0) {
                throw new IOException("AVA parse, zero hex digits");
            }
            if (n2 % 2 == 1) {
                throw new IOException("AVA parse, odd number of hex digits");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.value = new DerValue(byArray);
        } else if (c == '\"') {
            int n = inputStream.read();
            c = (char)n;
            while (n != -1 && c != '\"') {
                if (c == '\\') {
                    c = (char)inputStream.read();
                }
                stringBuffer.append(c);
                n = inputStream.read();
                c = (char)n;
            }
            this.value = new DerValue(by, stringBuffer.toString().trim());
        } else {
            int n;
            do {
                if (c == '\\') {
                    c = (char)inputStream.read();
                }
                stringBuffer.append(c);
                n = inputStream.read();
                c = (char)n;
            } while (n != -1 && c != '+' && c != ',' && c != ';' && c != '>');
            this.value = new DerValue(by, stringBuffer.toString().trim());
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseInputStream");
        }
    }

    private static boolean isTerminator(int n, int n2) {
        switch (n) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return n2 != 3;
            }
        }
        return false;
    }

    public AVA(DerInputStream derInputStream) throws IOException {
        DerValue derValue;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", derInputStream);
        }
        if ((derValue = derInputStream.getDerValue()).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "X500 AVA, not a sequence");
            }
            throw new IOException("X500 AVA, not a sequence");
        }
        this.oid = X500Name.intern(derValue.getData().getOID());
        this.value = derValue.getData().getDerValue();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "AVA, extra bytes = " + derValue.getData().available());
            }
            throw new IOException("AVA, extra bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "AVA");
        }
    }

    ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    String getValueString() {
        try {
            String string = this.value.getAsString();
            if (string == null) {
                throw new RuntimeException("AVA string is null");
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("AVA error: " + iOException, iOException);
        }
    }

    private static DerValue parseHexString(Reader reader, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        while (!AVA.isTerminator(n2 = reader.read(), n)) {
            int n5 = "0123456789ABCDEF".indexOf(Character.toUpperCase((char)n2));
            if (n5 == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)n2);
            }
            if (n4 % 2 == 1) {
                n3 = (byte)(n3 * 16 + (byte)n5);
                byteArrayOutputStream.write(n3);
            } else {
                n3 = (byte)n5;
            }
            ++n4;
        }
        if (n4 == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (n4 % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(byteArrayOutputStream.toByteArray());
    }

    private DerValue parseQuotedString(Reader reader, StringBuffer stringBuffer) throws IOException {
        Object object;
        int n = AVA.readChar(reader, "Quoted string did not end in quote");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = true;
        while (n != 34) {
            if (n == 92) {
                n = AVA.readChar(reader, "Quoted string did not end in quote");
                object = null;
                object = AVA.getEmbeddedHexPair(n, reader);
                if (object != null) {
                    bl = false;
                    arrayList.add(object);
                    n = reader.read();
                    continue;
                }
                if (n != 92 && n != 34 && specialChars.indexOf((char)n) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)n);
                }
            }
            if (arrayList.size() > 0) {
                object = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append((String)object);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            stringBuffer.append((char)n);
            n = AVA.readChar(reader, "Quoted string did not end in quote");
        }
        if (arrayList.size() > 0) {
            object = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append((String)object);
            arrayList.clear();
        }
        while ((n = reader.read()) == 10 || n == 32) {
        }
        if (n != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals(X500Name.emailAddress_oid)) {
            return new DerValue(22, stringBuffer.toString().trim());
        }
        if (bl) {
            return new DerValue(stringBuffer.toString().trim());
        }
        return new DerValue(12, stringBuffer.toString().trim());
    }

    private DerValue parseString(Reader reader, int n, int n2, StringBuffer stringBuffer) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 0;
        do {
            bl2 = false;
            if (n == 92) {
                bl2 = true;
                n = AVA.readChar(reader, "Invalid trailing backslash");
                Byte by = null;
                by = AVA.getEmbeddedHexPair(n, reader);
                if (by != null) {
                    bl = false;
                    arrayList.add(by);
                    n = reader.read();
                    bl3 = false;
                    continue;
                }
                if (n2 == 1 && specialCharsAll.indexOf((char)n) == -1 || n2 == 2 && specialChars.indexOf((char)n) == -1 && n != 92 && n != 34) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                }
                if (n2 == 3) {
                    if (n == 32) {
                        if (!bl3 && !AVA.trailingSpace(reader)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (n == 35) {
                        if (!bl3) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)n) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)n + "'");
                    }
                }
            } else if (n2 == 3 && specialChars2253.indexOf((char)n) != -1) {
                throw new IOException("Character '" + (char)n + "' in AVA appears without escape");
            }
            if (arrayList.size() > 0) {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(" ");
                }
                n3 = 0;
                String string = AVA.getEmbeddedHexString(arrayList);
                stringBuffer.append(string);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n);
            if (n == 32 && !bl2) {
                ++n3;
            } else {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(" ");
                }
                n3 = 0;
                stringBuffer.append((char)n);
            }
            n = reader.read();
            bl3 = false;
        } while (!AVA.isTerminator(n, n2));
        if (n2 == 3 && n3 > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (arrayList.size() > 0) {
            String string = AVA.getEmbeddedHexString(arrayList);
            stringBuffer.append(string);
            arrayList.clear();
        }
        if (this.oid.equals(X500Name.emailAddress_oid)) {
            return new DerValue(22, stringBuffer.toString());
        }
        if (bl) {
            return new DerValue(stringBuffer.toString());
        }
        return new DerValue(12, stringBuffer.toString());
    }

    private static Byte getEmbeddedHexPair(int n, Reader reader) throws IOException {
        if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)n)) >= 0) {
            int n2 = AVA.readChar(reader, "unexpected EOF - escaped hex value must include two valid digits");
            if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)n2)) >= 0) {
                int n3 = Character.digit((char)n, 16);
                int n4 = Character.digit((char)n2, 16);
                return new Byte((byte)((n3 << 4) + n4));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static String getEmbeddedHexString(ArrayList arrayList) throws IOException {
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return new String(byArray, "UTF8");
    }

    private static boolean trailingSpace(Reader reader) throws IOException {
        boolean bl;
        block3: {
            block4: {
                bl = false;
                if (!reader.markSupported()) {
                    return true;
                }
                reader.mark(9999);
                while (true) {
                    int n;
                    if ((n = reader.read()) == -1) {
                        bl = true;
                        break block3;
                    }
                    if (n == 32) continue;
                    if (n != 92) break block4;
                    int n2 = reader.read();
                    if (n2 != 32) break;
                }
                bl = false;
                break block3;
            }
            bl = false;
        }
        reader.reset();
        return bl;
    }

    private static int readChar(Reader reader, String string) throws IOException {
        int n = reader.read();
        if (n == -1) {
            throw new IOException(string);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        this.derEncode(derOutputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    private String toKeyword(int n) {
        return AVAKeyword.getKeyword(this.oid, n);
    }

    private static boolean isDerString(DerValue derValue, boolean bl) {
        if (bl) {
            switch (derValue.getTag()) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (derValue.getTag()) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = this.toKeywordValueString(this.toKeyword(1));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public String getName() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        string = this.oid.equals(X500Name.commonName_oid) ? "CN" : (this.oid.equals(X500Name.countryName_oid) ? "C" : (this.oid.equals(X500Name.localityName_oid) ? "L" : (this.oid.equals(X500Name.stateName_oid) ? "ST" : (this.oid.equals(X500Name.orgName_oid) ? "O" : (this.oid.equals(X500Name.orgUnitName_oid) ? "OU" : (this.oid.equals(X500Name.title_oid) ? "T" : (this.oid.equals(X500Name.ipAddress_oid) ? "IP" : (this.oid.equals(X500Name.streetAddress_oid) ? "STREET" : (this.oid.equals(X500Name.domainComponent_oid) ? "DC" : (this.oid.equals(X500Name.dnQualifier_oid) ? "DNQ" : (this.oid.equals(X500Name.surName_oid) ? "SURNAME" : (this.oid.equals(X500Name.givenName_oid) ? "GIVENNAME" : (this.oid.equals(X500Name.initials_oid) ? "INITIALS" : (this.oid.equals(X500Name.generationQualifier_oid) ? "GENERATION" : (this.oid.equals(X500Name.emailAddress_oid) ? "EMAILADDRESS" : (this.oid.equals(X500Name.userid_oid) ? "UID" : (this.oid.equals(X500Name.serialNumber_oid) ? "SERIALNUMBER" : (this.oid.equals(X500Name.postalCode_oid) ? "POSTALCODE" : "OID." + this.oid.toString()))))))))))))))))));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", string);
        }
        return string;
    }

    public String toRFC1779String() {
        return this.toKeywordValueString(this.toKeyword(2));
    }

    public String toRFC2253String() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] byArray = null;
            try {
                byArray = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            int n;
            int n2;
            String string = null;
            try {
                string = this.getValueStr();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer(2 * string.length());
            for (n2 = 0; n2 < cArray.length && (cArray[n2] == ' ' || cArray[n2] == '\r'); ++n2) {
            }
            for (n = cArray.length - 1; n >= 0 && (cArray[n] == ' ' || cArray[n] == '\r'); --n) {
            }
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (i < n2 || i > n || ",=+<>#;\"\\".indexOf(c) >= 0) {
                    stringBuffer2.append('\\');
                }
                stringBuffer2.append(c);
            }
            stringBuffer.append(new String(stringBuffer2));
        }
        return new String(stringBuffer);
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString", this.toKeyword(3));
        }
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            object = null;
            try {
                object = this.value.toByteArray();
                if (debug != null) {
                    debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:digit", object);
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_1", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                stringBuffer.append(Character.forDigit(0xF & object2 >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & object2, 16));
            }
        } else {
            int n;
            object = null;
            try {
                object = this.getValueStr();
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_2", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            char[] cArray = ((String)object).toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer(2 * ((String)object).length());
            if (cArray.length > 0 && cArray[0] == '#') {
                stringBuffer2.append('\\');
            }
            for (int i = 0; i < cArray.length && Character.isWhitespace(cArray[i]); ++i) {
            }
            for (n = cArray.length - 1; n >= 0 && Character.isWhitespace(cArray[n]); --n) {
            }
            boolean bl = false;
            for (int i = i; i <= n; ++i) {
                char c = cArray[i];
                if (!Character.isWhitespace(c)) {
                    bl = false;
                    if (",=<>;\"\\".indexOf(c) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append(c);
                    continue;
                }
                if (bl) continue;
                bl = true;
                stringBuffer2.append(c);
            }
            stringBuffer.append(stringBuffer2.toString().trim());
        }
        object = new String(stringBuffer);
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:canon", object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toRFC2253CanonicalString", "DONE");
        }
        String string = Normalizer.normalize((String)object, Normalizer.DECOMP_COMPAT, 0);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:normalized", string);
        }
        return string;
    }

    private String toKeywordValueString(String string) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(string);
        stringBuffer.append("=");
        try {
            String string2 = this.getValueStr();
            if (string2 == null) {
                byte[] byArray = this.value.toByteArray();
                stringBuffer.append('#');
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] >> 4 & 0xF));
                    stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] & 0xF));
                }
            } else {
                char c;
                int n;
                boolean bl = false;
                int n2 = string2.length();
                for (n = 0; n < specialChars.length(); ++n) {
                    if (string2.indexOf(specialChars.charAt(n)) == -1) continue;
                    bl = true;
                    break;
                }
                if (!(n2 <= 0 || bl || string2.charAt(0) != ' ' && string2.charAt(0) != '\n' && string2.charAt(n2 - 1) != ' ' && string2.charAt(n2 - 1) != '\n')) {
                    bl = true;
                }
                if (n2 > 0 && !bl) {
                    c = '\u0000';
                    for (n = 1; n < n2 - 2; ++n) {
                        if (string2.charAt(n) == ' ' || string2.charAt(n) == '\n') {
                            if (c != '\u0000') {
                                bl = true;
                                break;
                            }
                            c = '\u0001';
                            continue;
                        }
                        c = '\u0000';
                    }
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
                for (n = 0; n < n2; ++n) {
                    c = string2.charAt(n);
                    if (c == '\"' || c == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return stringBuffer.toString();
    }

    private String getValueStr() throws IOException {
        if (this.valueString == null) {
            byte[] byArray = null;
            byArray = this.value.getTag() == 30 ? this.value.getBMPString() : this.value.getDataBytes();
            this.valueString = new String(byArray, "UTF8");
        }
        return this.valueString;
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        try {
            String string = this.value.getAsString().trim();
            if (string == null) {
                byte[] byArray = this.value.toByteArray();
                stringBuffer.append('#');
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] >> 4 & 0xF));
                    stringBuffer.append("0123456789ABCDEF".charAt(byArray[i] & 0xF));
                }
            } else {
                char c;
                int n;
                boolean bl = false;
                int n2 = string.length();
                for (n = 0; n < specialChars.length(); ++n) {
                    if (string.indexOf(specialChars.charAt(n)) == -1) continue;
                    bl = true;
                    break;
                }
                if (!(n2 <= 0 || bl || string.charAt(0) != ' ' && string.charAt(0) != '\n' && string.charAt(n2 - 1) != ' ' && string.charAt(n2 - 1) != '\n')) {
                    bl = true;
                }
                if (n2 > 0 && !bl) {
                    c = '\u0000';
                    for (n = 1; n < n2 - 2; ++n) {
                        if (string.charAt(n) == ' ' || string.charAt(n) == '\n') {
                            if (c != '\u0000') {
                                bl = true;
                                break;
                            }
                            c = '\u0001';
                            continue;
                        }
                        c = '\u0000';
                    }
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
                for (n = 0; n < n2; ++n) {
                    c = string.charAt(n);
                    if (c == '\"' || c == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", iOException);
            }
            throw new IllegalArgumentException("DER Value conversion");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.oid);
        }
        return this.oid;
    }

    public DerValue getDerValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerValue");
        }
        if (this.value != null) {
            DerValue derValue = new DerValue(this.value.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDerValue_1", derValue);
            }
            return derValue;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDerValue_2", this.value);
        }
        return this.value;
    }
}

