/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Attribute
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.Attribute";
    private static final String specialChars = ",+=\n<>#;";
    private static final String digits = "0123456789ABCDEF";

    public Attribute(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (debug != null) {
            debug.entry(16384L, className, "Attribute", objectIdentifier, derValue);
        }
        this.oid = objectIdentifier;
        this.value = derValue;
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    Attribute(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Attribute", inputStream);
        }
        AVA aVA = new AVA(inputStream);
        this.oid = aVA.getOID();
        this.value = aVA.getDerValue();
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    public Attribute(DerInputStream derInputStream) throws IOException {
        DerValue derValue;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Attribute", derInputStream);
        }
        if ((derValue = derInputStream.getDerValue()).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "Attribute", "X500 Attribute, not a sequence");
            }
            throw new IOException("X500 Attribute, not a sequence");
        }
        this.oid = X500Name.intern(derValue.getData().getOID());
        this.value = derValue.getData().getDerValue();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "Attribute", "Attribute, extra bytes = " + derValue.getData().available());
            }
            throw new IOException("Attribute, extra bytes = " + derValue.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    boolean equals(Attribute attribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", attribute);
            debug.exit(16384L, (Object)className, "equals", this.oid.equals(attribute.oid) && this.value.equals(attribute.value));
        }
        return this.oid.equals(attribute.oid) && this.value.equals(attribute.value);
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof Attribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((Attribute)object));
            }
            return this.equals((Attribute)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        this.derEncode(derOutputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        AVA aVA = new AVA(this.oid, this.value);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", aVA.toString());
        }
        return aVA.toString();
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.oid);
        }
        return this.oid;
    }

    public DerValue getDerValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerValue");
        }
        if (this.value != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDerValue_1", new DerValue(this.value.toByteArray()));
            }
            return new DerValue(this.value.toByteArray());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDerValue_2", this.value);
        }
        return this.value;
    }
}

