/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public final class AuthorityInfoAccessExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.AuthorityInfoAccess";
    public static final String AUTHORITY_INFO_ACCESS = "authority_info_access";
    public static final String NAME = "AuthorityInfoAccess";
    private Vector descriptions = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AuthorityInfoAccessExtension";

    public AuthorityInfoAccessExtension(Vector vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthorityInfoAccessExtension", vector);
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = false;
        if (vector == null || vector.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityInfoAccessExtension", "descriptions is null or empty.");
            }
            throw new IllegalArgumentException("descriptions is null or empty.");
        }
        this.descriptions = (Vector)vector.clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    public AuthorityInfoAccessExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityInfoAccessExtension");
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = false;
        this.descriptions = new Vector(1, 1);
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    public AuthorityInfoAccessExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityInfoAccessExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityInfoAccessExtension", "Invalid encoding for AuthorityInfoAccessExtension.");
            }
            throw new IOException("Invalid encoding for AuthorityInfoAccessExtension.");
        }
        this.descriptions = new Vector(1, 1);
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            AccessDescription accessDescription = new AccessDescription(derValue2.toByteArray());
            this.descriptions.addElement(accessDescription);
        }
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.descriptions == null) {
            if (debug != null) {
                debug.exit(16384L, className, "toString_1");
            }
            return "";
        }
        String string = super.toString() + "AuthorityInfoAccess [\r\n" + this.descriptions.toString() + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (!(object instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
            this.descriptions = object != null ? (Vector)((Vector)object).clone() : null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (this.descriptions != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.descriptions.clone());
                }
                return this.descriptions.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.descriptions);
            }
            return this.descriptions;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.descriptions = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(AUTHORITY_INFO_ACCESS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.descriptions == null || this.descriptions.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.descriptions.size(); ++i) {
            ((AccessDescription)this.descriptions.elementAt(i)).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }
}

