/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;

public final class DNSName
implements GeneralNameInterface {
    private String name;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DNSName";
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public DNSName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DNSName", derValue);
        }
        this.name = derValue.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "DNSName");
        }
    }

    public DNSName(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DNSName", string);
        }
        if (string == null || string.length() == 0) {
            throw new IOException("DNS name must not be null");
        }
        if (string.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(46, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n2 - n < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (alpha.indexOf(string.charAt(n)) < 0) {
                throw new IOException("DNSName components must begin with a letter");
            }
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (alphaDigitsAndHyphen.indexOf(c) >= 0) continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            n = n2 + 1;
        }
        this.name = string;
        if (debug != null) {
            debug.exit(16384L, className, "DNSName");
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 2);
        }
        return 2;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putIA5String(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "DNSName: " + this.name);
        }
        return "DNSName: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DNSName)) {
            return false;
        }
        DNSName dNSName = (DNSName)object;
        return this.name.equalsIgnoreCase(dNSName.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 2 ? -1 : ((string2 = ((DNSName)generalNameInterface).getName().toLowerCase()).equals(string = this.name.toLowerCase()) ? 0 : (string.endsWith(string2) ? (string.charAt((n2 = string.lastIndexOf(string2)) - 1) == '.' ? 2 : 3) : (string2.endsWith(string) ? (string2.charAt((n = string2.lastIndexOf(string)) - 1) == '.' ? 1 : 3) : 3))));
        return n3;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        String string = this.name;
        int n = 1;
        while (string.lastIndexOf(46) >= 0) {
            string = string.substring(0, string.lastIndexOf(46));
            ++n;
        }
        return n;
    }
}

