/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import java.io.IOException;

public final class GeneralName
implements GeneralNameInterface {
    private GeneralNameInterface name = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralName";

    public GeneralName(GeneralNameInterface generalNameInterface) {
        if (debug != null) {
            debug.entry(16384L, className, "GeneralName");
            debug.exit(16384L, className, "GeneralName");
        }
        this.name = generalNameInterface;
    }

    public GeneralName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralName", derValue);
        }
        short s = (byte)(derValue.getTag() & 0x1F);
        switch (s) {
            case 0: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new OtherName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of Other-Name");
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new RFC822Name(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of RFC822 name");
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new DNSName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of DNS name");
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new URIName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of URI");
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)4);
                    this.name = new IPAddressName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of IP address");
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)6);
                    this.name = new OIDName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of OID name");
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    this.name = new X500Name(derValue.getData());
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of Directory name");
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new EDIPartyName(derValue);
                    break;
                }
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Invalid encoding of EDI name");
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                if (debug != null) {
                    debug.text(16384L, className, "GeneralName", "Unrecognized GeneralName tag, (" + s + ")");
                }
                throw new IOException("Unrecognized GeneralName tag, (" + s + ")");
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralName");
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", this.name.getType());
        }
        return this.name.getType();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.name.toString());
        }
        return this.name.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralName)) {
            return false;
        }
        GeneralNameInterface generalNameInterface = ((GeneralName)object).name;
        try {
            return this.name.constrains(generalNameInterface) == 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.name.encode(derOutputStream2);
        int n = this.name.getType();
        if (n == 4) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream2);
        } else if (n == 0 || n == 3 || n == 5) {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream2);
        } else {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)n), derOutputStream2);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        if (this.name != null) {
            return this.name.constrains(generalNameInterface);
        }
        throw new UnsupportedOperationException("The name of this GeneralName is null");
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        if (this.name != null) {
            return this.name.subtreeDepth();
        }
        throw new UnsupportedOperationException("The name of this GeneralName is null");
    }
}

