/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class InhibitAnyPolicyExtension
extends Extension
implements CertAttrSet {
    public static final String NAME = "InhibitAnyPolicy";
    public static final String NUMBER = "value";
    private BigInteger skipCerts = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.InhibitAnyPolicyExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.skipCerts == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.skipCerts);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public InhibitAnyPolicyExtension(int n) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InhibitAnyPolicyExtension", new Integer(n));
        }
        this.skipCerts = BigInteger.valueOf(n);
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    public InhibitAnyPolicyExtension(BigInteger bigInteger) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InhibitAnyPolicyExtension", bigInteger);
        }
        this.skipCerts = bigInteger;
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    public InhibitAnyPolicyExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "InhibitAnyPolicyExtension", bl, object);
        }
        if (!bl.booleanValue()) {
            if (debug != null) {
                debug.text(16384L, className, "InhibitAnyPolicyExtension", "The InhibitAnyPolicyExtension must be critical");
            }
            throw new IOException("The InhibitAnyPolicyExtension must be critical");
        }
        this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.skipCerts = derValue.getInteger();
        if (debug != null) {
            debug.exit(16384L, className, "InhibitAnyPolicyExtension");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof BigInteger)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type BigInteger.");
                }
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.skipCerts = (BigInteger)object;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.skipCerts == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.skipCerts);
            }
            return this.skipCerts;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InhibitAnyPolicy.");
        }
        this.skipCerts = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "InhibitAnyPolicy: " + (this.skipCerts == null ? "" : this.skipCerts.toString()) + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InhibitAnyPolicy_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

