/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public final class SerialNumber {
    private BigInteger serialNum;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SerialNumber";

    private void construct(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derValue);
        }
        this.serialNum = derValue.getInteger();
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Excess SerialNumber data");
            }
            throw new IOException("Excess SerialNumber data");
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public SerialNumber(BigInteger bigInteger) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", bigInteger);
            debug.exit(16384L, className, "SerialNumber");
        }
        this.serialNum = bigInteger;
    }

    public SerialNumber(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", new Integer(n));
        }
        this.serialNum = BigInteger.valueOf(n);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", derValue);
        }
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public SerialNumber(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SerialNumber", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "SerialNumber");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "SerialNumber: [" + this.serialNum.toString() + "]");
        }
        return "SerialNumber: [" + this.serialNum.toString() + "]";
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putInteger(this.serialNum);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public BigInteger getNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getNumber");
            debug.exit(16384L, (Object)className, "getNumber", this.serialNum);
        }
        return this.serialNum;
    }
}

