/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.RDN;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public final class X500Name
implements Principal,
GeneralNameInterface {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X500Name";
    private String dn = null;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private X500Principal x500Principal;
    private byte[] encoded;
    private volatile List allAvaList;
    private static final Map internedOIDs = new HashMap();
    private static final int[] emailAddress_data = new int[]{1, 2, 840, 113549, 1, 9, 1};
    private static final int[] postalCode_data = new int[]{2, 5, 4, 17};
    private static final int[] serialNumber_data = new int[]{2, 5, 4, 5};
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] surname_data = new int[]{2, 5, 4, 4};
    private static final int[] givenname_data = new int[]{2, 5, 4, 42};
    private static final int[] initials_data = new int[]{2, 5, 4, 43};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    private static final int[] generationQualifier_data = new int[]{2, 5, 4, 44};
    private static final int[] domainComponent_data = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] dnqualifier_data = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static ObjectIdentifier emailAddress_oid;
    public static ObjectIdentifier postalCode_oid;
    public static ObjectIdentifier serialNumber_oid;
    public static ObjectIdentifier commonName_oid;
    public static ObjectIdentifier countryName_oid;
    public static ObjectIdentifier localityName_oid;
    public static ObjectIdentifier orgName_oid;
    public static ObjectIdentifier orgUnitName_oid;
    public static ObjectIdentifier stateName_oid;
    public static ObjectIdentifier streetAddress_oid;
    public static ObjectIdentifier title_oid;
    public static ObjectIdentifier surName_oid;
    public static ObjectIdentifier givenName_oid;
    public static ObjectIdentifier initials_oid;
    public static ObjectIdentifier ipAddress_oid;
    public static ObjectIdentifier dnQualifier_oid;
    public static ObjectIdentifier domainComponent_oid;
    public static ObjectIdentifier generationQualifier_oid;
    public static ObjectIdentifier userid_oid;

    public X500Name(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", string);
        }
        this.parseDN(string);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            debug.entry(16384L, (Object)className, "X500Name", objectArray);
        }
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
            debug.entry(16384L, (Object)className, "X500Name", objectArray);
        }
        this.names = new RDN[5];
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(emailAddress_oid, new DerValue(22, string5));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
            debug.entry(16384L, (Object)className, "X500Name", objectArray);
        }
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string6));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6, string7};
            debug.entry(16384L, (Object)className, "X500Name", objectArray);
        }
        this.names = new RDN[7];
        this.names[6] = new RDN(1);
        this.names[6].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(postalCode_oid, new DerValue(string6));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string7));
    }

    public X500Name(DerValue derValue) throws IOException {
        this(new DerInputStream(derValue.toByteArray()));
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", derValue);
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", derInputStream);
        }
        this.parseDER(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public boolean equals(Object object) {
        Object object2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof X500Name)) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        if (this.canonicalDn != null && x500Name.canonicalDn != null) {
            if (debug != null) {
                debug.entry(16384L, className, "equals: canon", this.canonicalDn, x500Name.canonicalDn);
            }
            return this.canonicalDn.equals(x500Name.canonicalDn);
        }
        int n = this.names.length;
        if (n != x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            object2 = this.names[i];
            RDN rDN = x500Name.names[i];
            if (debug != null) {
                debug.entry(16384L, className, "equals: rdn lengths", object2, rDN);
            }
            if (((RDN)object2).assertion.length == rDN.assertion.length) continue;
            return false;
        }
        String string = this.getRFC2253CanonicalName();
        object2 = x500Name.getRFC2253CanonicalName();
        if (debug != null) {
            debug.entry(16384L, className, "equals: getCanon", string, object2);
        }
        return string.equals(object2);
    }

    List allAvas() {
        ArrayList arrayList = this.allAvaList;
        if (arrayList == null) {
            arrayList = new ArrayList();
            for (int i = 0; i < this.names.length; ++i) {
                arrayList.addAll(this.names[i].avas());
            }
        }
        return arrayList;
    }

    boolean isEmpty() {
        int n = this.names.length;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.names[i].assertion.length == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < this.names.length; ++i) {
            n += this.names[i].hashCode() * n2++;
        }
        if (debug != null) {
            debug.exit(16384L, className, "hashCode");
        }
        return n;
    }

    public boolean equals(X500Name x500Name) {
        Object object;
        if (this.canonicalDn != null && x500Name.canonicalDn != null) {
            if (debug != null) {
                debug.entry(16384L, className, "equals: canon", this.canonicalDn, x500Name.canonicalDn);
            }
            return this.canonicalDn.equals(x500Name.canonicalDn);
        }
        int n = this.names.length;
        if (n != x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            object = this.names[i];
            RDN rDN = x500Name.names[i];
            if (debug != null) {
                debug.entry(16384L, className, "equals: rdn lengths", object, rDN);
            }
            if (((RDN)object).assertion.length == rDN.assertion.length) continue;
            return false;
        }
        String string = this.getRFC2253CanonicalName();
        object = x500Name.getRFC2253CanonicalName();
        if (debug != null) {
            debug.entry(16384L, className, "equals: getCanon", string, object);
        }
        return string.equals(object);
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 4);
        }
        return 4;
    }

    public String getCountry() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCountry");
        }
        DerValue derValue = this.findAttribute(countryName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCountry", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganization");
        }
        DerValue derValue = this.findAttribute(orgName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOrganization", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganizationalUnit");
        }
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOrganizationalUnit", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCommonName");
        }
        DerValue derValue = this.findAttribute(commonName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCommonName", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getLocality");
        }
        DerValue derValue = this.findAttribute(localityName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getLocality", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getState");
        }
        DerValue derValue = this.findAttribute(stateName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getState", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getEmail() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEmail");
        }
        DerValue derValue = this.findAttribute(emailAddress_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEmail", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String getPostalCode() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPostalCode");
        }
        DerValue derValue = this.findAttribute(postalCode_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPostalCode", this.getString(derValue));
        }
        return this.getString(derValue);
    }

    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getName() {
        return this.toString();
    }

    public void emit(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "emit", derOutputStream);
        }
        this.encode(derOutputStream);
        if (debug != null) {
            debug.exit(16384L, className, "emit");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    byte[] getEncodedInternal() throws IOException {
        if (this.encoded == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i].encode(derOutputStream2);
            }
            derOutputStream.write((byte)48, derOutputStream2);
            this.encoded = derOutputStream.toByteArray();
        }
        return this.encoded;
    }

    public byte[] getEncoded() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        byte[] byArray = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getEncoded", (Object)byArray);
        }
        return byArray;
    }

    public int size() {
        return this.names.length;
    }

    public RDN getRDN(int n) {
        return this.names[n];
    }

    public X500Name getParentDn() {
        RDN[] rDNArray = new RDN[this.names.length - 1];
        System.arraycopy(this.names, 0, rDNArray, 0, this.names.length - 1);
        return new X500Name(rDNArray);
    }

    public String getRFC1779Name() {
        if (this.rfc1779Dn == null) {
            this.generateRFC1779DN();
        }
        return this.rfc1779Dn;
    }

    public String getRFC2253Name() {
        if (this.rfc2253Dn != null) {
            return this.rfc2253Dn;
        }
        if (this.names.length == 0) {
            this.rfc2253Dn = "";
            return this.rfc2253Dn;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        for (int i = this.names.length - 1; i >= 0; --i) {
            if (i < this.names.length - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.names[i].toRFC2253String());
        }
        this.rfc2253Dn = new String(stringBuffer);
        return this.rfc2253Dn;
    }

    public String getRFC2253CanonicalName() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRFC2254CanonName()", this.canonicalDn);
        }
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (this.names.length == 0) {
            this.canonicalDn = "";
            if (debug != null) {
                debug.entry(16384L, (Object)className, "getRFC2254CanonName()", "canonicalDn == null");
            }
            return this.canonicalDn;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        for (int i = this.names.length - 1; i >= 0; --i) {
            if (i < this.names.length - 1) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.names[i].toRFC2253String(true));
        }
        this.canonicalDn = new String(stringBuffer);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRFC2254CanonName() new Canon", this.canonicalDn);
        }
        return this.canonicalDn;
    }

    private void generateRFC1779DN() {
        if (this.names.length == 1) {
            this.rfc1779Dn = this.names[0].toRFC1779String();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                if (i != this.names.length - 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.names[i].toRFC1779String());
            }
        }
        this.rfc1779Dn = stringBuffer.toString();
    }

    public boolean isAbove(X500Name x500Name) {
        while (this.size() < x500Name.size()) {
            x500Name = x500Name.getParentDn();
        }
        return this.equals(x500Name);
    }

    public X500Name(RDN[] rDNArray) {
        if (rDNArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = (RDN[])rDNArray.clone();
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] != null) continue;
                throw new NullPointerException("RDN[] contains null");
            }
        }
    }

    private void parseDN(String string) throws IOException {
        RDN rDN;
        String string2;
        if (string == null || string.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        Vector<RDN> vector = new Vector<RDN>();
        int n = 0;
        int n2 = 0;
        String string3 = string;
        int n3 = 0;
        int n4 = string3.indexOf(44);
        int n5 = string3.indexOf(59);
        while (n4 >= 0 || n5 >= 0) {
            int n6 = n5 < 0 ? n4 : (n4 < 0 ? n5 : Math.min(n4, n5));
            if (n6 >= 0 && (n2 += X500Name.countQuotes(string3, n3, n6)) != 1 && !X500Name.escaped(n6, n3, string3)) {
                string2 = string3.substring(n, n6);
                rDN = new RDN(string2);
                vector.addElement(rDN);
                n = n6 + 1;
                n2 = 0;
            }
            n3 = n6 + 1;
            n4 = string3.indexOf(44, n3);
            n5 = string3.indexOf(59, n3);
        }
        string2 = string3.substring(n);
        rDN = new RDN(string2);
        vector.addElement(rDN);
        int n7 = vector.size();
        this.names = new RDN[n7];
        Enumeration enumeration = vector.elements();
        int n8 = n7 - 1;
        while (enumeration.hasMoreElements()) {
            this.names[n8--] = (RDN)enumeration.nextElement();
        }
    }

    static int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n3;
        }
        return n3;
    }

    private static boolean escaped(int n, int n2, String string) {
        if (n == 1 && string.charAt(n - 1) == '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) != '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) == '\\') {
            int n3 = 0;
            --n;
            while (n >= n2) {
                if (string.charAt(n) == '\\') {
                    ++n3;
                }
                --n;
            }
            return n3 % 2 != 0;
        }
        return false;
    }

    private void generateDN() {
        if (this.names.length == 1) {
            this.dn = this.names[0].toString();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        for (int i = this.names.length - 1; i >= 0; --i) {
            if (i != this.names.length - 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.names[i].toString());
        }
        this.dn = stringBuffer.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        for (int i = 0; i < this.names.length; ++i) {
            DerValue derValue = this.names[i].findAttribute(objectIdentifier);
            if (derValue == null) continue;
            return derValue;
        }
        return null;
    }

    public DerValue findMostSpecificAttribute(ObjectIdentifier objectIdentifier) {
        for (int i = this.names.length - 1; i >= 0; --i) {
            DerValue derValue = this.names[i].findAttribute(objectIdentifier);
            if (derValue == null) continue;
            return derValue;
        }
        return null;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = null;
        byte[] byArray = derInputStream.toByteArray();
        try {
            derValueArray = derInputStream.getSequence(5);
        }
        catch (IOException iOException) {
            if (byArray == null) {
                derValueArray = null;
            }
            DerValue derValue = new DerValue(48, byArray);
            byArray = derValue.toByteArray();
            derValueArray = new DerInputStream(byArray).getSequence(5);
        }
        if (derValueArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = new RDN[derValueArray.length];
            for (int i = 0; i < derValueArray.length; ++i) {
                this.names[i] = new RDN(derValueArray[i]);
            }
        }
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.getTag());
        }
        return string;
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.equals(commonName_oid)) {
            return commonName_oid;
        }
        if (objectIdentifier.equals(countryName_oid)) {
            return countryName_oid;
        }
        if (objectIdentifier.equals(localityName_oid)) {
            return localityName_oid;
        }
        if (objectIdentifier.equals(stateName_oid)) {
            return stateName_oid;
        }
        if (objectIdentifier.equals(streetAddress_oid)) {
            return streetAddress_oid;
        }
        if (objectIdentifier.equals(orgName_oid)) {
            return orgName_oid;
        }
        if (objectIdentifier.equals(orgUnitName_oid)) {
            return orgUnitName_oid;
        }
        if (objectIdentifier.equals(title_oid)) {
            return title_oid;
        }
        if (objectIdentifier.equals(ipAddress_oid)) {
            return ipAddress_oid;
        }
        if (objectIdentifier.equals(emailAddress_oid)) {
            return emailAddress_oid;
        }
        if (objectIdentifier.equals(serialNumber_oid)) {
            return serialNumber_oid;
        }
        if (objectIdentifier.equals(domainComponent_oid)) {
            return domainComponent_oid;
        }
        if (objectIdentifier.equals(postalCode_oid)) {
            return postalCode_oid;
        }
        return objectIdentifier;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        X500Name x500Name;
        int n = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 4 ? -1 : ((x500Name = (X500Name)generalNameInterface).equals(this) ? 0 : (x500Name.names.length == 0 ? 2 : (this.names.length == 0 ? 1 : (x500Name.isWithinSubtree(this) ? 1 : (this.isWithinSubtree(x500Name) ? 2 : 3))))));
        return n;
    }

    private boolean isWithinSubtree(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (x500Name == null) {
            return false;
        }
        if (x500Name.names.length == 0) {
            return true;
        }
        if (this.names.length == 0) {
            return false;
        }
        if (this.names.length < x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < x500Name.names.length; ++i) {
            if (this.names[i].equals(x500Name.names[i])) continue;
            return false;
        }
        return true;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        return this.names.length;
    }

    static {
        try {
            emailAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(emailAddress_data));
            postalCode_oid = X500Name.intern(ObjectIdentifier.newInternal(postalCode_data));
            serialNumber_oid = X500Name.intern(ObjectIdentifier.newInternal(serialNumber_data));
            commonName_oid = X500Name.intern(ObjectIdentifier.newInternal(commonName_data));
            countryName_oid = X500Name.intern(ObjectIdentifier.newInternal(countryName_data));
            localityName_oid = X500Name.intern(ObjectIdentifier.newInternal(localityName_data));
            orgName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgName_data));
            orgUnitName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgUnitName_data));
            stateName_oid = X500Name.intern(ObjectIdentifier.newInternal(stateName_data));
            streetAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(streetAddress_data));
            title_oid = X500Name.intern(ObjectIdentifier.newInternal(title_data));
            surName_oid = X500Name.intern(ObjectIdentifier.newInternal(surname_data));
            givenName_oid = X500Name.intern(ObjectIdentifier.newInternal(givenname_data));
            initials_oid = X500Name.intern(ObjectIdentifier.newInternal(initials_data));
            ipAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(ipAddress_data));
            dnQualifier_oid = X500Name.intern(ObjectIdentifier.newInternal(dnqualifier_data));
            domainComponent_oid = X500Name.intern(ObjectIdentifier.newInternal(domainComponent_data));
            generationQualifier_oid = X500Name.intern(ObjectIdentifier.newInternal(generationQualifier_data));
            userid_oid = X500Name.intern(ObjectIdentifier.newInternal(userid_data));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

