/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.IssuerAlternativeNameExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509AttributeName;
import com.ibm.security.x509.X509CertInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class X509CertImpl
extends X509Certificate
implements DerEncoder {
    static final long serialVersionUID = -5820390314598772321L;
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly = false;
    private String provider = null;
    private byte[] signedCert = null;
    protected X509CertInfo info = null;
    protected AlgorithmId algId = null;
    protected byte[] signature = null;
    private List extKeyUsage;
    public static final String KEY_USAGE_OID = "2.5.29.15";
    public static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    public static final String SUB_ALT_NAME_OID = "2.5.29.17";
    public static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    public static final String ISSUER_ALT_NAME_OID = "2.5.29.18";
    private static final int NUM_STANDARD_KEY_USAGE = 9;
    private Collection subjectAlternativeNames;
    private Collection issuerAlternativeNames;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private boolean verificationResult;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CertImpl";

    public X509CertImpl(byte[] byArray) throws CertificateException {
        this(byArray, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", (Object)byArray);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(byte[] byArray, String string) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", byArray, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + iOException);
            }
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + iOException);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(InputStream inputStream) throws CertificateException {
        this(inputStream, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", inputStream);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(InputStream inputStream, String string) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", inputStream, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        try {
            this.parse(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            this.signedCert = null;
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + iOException);
            }
            throw new CertificateException("Unable to initialize, " + iOException);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(X509CertInfo x509CertInfo) throws CertificateParsingException, CertificateEncodingException {
        this(x509CertInfo, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", x509CertInfo);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(X509CertInfo x509CertInfo, String string) throws CertificateParsingException, CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", x509CertInfo, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.info = x509CertInfo != null ? (this.provider != null ? new X509CertInfo(x509CertInfo.getEncodedInfo(), this.provider) : new X509CertInfo(x509CertInfo.getEncodedInfo())) : x509CertInfo;
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(DerValue derValue) throws CertificateException {
        this(derValue, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", derValue);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(DerValue derValue, String string) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", derValue, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCert = null;
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + iOException);
            }
            throw new CertificateException("Unable to initialize, " + iOException);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public void encode(OutputStream outputStream) throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null certificate to encode");
            }
            throw new CertificateEncodingException("Null certificate to encode");
        }
        try {
            outputStream.write((byte[])this.signedCert.clone());
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", iOException);
            }
            throw new CertificateEncodingException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "derEncode", "Null certificate to encode");
            }
            throw new IOException("Null certificate to encode");
        }
        outputStream.write((byte[])this.signedCert.clone());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncodedInternal() throws CertificateEncodingException {
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "getEncoded", "Null certificate to encode");
            }
            throw new CertificateEncodingException("Null certificate to encode");
        }
        byte[] byArray = (byte[])this.signedCert.clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", byArray);
        }
        return byArray;
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", publicKey);
        }
        this.verify(publicKey, "");
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public synchronized void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", publicKey, string);
        }
        if (string == null) {
            string = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(publicKey) && string.equals(this.verifiedProvider)) {
            if (this.verificationResult) {
                return;
            }
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized certificate");
            }
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature signature = null;
        signature = string.length() == 0 ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), string);
        signature.initVerify(publicKey);
        byte[] byArray = this.info.getEncodedInfo();
        signature.update(byArray, 0, byArray.length);
        this.verificationResult = signature.verify(this.signature);
        this.verifiedPublicKey = publicKey;
        this.verifiedProvider = string;
        if (!this.verificationResult) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", privateKey, string);
        }
        this.sign(privateKey, string, null);
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Object object;
        if (debug != null) {
            object = new Object[]{privateKey, string, string2};
            debug.entry(16384L, (Object)className, "sign", (Object[])object);
        }
        try {
            if (this.readOnly) {
                if (debug != null) {
                    debug.text(16384L, className, "sign", "cannot over-write existing certificate");
                }
                throw new CertificateEncodingException("cannot over-write existing certificate");
            }
            object = null;
            object = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            ((Signature)object).initSign(privateKey);
            this.algId = AlgorithmId.get(((Signature)object).getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.info.encode(derOutputStream2);
            byte[] byArray = derOutputStream2.toByteArray();
            this.algId.encode(derOutputStream2);
            ((Signature)object).update(byArray, 0, byArray.length);
            this.signature = ((Signature)object).sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCert = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.text(16384L, className, "sign", iOException.toString());
            }
            throw new CertificateEncodingException(iOException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        if (debug != null) {
            debug.entry(16384L, className, "checkValidity");
        }
        Date date = new Date();
        this.checkValidity(date);
        if (debug != null) {
            debug.exit(16384L, className, "checkValidity");
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "checkValidity", date);
        }
        CertificateValidity certificateValidity = null;
        try {
            certificateValidity = (CertificateValidity)this.info.get("validity");
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "checkValidity", "Incorrect validity period");
            }
            throw new CertificateNotYetValidException("Incorrect validity period");
        }
        if (certificateValidity == null) {
            if (debug != null) {
                debug.text(16384L, className, "checkValidity", "Null validity period");
            }
            throw new CertificateNotYetValidException("Null validity period");
        }
        certificateValidity.valid(date);
        if (debug != null) {
            debug.exit(16384L, className, "checkValidity");
        }
    }

    public Object get(String string) throws CertificateParsingException {
        X509AttributeName x509AttributeName;
        String string2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (!(string2 = (x509AttributeName = new X509AttributeName(string)).getPrefix()).equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "get", "Invalid root of attribute name, expected [x509], received [" + string2 + "]");
            }
            throw new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + string2 + "]");
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (this.info == null) {
                return null;
            }
            if (x509AttributeName.getSuffix() != null) {
                try {
                    return this.info.get(x509AttributeName.getSuffix());
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "get", iOException);
                    }
                    throw new CertificateParsingException(iOException.toString());
                }
                catch (CertificateException certificateException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "get", certificateException);
                    }
                    throw new CertificateParsingException(certificateException.toString());
                }
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.info);
            }
            return this.info;
        }
        if (string2.equalsIgnoreCase(ALG_ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.algId);
            }
            return this.algId;
        }
        if (string2.equalsIgnoreCase(SIGNATURE)) {
            if (this.signature == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_3", null);
                }
                return null;
            }
            byte[] byArray = new byte[this.signature.length];
            System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", byArray);
            }
            return byArray;
        }
        if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            if (this.signedCert == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_5", null);
                }
                return null;
            }
            byte[] byArray = new byte[this.signedCert.length];
            System.arraycopy(this.signedCert, 0, byArray, 0, byArray.length);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", byArray);
            }
            return byArray;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized or get() not allowed for the same: " + string2);
        }
        throw new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + string2);
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "set", "cannot over-write existing certificate");
            }
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Invalid root of attribute name, expected [x509], received " + string2);
            }
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + string2);
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() == null) {
                if (!(object instanceof X509CertInfo)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type X509CertInfo.");
                    }
                    throw new CertificateException("Attribute value should be of type X509CertInfo.");
                }
                if (object != null) {
                    X509CertInfo x509CertInfo = (X509CertInfo)object;
                    this.info = this.provider != null ? new X509CertInfo(x509CertInfo.getEncodedInfo(), this.provider) : new X509CertInfo(x509CertInfo.getEncodedInfo());
                } else {
                    this.info = (X509CertInfo)object;
                }
                this.signedCert = null;
            } else {
                if (this.info == null) {
                    this.info = this.provider != null ? new X509CertInfo(this.provider) : new X509CertInfo();
                }
                this.info.set(x509AttributeName.getSuffix(), object);
                this.signedCert = null;
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized or set() not allowed for the same: " + string2);
            }
            throw new CertificateException("Attribute name not recognized or set() not allowed for the same: " + string2);
        }
    }

    public void delete(String string) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "cannot over-write existing certificate");
            }
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Invalid root of attribute name, expected [x509], received " + string2);
            }
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + string2);
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() != null) {
                this.info = null;
            } else {
                this.info.delete(x509AttributeName.getSuffix());
            }
        } else if (string2.equalsIgnoreCase(ALG_ID)) {
            this.algId = null;
        } else if (string2.equalsIgnoreCase(SIGNATURE)) {
            this.signature = null;
        } else if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized or delete() not allowed for the same: " + string2);
            }
            throw new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + string2);
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement("x509.info");
        attributeNameEnumeration.addElement(SIG_ALG);
        attributeNameEnumeration.addElement(SIG);
        attributeNameEnumeration.addElement("x509.signed_cert");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public String toString() {
        if (this.info == null || this.algId == null || this.signature == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\r\n");
        stringBuffer.append(this.info.toString() + "\r\n");
        stringBuffer.append("  Algorithm: [" + this.algId.toString() + "]\r\n");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        stringBuffer.append("  Signature:\r\n" + hexDumpEncoder.encodeBuffer(this.signature));
        stringBuffer.append("\r\n]");
        return stringBuffer.toString();
    }

    public PublicKey getPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKey");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_1", null);
            }
            return null;
        }
        try {
            PublicKey publicKey = (PublicKey)this.info.get("key.value");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_2", publicKey);
            }
            return publicKey;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getPublicKey", exception);
                debug.exit(16384L, (Object)className, "getPublicKey_3", null);
            }
            return null;
        }
    }

    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getVersion_1", new Integer(-1));
            }
            return -1;
        }
        try {
            int n = (Integer)this.info.get("version.number");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getVersion_2", new Integer(n + 1));
            }
            return n + 1;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getVersion", exception);
                debug.exit(16384L, (Object)className, "getVersion_3", new Integer(-1));
            }
            return -1;
        }
    }

    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSerialNumber_1", null);
            }
            return null;
        }
        try {
            SerialNumber serialNumber = (SerialNumber)this.info.get("serialNumber.number");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSerialNumber_2", serialNumber.getNumber());
            }
            return serialNumber.getNumber();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getSerialNumber", exception);
                debug.exit(16384L, (Object)className, "getSerialNumber_3", null);
            }
            return null;
        }
    }

    public Principal getSubjectDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectDN");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_1", null);
            }
            return null;
        }
        try {
            Principal principal = (Principal)this.info.get("subject.dname");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_2", principal);
            }
            return principal;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (debug != null) {
                debug.text(16384L, className, "getSubjectDN", exception.toString());
                debug.exit(16384L, (Object)className, "getSubjectDN_3", null);
            }
            return null;
        }
    }

    public Principal getIssuerDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectDN");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_1", null);
            }
            return null;
        }
        try {
            Principal principal = (Principal)this.info.get("issuer.dname");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_2", principal);
            }
            return principal;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectDN", exception);
                debug.exit(16384L, (Object)className, "getSubjectDN_3", null);
            }
            return null;
        }
    }

    public Date getNotBefore() {
        if (debug != null) {
            debug.entry(16384L, className, "getNotBefore");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotBefore_1", null);
            }
            return null;
        }
        try {
            Date date = (Date)this.info.get("validity.notBefore");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotBefore_2", date);
            }
            return date;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getNotBefore", exception);
                debug.exit(16384L, (Object)className, "getNotBefore_3", null);
            }
            return null;
        }
    }

    public Date getNotAfter() {
        if (debug != null) {
            debug.entry(16384L, className, "getNotAfter");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotAfter_1", null);
            }
            return null;
        }
        try {
            Date date = (Date)this.info.get("validity.notAfter");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotAfter_2", date);
            }
            return date;
        }
        catch (Exception exception) {
            debug.exception(16384L, className, "getNotAfter", exception);
            debug.exit(16384L, (Object)className, "getNotAfter_3", null);
            return null;
        }
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getTBSCertificate");
        }
        if (this.info != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTBSCertificate", this.info.getEncodedInfo());
            }
            return this.info.getEncodedInfo();
        }
        if (debug != null) {
            debug.text(16384L, className, "getTBSCertificate", "Uninitialized certificate");
        }
        throw new CertificateEncodingException("Uninitialized certificate");
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature_1", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", byArray);
        }
        return byArray;
    }

    public String getSigAlgName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgName");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgName_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgName", this.algId.getName());
        }
        return this.algId.getName();
    }

    public String getSigAlgOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgOID");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgOID_1", null);
            }
            return null;
        }
        ObjectIdentifier objectIdentifier = this.algId.getOID();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgOID_2", objectIdentifier.toString());
        }
        return objectIdentifier.toString();
    }

    public byte[] getSigAlgParams() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgParams");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams_1", null);
            }
            return null;
        }
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams_2", this.algId.getEncodedParams());
            }
            return this.algId.getEncodedParams();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSigAlgParams", iOException);
                debug.exit(16384L, (Object)className, "getSigAlgParams_3", null);
            }
            return null;
        }
    }

    public boolean[] getIssuerUniqueID() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerUniqueID");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuerUniqueID_1", null);
            }
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)this.info.get("issuerID.id");
            if (uniqueIdentity == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getIssuerUniqueID_2", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuerUniqueID", uniqueIdentity.getId());
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getIssuerUniqueID", exception);
                debug.exit(16384L, (Object)className, "getIssuerUniqueID_3", null);
            }
            return null;
        }
    }

    public boolean[] getSubjectUniqueID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectUniqueID");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectUniqueID_1", null);
            }
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)this.info.get("subjectID.id");
            if (uniqueIdentity == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getSubjectUniqueID_2", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectUniqueID", uniqueIdentity.getId());
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectUniqueID", exception);
                debug.exit(16384L, (Object)className, "getSubjectUniqueID_3", null);
            }
            return null;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_1", new Boolean(false));
            }
            return false;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_2", new Boolean(false));
                }
                return false;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(certificateExtensions.hasUnsupportedCriticalExtension()));
            }
            return certificateExtensions.hasUnsupportedCriticalExtension();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_3", new Boolean(false));
            }
            return false;
        }
    }

    public Set getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_2", null);
                }
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>(11);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                if (!extension.isCritical()) continue;
                hashSet.add(extension.getExtensionId().toString());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", hashSet);
            }
            return hashSet;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getCriticalExtensionOIDs", exception);
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_3", null);
            }
            return null;
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_2", null);
                }
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>(11);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                if (extension.isCritical()) continue;
                hashSet.add(extension.getExtensionId().toString());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", hashSet);
            }
            return hashSet;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getNonCriticalExtensionOIDs", exception);
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_3", null);
            }
            return null;
        }
    }

    SubjectAlternativeNameExtension getSubjectAlternativeNameExtension() {
        return (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id);
    }

    private ExtKeyUsageExtension getExtendedKeyUsageExtension() {
        return (ExtKeyUsageExtension)this.getExtension(PKIXExtensions.ExtendedKeyUsage_Id);
    }

    private NameConstraintsExtension getNameConstraintsExtension() {
        return (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id);
    }

    public IssuerAlternativeNameExtension getIssuerAlternativeNameExtension() {
        return (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
    }

    public synchronized Collection getIssuerAlternativeNames() throws CertificateParsingException {
        GeneralNames generalNames;
        if (this.readOnly && this.issuerAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.issuerAlternativeNames);
        }
        IssuerAlternativeNameExtension issuerAlternativeNameExtension = this.getIssuerAlternativeNameExtension();
        if (issuerAlternativeNameExtension == null) {
            return null;
        }
        try {
            generalNames = (GeneralNames)issuerAlternativeNameExtension.get("issuer_name");
        }
        catch (IOException iOException) {
            return Collections.EMPTY_SET;
        }
        this.issuerAlternativeNames = X509CertImpl.makeAltNames(generalNames);
        return this.issuerAlternativeNames;
    }

    public static Collection getIssuerAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            GeneralNames generalNames;
            byte[] byArray = x509Certificate.getExtensionValue(ISSUER_ALT_NAME_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            IssuerAlternativeNameExtension issuerAlternativeNameExtension = new IssuerAlternativeNameExtension(Boolean.FALSE, byArray2);
            try {
                generalNames = (GeneralNames)issuerAlternativeNameExtension.get("issuer_name");
            }
            catch (IOException iOException) {
                return Collections.EMPTY_SET;
            }
            return X509CertImpl.makeAltNames(generalNames);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.getMessage());
            throw certificateParsingException;
        }
    }

    private CertificatePoliciesExtension getCertificatePoliciesExtension() {
        return (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id);
    }

    private PrivateKeyUsageExtension getPrivateKeyUsageExtension() {
        return (PrivateKeyUsageExtension)this.getExtension(PKIXExtensions.PrivateKeyUsage_Id);
    }

    private static Collection cloneAltNames(Collection collection) {
        Collection<List<List>> collection2;
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !bl) {
            collection2 = (List)iterator.next();
            if (!(collection2.get(1) instanceof byte[])) continue;
            bl = true;
        }
        if (bl) {
            collection2 = new HashSet(collection.size());
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                Object e = list.get(1);
                if (e instanceof byte[]) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(list);
                    arrayList.set(1, ((byte[])e).clone());
                    ((HashSet)collection2).add(Collections.unmodifiableList(arrayList));
                    continue;
                }
                ((HashSet)collection2).add(list);
            }
            return Collections.unmodifiableCollection(collection2);
        }
        return collection;
    }

    private static Collection makeAltNames(GeneralNames generalNames) {
        if (generalNames.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet(generalNames.size());
        Iterator iterator = generalNames.iterator();
        while (iterator.hasNext()) {
            GeneralName generalName = (GeneralName)iterator.next();
            GeneralNameInterface generalNameInterface = generalName.getName();
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(new Integer(generalNameInterface.getType()));
            switch (generalNameInterface.getType()) {
                case 1: {
                    arrayList.add(((RFC822Name)generalNameInterface).getName());
                    break;
                }
                case 2: {
                    arrayList.add(((DNSName)generalNameInterface).getName());
                    break;
                }
                case 4: {
                    arrayList.add(((X500Name)generalNameInterface).getRFC2253Name());
                    break;
                }
                case 6: {
                    arrayList.add(((URIName)generalNameInterface).getName());
                    break;
                }
                case 7: {
                    try {
                        arrayList.add(((IPAddressName)generalNameInterface).getName());
                        break;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("IPAddress cannot be parsed: " + iOException.toString());
                    }
                }
                case 8: {
                    arrayList.add(((OIDName)generalNameInterface).getOID().toString());
                    break;
                }
                default: {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    try {
                        generalNameInterface.encode(derOutputStream);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("name cannot be encoded: " + iOException.toString());
                    }
                    arrayList.add(derOutputStream.toByteArray());
                }
            }
            hashSet.add(Collections.unmodifiableList(arrayList));
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public synchronized Collection getSubjectAlternativeNames() throws CertificateParsingException {
        GeneralNames generalNames;
        if (this.readOnly && this.subjectAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.subjectAlternativeNames);
        }
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = this.getSubjectAlternativeNameExtension();
        if (subjectAlternativeNameExtension == null) {
            return null;
        }
        try {
            generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            if (generalNames == null) {
                return Collections.EMPTY_SET;
            }
        }
        catch (IOException iOException) {
            return Collections.EMPTY_SET;
        }
        this.subjectAlternativeNames = X509CertImpl.makeAltNames(generalNames);
        return this.subjectAlternativeNames;
    }

    public static Collection getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            GeneralNames generalNames;
            byte[] byArray = x509Certificate.getExtensionValue(SUB_ALT_NAME_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(Boolean.FALSE, byArray2);
            try {
                generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                if (generalNames == null) {
                    return Collections.EMPTY_SET;
                }
            }
            catch (IOException iOException) {
                return Collections.EMPTY_SET;
            }
            return X509CertImpl.makeAltNames(generalNames);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            throw certificateParsingException;
        }
    }

    public synchronized List getExtendedKeyUsage() throws CertificateParsingException {
        if (this.readOnly && this.extKeyUsage != null) {
            return this.extKeyUsage;
        }
        ExtKeyUsageExtension extKeyUsageExtension = this.getExtendedKeyUsageExtension();
        if (extKeyUsageExtension == null) {
            return null;
        }
        this.extKeyUsage = Collections.unmodifiableList(extKeyUsageExtension.getExtendedKeyUsage());
        return this.extKeyUsage;
    }

    public static List getExtendedKeyUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(EXTENDED_KEY_USAGE_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            ExtKeyUsageExtension extKeyUsageExtension = new ExtKeyUsageExtension(Boolean.FALSE, byArray2);
            return Collections.unmodifiableList(extKeyUsageExtension.getExtendedKeyUsage());
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            throw certificateParsingException;
        }
    }

    public byte[] getExtensionValue(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", string);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string);
            String string2 = OIDMap.getName(objectIdentifier);
            Object object4 = null;
            if (string2 == null) {
                object3 = (CertificateExtensions)this.info.get("extensions");
                if (object3 == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
                    }
                    return null;
                }
                object2 = null;
                Enumeration enumeration = ((CertificateExtensions)object3).getElements();
                while (enumeration.hasMoreElements()) {
                    object2 = (Extension)enumeration.nextElement();
                    object = ((Extension)object2).getExtensionId();
                    if (!((ObjectIdentifier)object).equals(objectIdentifier)) continue;
                    object4 = object2;
                    break;
                }
            } else {
                object4 = (Extension)this.get(string2);
            }
            if (object4 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            object3 = ((Extension)object4).getExtensionValue();
            if (object3 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            object2 = new DerOutputStream();
            ((DerOutputStream)object2).putOctetString((byte[])object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_3", object);
            }
            return object;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", exception);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    public boolean[] getKeyUsage() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyUsage");
        }
        try {
            String string = OIDMap.getName(PKIXExtensions.KeyUsage_Id);
            if (string == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getKeyUsage_1", null);
                }
                return null;
            }
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.get(string);
            if (keyUsageExtension == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getKeyUsage_2", null);
                }
                return null;
            }
            boolean[] blArray = keyUsageExtension.getBits();
            if (blArray.length < 9) {
                boolean[] blArray2 = new boolean[9];
                System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
                blArray = blArray2;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyUsage", blArray);
            }
            return blArray;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getKeyUsage", exception);
                debug.exit(16384L, (Object)className, "getKeyUsage_3", null);
            }
            return null;
        }
    }

    public int getBasicConstraints() {
        if (debug != null) {
            debug.entry(16384L, className, "getBasicConstraints");
        }
        try {
            String string = OIDMap.getName(PKIXExtensions.BasicConstraints_Id);
            if (string == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints_1", new Integer(-1));
                }
                return -1;
            }
            BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.get(string);
            if (basicConstraintsExtension == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints_2", new Integer(-1));
                }
                return -1;
            }
            if (((Boolean)basicConstraintsExtension.get("is_ca")).booleanValue()) {
                int n = (Integer)basicConstraintsExtension.get("path_len");
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints", new Integer(n));
                }
                return n;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getBasicConstraints_3", new Integer(-1));
            }
            return -1;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getBasicConstraints", exception);
                debug.exit(16384L, (Object)className, "getBasicConstraints_4", new Integer(-1));
            }
            return -1;
        }
    }

    private void parse(DerValue derValue) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", derValue);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "cannot over-write existing certificate");
            }
            throw new CertificateParsingException("cannot over-write existing certificate");
        }
        if (derValue.getData() == null) {
            throw new CertificateParsingException("invalid DER-encoded certificate data");
        }
        this.signedCert = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.getData().getDerValue(), derValue.getData().getDerValue(), derValue.getData().getDerValue()};
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed overrun, bytes = " + derValue.getData().available());
            }
            throw new CertificateParsingException("signed overrun, bytes = " + derValue.getData().available());
        }
        if (derValueArray[0].getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields invalid");
            }
            throw new CertificateParsingException("signed fields invalid");
        }
        this.algId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "algid field overrun");
            }
            throw new CertificateParsingException("algid field overrun");
        }
        if (derValueArray[2].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields overrun");
            }
            throw new CertificateParsingException("signed fields overrun");
        }
        this.info = this.provider != null ? new X509CertInfo(derValueArray[0], this.provider) : new X509CertInfo(derValueArray[0]);
        AlgorithmId algorithmId = (AlgorithmId)this.info.get("algorithmID.algorithm");
        if (!this.algId.equals(algorithmId)) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "Signature algorithm mismatch");
            }
            throw new CertificateException("Signature algorithm mismatch");
        }
        this.readOnly = true;
        if (debug != null) {
            debug.exit(16384L, className, "parse");
        }
    }

    public Extension getExtension(ObjectIdentifier objectIdentifier) {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = null;
            try {
                certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            }
            catch (CertificateException certificateException) {
                return null;
            }
            if (certificateExtensions == null) {
                return null;
            }
            Extension extension = null;
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                extension = (Extension)enumeration.nextElement();
                if (!extension.getExtensionId().equals(objectIdentifier)) continue;
                return extension;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static X509CertImpl toImpl(X509Certificate x509Certificate) throws CertificateException {
        if (x509Certificate instanceof X509CertImpl) {
            return (X509CertImpl)x509Certificate;
        }
        byte[] byArray = x509Certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        return x509CertImpl;
    }
}

