/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.dump.frame.FrameTraverser;
import com.ibm.jvm.dump.frame.JavaFrame;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.frame.NativeFrame;
import com.ibm.jvm.dump.frame.TargetReader;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.sdff.SDFFClock;
import com.ibm.jvm.dump.sdff.SDFFJavaStack;
import com.ibm.jvm.dump.sdff.SDFFNativeStack;
import com.ibm.jvm.dump.sdff.SDFFRas;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Extract {
    public static final int ERROR_NODUMP = -1;
    public static final int ERROR_NOSUPPORT = -2;
    public static final int ERROR_DUMPCORRUPT = -3;
    public static final int ERROR_DUMPTRUNCATED = -4;
    private boolean doBasicOnly = false;
    private SDFFClock clock = null;
    private static int trace = 0;
    private long currentBytesWritten = 0L;
    private long savedBytesWritten = 0L;
    private static int increment1 = 50000;
    private static int increment2 = 100000;
    private boolean useIncrement2 = false;
    Sdff SDFFfile = null;
    private long currFileLengthPtr = 0L;
    private static String sdffHeaderName;
    private static String coreName;
    private static String libPath;
    private static boolean headerOnly;
    private SDFFMemRanges[] ranges = null;
    private int nRanges = 0;
    private boolean frameSetup = false;
    private static FrameTraverser frameTraverser;
    static /* synthetic */ Class class$com$ibm$jvm$dump$extract$Extract$SDFFREGISTER;

    Extract(int n, String string, String string2, String string3, String string4, boolean bl, int n2, boolean bl2) {
        libPath = string4;
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format version" + n2);
            }
        }
        trace = n;
        coreName = string;
        sdffHeaderName = n2 == 0 ? string2 : string2 + ".hdr";
        headerOnly = bl;
        if (!this.createSDFFfile()) {
            System.err.println("Jextract:Can't create dump file !");
            return;
        }
        int n3 = this.doExtract(n, string);
        if (n3 < 0) {
            if (n3 != -4) {
                return;
            }
            this.doBasicOnly = true;
        }
        if (n > 0) {
            System.out.println("Dumping sys info..");
        }
        this.dumpSysInfo();
        this.dumpRas();
        if (n > 0) {
            System.out.println("Dumping process & Thread info..");
        }
        this.dumpProcessThread();
        if (n2 == 0) {
            this.useIncrement2 = true;
            if (n > 0) {
                System.out.println("Dumping memory info..");
            }
            this.dumpMemory();
            this.closeDump();
            return;
        }
        if (n > 0) {
            System.out.println("Dumping memory info..");
        }
        this.dumpMmapOnly();
        this.closeDump();
        try {
            this.SDFFfile.close();
        }
        catch (IOException iOException) {
            System.err.println("JVMRAS07: Error closing SDFF header");
            iOException.printStackTrace();
            return;
        }
        File file = new File(sdffHeaderName);
        File file2 = new File(string);
        SdffArchiveOutputStream sdffArchiveOutputStream = new SdffArchiveOutputStream(string2, file, file2);
        try {
            sdffArchiveOutputStream.putFile(new File(sdffHeaderName), "SDFF Header");
        }
        catch (IOException iOException) {
            System.err.println("JVMRAS05: Couldn't write SDFF header to Jar file");
            iOException.printStackTrace();
            return;
        }
        try {
            sdffArchiveOutputStream.putFile(new File(string), "Original Dump");
        }
        catch (IOException iOException) {
            System.err.println("JVMRAS06: Couldn't write original dump to Jar file");
            iOException.printStackTrace();
            return;
        }
        if (bl2) {
            // empty if block
        }
        sdffArchiveOutputStream.close();
    }

    private long getFilePointer() {
        long l = -1L;
        try {
            l = this.SDFFfile.getFilePointer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    private void writeLength(long l) {
        long l2 = -1L;
        try {
            l2 = this.SDFFfile.getFilePointer();
            this.SDFFfile.seek(this.currFileLengthPtr);
            this.sdffWriteLong(l);
            this.SDFFfile.seek(l2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean createSDFFfile() {
        try {
            this.SDFFfile = new Sdff(sdffHeaderName);
        }
        catch (Exception exception) {
            System.err.println("Jextract:Can't make new SDFF");
            return false;
        }
        return true;
    }

    private native int doExtract(int var1, String var2);

    private native void closeDump();

    private native int getSubsystem();

    private native int getArchitecture();

    private native void setTraceLevel(int var1);

    private native int getMemoryRangeCount();

    private void writeNullMetaData() {
        try {
            this.sdffWriteLong(-1L);
        }
        catch (Exception exception) {
            System.err.println("Jextract:Error writing meta data");
        }
    }

    private native long getMemRangeStart(int var1);

    private native long getMemRangeLength(int var1);

    private native long getNextMem(int var1);

    private native void getMemData(long var1, byte[] var3);

    private void dumpSysInfo() {
        SDFFSTD sDFFSTD = new SDFFSTD(SdffConstants.SEGMENT_SdffHead);
        byte[] byArray = new byte[128];
        sDFFSTD.setLength(sDFFSTD.length + 32L + 128L + 8L);
        sDFFSTD.dump(this.SDFFfile);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 127;
        }
        try {
            this.sdffWriteInt(1);
            this.sdffWriteInt(this.getSubsystem());
            this.sdffWriteInt(this.getArchitecture());
            this.sdffWriteInt(1);
            this.sdffWriteInt(-1);
            this.sdffWriteInt(1);
            this.sdffWriteInt(0);
            this.sdffWriteInt(0);
            this.sdffWrite(byArray);
        }
        catch (Exception exception) {
            System.err.println("Jextract:Error writing sys info");
        }
        this.writeNullMetaData();
    }

    private native int getRas(DvRas var1);

    private void dumpRas() {
        SDFFRas sDFFRas = new SDFFRas();
        if (!this.doBasicOnly) {
            int n = this.getRas(sDFFRas);
        }
        sDFFRas.printSdff(this.SDFFfile);
    }

    private void findMemRange32(int n) {
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < this.nRanges; ++i) {
            if (this.ranges[i].start_address >= (long)n) continue;
            int n4 = n - (int)this.ranges[i].start_address;
            if (n2 == 0) {
                n2 = n4;
                n3 = i;
                continue;
            }
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i;
        }
        if (trace >= 3) {
            System.err.println("Jextract:True address " + Integer.toHexString(n) + " found in mem range " + n3 + ", offset " + Integer.toHexString(n2));
            System.err.println("Jextract: Offset in file = " + Long.toHexString(this.ranges[n3].offset + (long)n2));
        }
    }

    private void dumpMemory() {
        long l = 0L;
        long l2 = 0L;
        this.nRanges = this.getMemoryRangeCount();
        this.ranges = new SDFFMemRanges[this.nRanges];
        if (trace >= 2) {
            System.err.println("Jextract:No of mem ranges = " + this.getMemoryRangeCount());
        }
        SDFFSTD sDFFSTD = new SDFFSTD(SdffConstants.SEGMENT_Sdffmem);
        this.currFileLengthPtr = this.getFilePointer();
        sDFFSTD.dump(this.SDFFfile);
        byte[] byArray = new byte[4096];
        if (!headerOnly) {
            for (int i = 0; i < this.nRanges; ++i) {
                this.ranges[i] = new SDFFMemRanges();
                long l3 = this.getMemRangeLength(i);
                long l4 = this.getMemRangeStart(i);
                if (trace >= 3) {
                    System.err.println("Jextract:Mem range " + i + ", start = " + Long.toHexString(l4) + ", length = " + Long.toHexString(l3));
                }
                this.ranges[i].start_address = l4;
                this.ranges[i].memory_length = l3;
                this.ranges[i].offset = this.getFilePointer();
                sDFFSTD.incLength(l3);
                long l5 = this.getNextMem(i);
                while (l3 > 0L) {
                    this.getMemData(l5, byArray);
                    try {
                        l2 = this.getFilePointer();
                        this.sdffWrite(byArray);
                    }
                    catch (Exception exception) {
                        System.err.println("Jextract:Exception witing to SDFF");
                        exception.toString();
                    }
                    l3 -= (long)byArray.length;
                    l5 += (long)byArray.length;
                }
                if (trace < 3) continue;
                System.err.println("Jextract: mem range " + i + " written at offset " + Long.toHexString(l2));
            }
        }
        this.writeLength(sDFFSTD.getLength() + 8L);
        this.writeNullMetaData();
        SDFFSTD sDFFSTD2 = new SDFFSTD(SdffConstants.SEGMENT_Sdffmmap);
        sDFFSTD2.setLength(sDFFSTD2.getLength() + (long)(64 * this.nRanges) + 32L + 8L);
        sDFFSTD2.dump(this.SDFFfile);
        for (int i = 0; i < this.nRanges; ++i) {
            try {
                this.sdffWriteLong(this.ranges[i].memory_id);
                this.sdffWriteLong(this.ranges[i].spare);
                this.sdffWriteLong(this.ranges[i].start_address);
                this.sdffWriteLong(this.ranges[i].memory_length);
                this.sdffWriteLong(this.ranges[i].offset);
                this.sdffWriteLong(this.ranges[i].flags1);
                this.sdffWriteLong(this.ranges[i].flags2);
                this.sdffWriteLong(this.ranges[i].flags3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = 127;
        }
        try {
            this.sdffWrite(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeNullMetaData();
    }

    private void dumpMmapOnly() {
        long l = 0L;
        long l2 = 0L;
        this.nRanges = this.getMemoryRangeCount();
        this.ranges = new SDFFMemRanges[this.nRanges];
        if (trace >= 2) {
            System.err.println("Jextract:No of mem ranges = " + this.getMemoryRangeCount());
        }
        for (int i = 0; i < this.nRanges; ++i) {
            this.ranges[i] = new SDFFMemRanges();
            long l3 = this.getMemRangeLength(i);
            long l4 = this.getMemRangeStart(i);
            long l5 = this.getNextMem(i);
            if (trace >= 3) {
                System.err.println("Jextract:Mem range " + i + ", start = " + Long.toHexString(l4) + ", length = " + Long.toHexString(l3));
            }
            this.ranges[i].start_address = l4;
            this.ranges[i].memory_length = l3;
            this.ranges[i].offset = l5;
        }
        SDFFSTD sDFFSTD = new SDFFSTD(SdffConstants.SEGMENT_Sdffmmap);
        sDFFSTD.setLength(sDFFSTD.getLength() + (long)(64 * this.nRanges) + 32L + 8L);
        sDFFSTD.dump(this.SDFFfile);
        for (int i = 0; i < this.nRanges; ++i) {
            try {
                this.sdffWriteLong(this.ranges[i].memory_id);
                this.sdffWriteLong(this.ranges[i].spare);
                this.sdffWriteLong(this.ranges[i].start_address);
                this.sdffWriteLong(this.ranges[i].memory_length);
                this.sdffWriteLong(this.ranges[i].offset);
                this.sdffWriteLong(this.ranges[i].flags1);
                this.sdffWriteLong(this.ranges[i].flags2);
                this.sdffWriteLong(this.ranges[i].flags3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[32];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 127;
        }
        try {
            this.sdffWrite(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeNullMetaData();
    }

    private native long getStackTrace(int var1, long[] var2);

    private native long getThreadCount();

    private native long getThreadData(int var1, long[] var2);

    private native long getCurrThread();

    private void dumpProcessThread() {
        SDFFPRTH sDFFPRTH = new SDFFPRTH();
        sDFFPRTH.dump(this.SDFFfile);
    }

    public native int getFrameContext(int var1, ThreadContext var2);

    public static File getJvmMapFile(String string) {
        String string2 = Extract.getMapName(string != null ? string.getBytes() : null);
        if (trace > 0) {
            System.out.println("Jextract:getjvmmapfile:name=" + string2);
        }
        File file = null;
        if (string2 != null) {
            try {
                ZipEntry zipEntry;
                FileInputStream fileInputStream = new FileInputStream(string2);
                file = File.createTempFile("tmp", ".map");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n;
                    if (!zipEntry.getName().startsWith("jvmmap")) continue;
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray, 0, 1024)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                fileOutputStream.close();
                return file;
            }
            catch (IOException iOException) {
                System.err.println("The JVM symbols from \"" + string2 + "\" cannot be loaded");
                if (file != null) {
                    file.delete();
                }
                file = null;
            }
        }
        return null;
    }

    private native long getModuleCount();

    private native long getModuleData(int var1, long[] var2);

    private native long getModuleName(int var1, char[] var2);

    private native String getVersion();

    private native String getHomeName();

    private native String getLibName();

    private native int getEnvVarLength();

    private native long getEnvVars(byte[] var1);

    private native String getClasspath();

    private native String getCommandLine();

    private static native String getMapName(byte[] var0);

    private native SDFFREGISTER[] getRegisters(int var1, Class var2);

    private native long getExecEnv(int var1);

    public static native int readBytes(byte[] var0, long var1, int var3);

    protected void sdffWriteLong(long l) throws IOException {
        this.SDFFfile.writeLong(l);
        this.currentBytesWritten += 8L;
        if (!this.useIncrement2) {
            if (this.currentBytesWritten - this.savedBytesWritten > (long)increment1) {
                this.doWriteHash();
            }
        } else if (this.currentBytesWritten - this.savedBytesWritten > (long)increment2) {
            this.doWriteHash();
        }
    }

    protected void sdffWriteInt(int n) throws IOException {
        this.SDFFfile.writeInt(n);
        this.currentBytesWritten += 4L;
        if (!this.useIncrement2) {
            if (this.currentBytesWritten - this.savedBytesWritten > (long)increment1) {
                this.doWriteHash();
            }
        } else if (this.currentBytesWritten - this.savedBytesWritten > (long)increment2) {
            this.doWriteHash();
        }
    }

    protected void sdffWrite(byte[] byArray) throws IOException {
        this.SDFFfile.write(byArray);
        this.currentBytesWritten += (long)byArray.length;
        if (!this.useIncrement2) {
            if (this.currentBytesWritten - this.savedBytesWritten > (long)increment1) {
                this.doWriteHash();
            }
        } else if (this.currentBytesWritten - this.savedBytesWritten > (long)increment2) {
            this.doWriteHash();
        }
    }

    protected void sdffWrite(int n) throws IOException {
        this.SDFFfile.write(n);
        ++this.currentBytesWritten;
        if (!this.useIncrement2) {
            if (this.currentBytesWritten - this.savedBytesWritten > (long)increment1) {
                this.doWriteHash();
            }
        } else if (this.currentBytesWritten - this.savedBytesWritten > (long)increment2) {
            this.doWriteHash();
        }
    }

    protected void sdffWrite(byte[] byArray, int n, int n2) throws IOException {
        this.SDFFfile.write(byArray, n, n2);
        this.currentBytesWritten += (long)n2;
        if (!this.useIncrement2) {
            if (this.currentBytesWritten - this.savedBytesWritten > (long)increment1) {
                this.doWriteHash();
            }
        } else if (this.currentBytesWritten - this.savedBytesWritten > (long)increment2) {
            this.doWriteHash();
        }
    }

    protected void doWriteHash() {
        if (null == this.clock) {
            this.clock = new SDFFClock("Copying dump data....", 1);
        }
        this.clock.tick();
        this.savedBytesWritten = this.currentBytesWritten;
    }

    static {
        headerOnly = false;
        String string = System.getProperty("java.home");
        string = string + "\\bin\\classic\\core.dll";
        System.load(string);
    }

    class ExReader
    extends TargetReader {
        ExReader() {
        }

        public int readBytes(byte[] byArray, long l, int n) {
            return Extract.readBytes(byArray, l, n);
        }
    }

    class SDFFPRTH {
        private SDFFSTD header = null;
        private long nAddressSpaces = 1L;
        private SDFFADDRESSSPACE addressSpace = null;
        private byte[] spare = new byte[32];
        private long nullMetaData = -1L;
        private transient long length;

        SDFFPRTH() {
            this.header = new SDFFSTD(SdffConstants.SEGMENT_Sdffprth, 1L);
            this.addressSpace = new SDFFADDRESSSPACE();
            this.header.setLength(this.getLength());
            for (int i = 0; i < this.spare.length; ++i) {
                this.spare[i] = 127;
            }
        }

        protected long getLength() {
            this.length = this.header.getLength() + 16L + this.addressSpace.getLength() + 32L;
            if (trace >= 2) {
                System.err.println("Jextract:PRTH: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                this.header.dump(randomAccessFile);
                Extract.this.sdffWriteLong(this.nAddressSpaces);
                this.addressSpace.dump(randomAccessFile);
                Extract.this.sdffWrite(this.spare);
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping PRTH section");
                return;
            }
        }
    }

    class SDFFADDRESSSPACE {
        private long length = 104L;
        private byte[] eyecatcher = new byte[]{65, 68, 68, 82, 83, 80, 67, 32};
        private long id = 0L;
        private long nProcesses = 1L;
        private int index = 0;
        private byte[] spare = new byte[60];
        private SDFFPROCESS process;
        private long nullMetaData = -1L;

        SDFFADDRESSSPACE() {
            this.process = new SDFFPROCESS();
            this.length += this.process.getLength();
            for (int i = 0; i < this.spare.length; ++i) {
                this.spare[i] = 127;
            }
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:ADDSPC: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWriteLong(this.id);
                Extract.this.sdffWriteLong(this.nProcesses);
                Extract.this.sdffWriteInt(this.index);
                Extract.this.sdffWrite(this.spare);
                this.process.dump(randomAccessFile);
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping ADDRESS SPACE section");
                return;
            }
        }
    }

    class SDFFPROCESS {
        private long length = 328L;
        private byte[] eyecatcher = new byte[]{80, 82, 79, 67, 69, 83, 83, 32};
        private long pid;
        private long nThreads;
        private long currThread;
        private long signal = 0L;
        private byte[] signalName = new byte[]{48, 48, 48, 48, 48, 48, 48, 48};
        private byte[] commandLine = new byte[256];
        private long threadOffset;
        private SDFFENVDATA env;
        private SDFFLOADED loaded;
        private SDFFTHREAD[] thread;
        private long nullMetaData = -1L;

        SDFFPROCESS() {
            long[] lArray = new long[4];
            this.nThreads = Extract.this.getThreadCount();
            if (this.nThreads > 0L) {
                if (trace >= 2) {
                    System.err.println("Jextract:SDFFPROCESS - threads = " + this.nThreads);
                }
                this.thread = new SDFFTHREAD[(int)this.nThreads];
                for (int i = 0; i < (int)this.nThreads; ++i) {
                    this.thread[i] = new SDFFTHREAD(i);
                    long l = Extract.this.getThreadData(i, lArray);
                    this.thread[i].tid = lArray[0];
                    this.thread[i].ip = lArray[2];
                    this.thread[i].ee = lArray[3];
                    if (trace >= 3) {
                        System.err.println("Jextract:SDFFPROCESS:thread " + i);
                        System.err.println("Jextract:  tid = " + lArray[0] + "(0x" + Long.toHexString(lArray[0]) + ")");
                        System.err.println("Jextract:  esp = " + Long.toHexString(lArray[1]));
                        System.err.println("Jextract:  eip = " + Long.toHexString(lArray[2]));
                        System.err.println("Jextract:  ee  = " + Long.toHexString(lArray[3]));
                        System.err.println("Jextract:  len = " + this.thread[i].getLength());
                    }
                    this.length += this.thread[i].getLength();
                }
                this.currThread = Extract.this.getCurrThread();
                if (trace >= 3) {
                    System.err.println("Jextract:SDFFPROCESS: curr thread = " + this.currThread + "(0x" + Long.toHexString(this.currThread) + ")");
                }
                this.env = new SDFFENVDATA();
                this.length += this.env.getLength();
                this.loaded = new SDFFLOADED();
                this.length += this.loaded.getLength();
            }
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:PROCESS: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWriteLong(this.pid);
                Extract.this.sdffWriteLong(this.nThreads);
                Extract.this.sdffWriteLong(this.currThread);
                Extract.this.sdffWriteLong(this.signal);
                Extract.this.sdffWrite(this.signalName);
                Extract.this.sdffWrite(this.commandLine);
                Extract.this.sdffWriteLong(this.threadOffset);
                if (this.env != null) {
                    this.env.dump(randomAccessFile);
                }
                this.loaded.dump(randomAccessFile);
                for (int i = 0; i < (int)this.nThreads; ++i) {
                    this.thread[i].dump(randomAccessFile);
                }
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping PROCESS section");
                return;
            }
        }
    }

    class SDFFTHREAD {
        private long length = 104L;
        private byte[] eyecatcher = new byte[]{84, 72, 82, 69, 65, 68, 32, 32};
        private long tid;
        private int type = -1;
        private int state = -1;
        private long pStack;
        private long ip;
        private long ee;
        private int processor = -1;
        private int spare1;
        private SDFFJSTACK jstack;
        private SDFFNSTACK nstack;
        private SDFFREGS registers;
        private byte[] spare2 = new byte[32];
        private long nullMetaData = -1L;

        SDFFTHREAD(int n) {
            long[] lArray = new long[2];
            long l = Extract.this.getStackTrace(n, lArray);
            if (trace > 2) {
                System.err.println("Jextract:SDFFTHREAD: rc = " + l + ", stack base = " + Long.toHexString(lArray[0]) + ". stack size = " + Long.toHexString(lArray[1]));
            }
            this.ee = Extract.this.getExecEnv(n);
            if (trace > 1) {
                System.out.println("Jextract:ee for thread " + n + " is " + this.ee);
                System.out.println("Jextract:loading maps for thread " + n);
            }
            if (!Extract.this.frameSetup) {
                Object object;
                SDFFRas sDFFRas = new SDFFRas();
                Object var7_7 = null;
                int n2 = Extract.this.getRas(sDFFRas);
                int n3 = (int)Extract.this.getModuleCount();
                LoadMap[] loadMapArray = null;
                if (n3 > 0) {
                    loadMapArray = new LoadMap[n3];
                }
                if (trace > 1) {
                    System.out.println("Jextract:- n maps=" + n3);
                }
                for (int i = 0; i < n3; ++i) {
                    object = new long[2];
                    long l2 = Extract.this.getModuleData(i, object);
                    char[] cArray = new char[(int)l2];
                    Extract.this.getModuleName(i, cArray);
                    String string = new String(cArray);
                    string = string.trim();
                    loadMapArray[i] = new LoadMap(string, object[0], object[1]);
                }
                File file = Extract.getJvmMapFile(null);
                object = file == null ? null : file.getPath();
                ExReader exReader = new ExReader();
                Extract.frameTraverser = new FrameTraverser(exReader, sDFFRas.jvmRas, loadMapArray, null, libPath, (String)object, trace);
                if (file != null) {
                    file.delete();
                }
                Extract.this.frameSetup = true;
            }
            if (trace > 1) {
                System.out.println("Jextract: - java stacks");
            }
            this.jstack = new SDFFJSTACK(n);
            if (trace > 1) {
                System.out.println("Jextract: - native stacks");
            }
            this.nstack = new SDFFNSTACK(n);
            if (trace > 1) {
                System.out.println("Jextract: - registers");
            }
            this.registers = new SDFFREGS(n);
            this.length += this.jstack.getLength();
            this.length += this.nstack.getLength();
            this.length += this.registers.getLength();
            this.spare1 = 32639;
            for (int i = 0; i < this.spare2.length; ++i) {
                this.spare2[i] = 127;
            }
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:THREAD: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWriteLong(this.tid);
                Extract.this.sdffWriteInt(this.type);
                Extract.this.sdffWriteInt(this.state);
                Extract.this.sdffWriteLong(this.pStack);
                Extract.this.sdffWriteLong(this.ip);
                Extract.this.sdffWriteLong(this.ee);
                Extract.this.sdffWriteInt(this.processor);
                Extract.this.sdffWriteInt(this.spare1);
                this.jstack.dump(randomAccessFile);
                this.nstack.dump(randomAccessFile);
                this.registers.dump(randomAccessFile);
                Extract.this.sdffWrite(this.spare2);
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping THREAD section");
                return;
            }
        }
    }

    class SDFFREGS {
        private long length = 40L;
        private byte[] eyecatcher = new byte[]{82, 69, 71, 73, 83, 84, 69, 82};
        private long count = 0L;
        private SDFFREGISTER[] regs;
        private long nullMetaData = -1L;

        SDFFREGS(int n) {
            this.regs = Extract.this.getRegisters(n, class$com$ibm$jvm$dump$extract$Extract$SDFFREGISTER == null ? (class$com$ibm$jvm$dump$extract$Extract$SDFFREGISTER = Extract.class$("com.ibm.jvm.dump.extract.Extract$SDFFREGISTER")) : class$com$ibm$jvm$dump$extract$Extract$SDFFREGISTER);
            this.count = this.regs.length;
            for (int i = 0; i < this.regs.length; ++i) {
                this.length += this.regs[i].getLength();
                if (trace <= 3) continue;
                System.err.println("Jextract:  " + this.regs[i].name + " = " + Long.toHexString(this.regs[i].value));
            }
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:REGS: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWriteLong(this.count);
                Extract.this.sdffWriteLong(8L);
                int n = 0;
                while ((long)n < this.count) {
                    this.regs[n].dump(randomAccessFile);
                    ++n;
                }
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping REGS section");
                return;
            }
        }
    }

    class SDFFREGISTER {
        private byte[] name;
        private long value = 0L;

        SDFFREGISTER() {
        }

        protected long getLength() {
            return this.name.length + 8;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                randomAccessFile.write(this.name);
                randomAccessFile.writeLong(this.value);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping REGISTER section");
                return;
            }
        }
    }

    class SDFFENVDATA {
        private long length = 64L;
        private byte[] eyecatcher = new byte[]{69, 78, 86, 68, 65, 84, 65, 32};
        private byte[] version = new byte[32];
        private int homeDirLen = 0;
        private byte[] homeDir;
        private int libDirSize = 0;
        private byte[] libDir;
        private int envSize = 0;
        private byte[] env;
        private int classSize = 0;
        private byte[] classPath;
        private long nullMetaData = -1L;
        private byte[] metaData;
        private long metaDataLength = 0L;

        SDFFENVDATA() {
            String string;
            int n;
            int n2 = 0;
            String string2 = new String("Not available");
            String string3 = Extract.this.getVersion();
            if (string3 == null) {
                string3 = string2;
            }
            byte[] byArray = string3.getBytes();
            n2 = string3.length();
            System.arraycopy(byArray, 0, this.version, 0, n2);
            string3 = Extract.this.getHomeName();
            if (string3 == null) {
                string3 = string2;
            }
            if ((n2 = string3.length()) - (n = n2 / 4 << 2) != 0) {
                n2 = n + 4;
            }
            this.homeDir = new byte[n2];
            System.arraycopy(string3.getBytes(), 0, this.homeDir, 0, string3.length());
            this.homeDirLen = n2;
            this.length += (long)n2;
            string3 = Extract.this.getClasspath();
            if (string3 == null) {
                string3 = string2;
            }
            if ((n2 = string3.length()) - (n = n2 / 4 << 2) != 0) {
                n2 = n + 4;
            }
            this.classPath = new byte[n2];
            System.arraycopy(string3.getBytes(), 0, this.classPath, 0, string3.length());
            this.classSize = n2;
            this.length += (long)n2;
            string3 = Extract.this.getLibName();
            if (string3 == null) {
                string3 = string2;
            }
            if ((n2 = string3.length()) - (n = n2 / 4 << 2) != 0) {
                n2 = n + 4;
            }
            this.libDir = new byte[n2];
            System.arraycopy(string3.getBytes(), 0, this.libDir, 0, string3.length());
            this.libDirSize = n2;
            this.length += (long)n2;
            n2 = Extract.this.getEnvVarLength();
            if (n2 != 0) {
                n = n2 / 4 << 2;
                if (n2 - n != 0) {
                    n2 = n + 4;
                }
                this.envSize = n2;
                this.length += (long)n2;
                this.env = new byte[n2];
                Extract.this.getEnvVars(this.env);
            } else {
                n2 = string2.length() + 3 >> 2 << 2;
                this.env = new byte[n2];
                System.arraycopy(string3.getBytes(), 0, this.env, 0, string3.length());
                this.envSize = n2;
                this.length += (long)n2;
            }
            string3 = Extract.this.getCommandLine();
            if (string3 == null) {
                string3 = string2;
            }
            if ((n2 = (string = "Command line = " + string3).length()) - (n = n2 / 4 << 2) != 0) {
                n2 = n + 4;
            }
            this.metaData = new byte[n2];
            System.arraycopy(string.getBytes(), 0, this.metaData, 0, string.length());
            this.length += (long)n2;
            this.metaDataLength += (long)n2;
            this.length += 8L;
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:ENV: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWrite(this.version);
                Extract.this.sdffWriteInt(this.homeDirLen);
                Extract.this.sdffWrite(this.homeDir);
                Extract.this.sdffWriteInt(this.libDirSize);
                Extract.this.sdffWrite(this.libDir);
                Extract.this.sdffWriteInt(this.envSize);
                Extract.this.sdffWrite(this.env);
                Extract.this.sdffWriteInt(this.classSize);
                Extract.this.sdffWrite(this.classPath);
                if (this.metaDataLength == 0L) {
                    Extract.this.sdffWriteLong(this.nullMetaData);
                } else {
                    Extract.this.sdffWrite(this.metaData);
                    Extract.this.sdffWriteLong(this.metaDataLength);
                }
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping ENVDATA section");
                return;
            }
        }
    }

    class SDFFLOADED {
        private long length = 24L;
        private byte[] eyecatcher = new byte[]{76, 79, 65, 68, 69, 68, 32, 32};
        private MODDATA[] modData;
        private long nullMetaData = -1L;
        private long count = 0L;

        SDFFLOADED() {
            this.count = Extract.this.getModuleCount();
            if (trace >= 3) {
                System.err.println("Jextract:SDFFLOADED: module count = " + this.count);
            }
            this.modData = new MODDATA[(int)this.count];
            for (int i = 0; i < (int)this.count; ++i) {
                this.modData[i] = new MODDATA(i);
                this.length += this.modData[i].getLength();
            }
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:LOADED: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWrite(this.eyecatcher);
                for (int i = 0; i < (int)this.count; ++i) {
                    this.modData[i].dump(randomAccessFile);
                }
                Extract.this.sdffWriteLong(this.nullMetaData);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping LOADED section");
                return;
            }
        }

        class MODDATA {
            private long startAddress;
            private long moduleSize;
            private long nameLength;
            private char[] name;
            private long length = 24L;
            private transient long fillerLen;
            private transient long Clen = 0L;

            MODDATA(int n) {
                long[] lArray = new long[2];
                this.nameLength = Extract.this.getModuleData(n, lArray);
                if (trace > 2) {
                    System.err.println("Jextract:SDFFLOADED: module " + n + ", returned length " + this.nameLength);
                    System.err.println("Jextract:            start Address =  " + Long.toHexString(lArray[0]) + ", size = " + Long.toHexString(lArray[1]));
                }
                this.startAddress = lArray[0];
                this.moduleSize = lArray[1];
                this.name = new char[(int)this.nameLength];
                this.Clen = this.nameLength / 2L;
                this.length += this.Clen;
                this.fillerLen = 8L - (this.Clen - this.Clen / 8L * 8L);
                if (this.fillerLen == 8L) {
                    this.fillerLen = 0L;
                }
                if (trace > 2) {
                    System.err.println("Jextract:  module " + n + ", str len added " + this.Clen + ", filler = " + this.fillerLen);
                }
                this.length += this.fillerLen;
                Extract.this.getModuleName(n, this.name);
                if (trace >= 3) {
                    System.err.println("Jextract:SDFFLOADED: module " + n + ", name = " + new String(this.name));
                }
            }

            private long getLength() {
                if (trace > 2) {
                    System.err.println("Jextract:MODDATA: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
                }
                return this.length;
            }

            protected void dump(RandomAccessFile randomAccessFile) {
                byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0};
                int n = this.name.length / 2;
                try {
                    Extract.this.sdffWriteLong(this.startAddress);
                    Extract.this.sdffWriteLong(this.moduleSize);
                    Extract.this.sdffWriteLong(this.name.length / 2);
                    for (int i = 0; i < n; ++i) {
                        byte by = (byte)this.name[i];
                        Extract.this.sdffWrite(by);
                    }
                    long l = Extract.this.getFilePointer();
                    if (this.fillerLen != 0L) {
                        Extract.this.sdffWrite(byArray, 0, (int)this.fillerLen);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Jextract:Error dumping LOADED:MODDATA section");
                    return;
                }
            }
        }
    }

    class SDFFNSTACK {
        private SDFFNativeStack nativeStack;

        SDFFNSTACK(int n) {
            ThreadContext threadContext = new ThreadContext();
            Extract.this.getFrameContext(n, threadContext);
            NativeFrame[] nativeFrameArray = frameTraverser.getNativeFrames(threadContext);
            DvNativeFrame[] dvNativeFrameArray = null;
            if (nativeFrameArray != null) {
                dvNativeFrameArray = new DvNativeFrame[nativeFrameArray.length];
                for (int i = 0; i < nativeFrameArray.length; ++i) {
                    dvNativeFrameArray[i] = new DvNativeFrame(nativeFrameArray[i]);
                }
            }
            this.nativeStack = new SDFFNativeStack(dvNativeFrameArray);
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:NSTACK: length = " + this.nativeStack.getLength() + "(0x" + Long.toHexString(this.nativeStack.getLength()) + ")");
            }
            return this.nativeStack.getLength();
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            this.nativeStack.printSdff(randomAccessFile);
        }
    }

    class SDFFJSTACK {
        private SDFFJavaStack javaStack;

        SDFFJSTACK(int n) {
            ThreadContext threadContext = new ThreadContext();
            Extract.this.getFrameContext(n, threadContext);
            JavaFrame[] javaFrameArray = frameTraverser.getJavaFrames(threadContext);
            DvJavaFrame[] dvJavaFrameArray = null;
            if (javaFrameArray != null) {
                if (trace > 1) {
                    System.out.println("Jextract:SDFFJSTACK:got frames, n=" + javaFrameArray.length);
                }
                dvJavaFrameArray = new DvJavaFrame[javaFrameArray.length];
                for (int i = 0; i < javaFrameArray.length; ++i) {
                    dvJavaFrameArray[i] = new DvJavaFrame(javaFrameArray[i]);
                }
            }
            this.javaStack = new SDFFJavaStack(dvJavaFrameArray);
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:JSTACK: length = " + this.javaStack.getLength() + "(0x" + Long.toHexString(this.javaStack.getLength()) + ")");
            }
            return this.javaStack.getLength();
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            this.javaStack.printSdff(randomAccessFile);
        }
    }

    class SDFFSTD {
        private long length;
        private long type;
        private byte[] eyecatcher = new byte[8];
        private long version = SdffConstants.VERSION1_0_0;
        private String[] eyecatchers = new String[]{SdffConstants.SEGMENT_Eye_SdffHead, SdffConstants.SEGMENT_Eye_SdffPrth, SdffConstants.SEGMENT_Eye_SdffMmem, SdffConstants.SEGMENT_Eye_SdffMem};

        SDFFSTD(long l) {
            this.type = l;
            this.eyecatcher = this.eyecatchers[(int)l].getBytes();
            this.length = 32L;
        }

        SDFFSTD(long l, long l2) {
            this(l);
            this.version = l2;
        }

        protected void incLength(long l) {
            this.length += l;
        }

        protected void setLength(long l) {
            this.length = l;
        }

        protected long getLength() {
            if (trace >= 2) {
                System.err.println("Jextract:SDFFSTD: length = " + this.length + "(0x" + Long.toHexString(this.length) + ")");
            }
            return this.length;
        }

        protected void dump(RandomAccessFile randomAccessFile) {
            try {
                Extract.this.sdffWriteLong(this.length);
                Extract.this.sdffWriteLong(this.type);
                Extract.this.sdffWrite(this.eyecatcher);
                Extract.this.sdffWriteLong(this.version);
            }
            catch (Exception exception) {
                System.err.println("Jextract:Error dumping SDFFSTD section");
                return;
            }
        }
    }

    class SDFFMemRanges {
        private long memory_id = 0L;
        private long spare = 0L;
        private long start_address;
        private long memory_length;
        private long offset;
        private long flags1 = 0L;
        private long flags2 = 0L;
        private long flags3 = 0L;

        SDFFMemRanges() {
        }
    }
}

