/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.frame;

import com.ibm.jvm.dump.frame.JavaFrame;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.frame.NativeFrame;
import com.ibm.jvm.dump.frame.TargetReader;
import com.ibm.jvm.dump.frame.ThreadContext;

public class FrameTraverser {
    static boolean initialized = false;
    int numMaps;
    LoadMap[] maps;
    byte[] symbolMaps;
    long jvmRas;
    byte[] exeFileName;
    byte[] libPathName;
    byte[] mapFileName;
    TargetReader reader;
    private int trace = 0;

    private native void setupTraverser(int var1);

    private native JavaFrame[] javaTraverser(ThreadContext var1);

    private native NativeFrame[] nativeTraverser(ThreadContext var1);

    private native byte[] disassemble(long var1, long var3);

    public FrameTraverser(TargetReader targetReader, long l, LoadMap[] loadMapArray, String string, String string2, String string3) {
        this(targetReader, l, loadMapArray, string, string2, string3, 0);
    }

    public FrameTraverser(TargetReader targetReader, long l, LoadMap[] loadMapArray, String string, String string2, String string3, int n) {
        this.trace = n;
        if (initialized) {
            System.out.println("FrameTraverser:Already initialised");
            return;
        }
        try {
            System.loadLibrary("frame");
        }
        catch (Exception exception) {
            if (n > 0) {
                System.out.println("FrameTraverser:Failed to load native frame library");
            }
            return;
        }
        initialized = true;
        this.reader = targetReader;
        this.jvmRas = l;
        this.maps = loadMapArray;
        this.numMaps = loadMapArray == null ? 0 : loadMapArray.length;
        this.exeFileName = string == null ? null : string.getBytes();
        this.libPathName = string2 == null ? null : string2.getBytes();
        byte[] byArray = this.mapFileName = string3 == null ? null : string3.getBytes();
        if (n > 0) {
            System.out.print("Processing dump symbols ");
        }
        this.setupTraverser(n);
    }

    public FrameTraverser() {
        System.out.println("FrameTraverser:null constructor (?)");
    }

    public JavaFrame[] getJavaFrames(ThreadContext threadContext) {
        JavaFrame[] javaFrameArray = null;
        if (!initialized) {
            return null;
        }
        javaFrameArray = this.javaTraverser(threadContext);
        return javaFrameArray;
    }

    public NativeFrame[] getNativeFrames(ThreadContext threadContext) {
        if (threadContext.sp == 0L || !initialized) {
            return null;
        }
        NativeFrame[] nativeFrameArray = null;
        nativeFrameArray = this.nativeTraverser(threadContext);
        return nativeFrameArray;
    }

    public String getDisassembly(long l, long l2) {
        if (l2 == 0L) {
            l2 = l + 50L;
        }
        byte[] byArray = null;
        try {
            byArray = this.disassemble(l, l2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (byArray == null) {
            return "No disassembly";
        }
        return new String(byArray);
    }

    int readBytes(byte[] byArray, long l, int n) {
        return this.reader.readBytes(byArray, l, n);
    }
}

