/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvEnvData;
import com.ibm.jvm.dump.format.DvHeap;
import com.ibm.jvm.dump.format.DvObject;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.ReaderProxy;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class DvGeneralSov
extends CommandPlugin {
    private static Vector sanityCheckVector = new Vector();
    public static String fullVersion;
    private static DvGeneralSov selfRef;
    private static StringBuffer summarySB;
    private static long javaThreadsWithoutTLH;
    private static long javaThreadsWithTLH;
    private static long javaThreadsWithoutTHTLH;
    private static long javaThreadsWithTHTLH;
    private static int threadLocalH;
    private static int middlewareH;
    private static int transientH;
    private static int systemH;
    private static int acsH;
    private static DvAddressSpace as;
    private static boolean verboseTLH;
    private static int ptrLength;
    private static long totalSwappedObjectCount;
    private static long totalSwappedObjectLength;
    private static long totalObjectCount;
    private static HashSet systemHeapHashByAddr;
    private static HashSet acsHeapHashByAddr;
    private static Vector lockedObjects;
    private static long totalLockedObjectCount;
    private static long totalHMObjectCount;
    private static long totalArrayObjectCount;
    private static long totalHObjectCount;
    private static byte[] extendedAllocBits;
    private static long allocBitsAddress;
    private static final byte[] allocBitsTestBytes;
    private static long startOfMHeap;
    private static long endOfMHeap;
    private static long startOfTransHeap;
    private static long endOfTransHeap;
    private static boolean is64bit;
    private static boolean isBigEndian;
    private static byte[] allocBitsBuffer;
    private static long allocBitsBufferStart;
    private static int allocBitsBufferSize;
    private static long[] storedObjAddresses;
    private static int soaPosition;
    private static String[] commandsSupported;
    private static final String[] mySuffixes;
    private static HashMap classNames;
    static long hits;
    static long misses;

    public DvGeneralSov() {
        this.hasOnDumpIdentified = true;
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public boolean sanityCheck(Vector vector) {
        boolean bl = true;
        Vector vector2 = DvConsole.getJvmsInDump();
        vector2.clear();
        vector.clear();
        DvAddressSpace[] dvAddressSpaceArray = DvConsole.theDump.getAddressSpaces();
        int n = dvAddressSpaceArray.length;
        for (int i = 0; i < n; ++i) {
            String string = dvAddressSpaceArray[i].id();
            DvProcess[] dvProcessArray = dvAddressSpaceArray[i].getProcesses();
            for (int j = 0; j < dvProcessArray.length; ++j) {
                String string2 = dvProcessArray[j].id();
                DvThread[] dvThreadArray = dvProcessArray[j].getThreads();
                for (int k = 0; k < dvThreadArray.length; ++k) {
                    String string3 = dvThreadArray[k].id();
                    String string4 = " (as=" + string + " pr=" + string2 + " thread= " + string3 + ") ";
                    if (!dvThreadArray[k].isJava()) continue;
                    long l = dvThreadArray[k].eeAddress().getAddressAsLong();
                    DvAddress dvAddress = dvAddressSpaceArray[i].createAddress(l);
                    if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpaceArray[i])) {
                        vector.add("execenv 0x" + Long.toHexString(l) + string4 + "is in memory");
                        if (DvGeneralSov.sanityCheckJVM(vector, dvAddress, dvAddressSpaceArray[i], dvThreadArray[k])) continue;
                        bl = false;
                        continue;
                    }
                    vector.add("execenv 0x" + Long.toHexString(l) + string4 + "is NOT in memory");
                    bl = false;
                }
            }
        }
        DvGeneralSov.infoAboutJVMs(vector);
        return bl;
    }

    private static boolean sanityCheckJVM(Vector vector, DvAddress dvAddress, DvAddressSpace dvAddressSpace, DvThread dvThread) {
        boolean bl = true;
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
        if (null != cTypeObject) {
            long l = DvUtils.jvmFromExecenv(dvAddressSpace, dvAddress);
            DvAddress dvAddress2 = new DvAddress(l);
            if (DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
                vector.add("   ... and this is at a valid memory address");
                Vector vector2 = DvConsole.getJvmsInDump();
                boolean bl2 = false;
                for (int i = 0; i < vector2.size() && !bl2; ++i) {
                    long l2 = (Long)vector2.get(i);
                    if (l2 != l) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    if (!DvGeneralSov.checkJVMEyeCatchers(vector, dvAddress2, dvAddressSpace)) {
                        bl = false;
                    }
                    vector2.add(new Long(l));
                    Vector vector3 = DvConsole.getJvmsInDumpAs();
                    Vector vector4 = DvConsole.getJvmsInDumpThread();
                    vector3.add(dvAddressSpace);
                    vector4.add(dvThread);
                } else {
                    vector.add("   ... has same jvmP as a previous one (0x" + Long.toHexString(l) + ")");
                }
            } else {
                bl = false;
                long l3 = dvThread.eeAddress().getAddressAsLong();
                vector.add("   ... and this is NOT at a valid memory address\n   ... OR has am invalid jvmP in the execenv (try \"for 0x" + Long.toHexString(l3) + " as execenv\")");
            }
        } else {
            bl = false;
            vector.add("  .... Problem formatting execenv");
        }
        return bl;
    }

    public static void sanityCheckDisplayFailure(Vector vector) {
        vector.add("\nSanity check failure.\nSanity check output follows.\nCould be: \n    a corrupted dump or ...\n    mismatch between types file and dump level or ...\n    a bad types file.\n \nFurther investigation suggested.\n");
        for (int i = 0; i < sanityCheckVector.size(); ++i) {
            vector.add(sanityCheckVector.get(i));
        }
    }

    public static void infoAboutJVMs(Vector vector) {
        Vector vector2 = DvConsole.getJvmsInDump();
        int n = vector2.size();
        if (n > 0) {
            long l;
            for (int i = 0; i < n; ++i) {
                String string = "JVM#" + (i + 1);
                String string2 = Long.toHexString((Long)vector2.get(i));
                DvUtils.setValue(string, string2);
                if (i == 0 && n == 1) {
                    vector.add("\nSTANDALONE JVM:");
                } else if (i == 0 && n > 1) {
                    vector.add("\nCURRENT JVM:");
                } else if (i == 1) {
                    vector.add("OTHER JVM(s):");
                }
                l = (Long)vector2.get(i);
                DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
                CTypeObject cTypeObject = new CTypeObject("Jvm", new DvAddress(l), dvAddressSpace);
                vector.add("  address:             0x" + Long.toHexString(l));
                vector.add("  currently_in_GC0:    " + DvGeneralSov.isInGC(cTypeObject, dvAddressSpace));
                if (DvGeneralSov.isResettable(cTypeObject, dvAddressSpace)) {
                    vector.add("  performing_reset_GC: " + DvGeneralSov.isInResetGC(cTypeObject, dvAddressSpace));
                }
                vector.add("  signal received:     " + DvGeneralSov.signalReceived(cTypeObject, dvAddressSpace) + "\n");
            }
            l = (Long)vector2.get(0);
            DvUtils.setValue("CURRJVM", Long.toHexString(l));
            fullVersion = DvUtils.getJVMHint(l, "FULLVERSION");
            if (fullVersion.startsWith("0x")) {
                fullVersion = DvUtils.remove0x(fullVersion);
                fullVersion = DvUtils.getStringFromAddress(fullVersion, 128);
            }
            vector.add("fullVersion: " + fullVersion + "\n");
            DvConsole.fullVersion = fullVersion;
        }
    }

    private static boolean checkJVMEyeCatchers(Vector vector, DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        boolean bl = true;
        String[] stringArray = new String[]{"MAIN", "MAIN", "lk", "LOCK", "dg", "DIAG", "st", "STOR", "xm", "XMGT", "xe", "XENG", "cl", "CLAS", "ci", "CORE"};
        CTypeObject cTypeObject = new CTypeObject("Jvm", dvAddress, dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField("facade");
        long l = cTypeObject2.getAddr();
        vector.add("   ... has facade at 0x" + Long.toHexString(l));
        if (DvUtils.runningSystemIsEBCDIC()) {
            vector.add("   ... running DvConsole on an ebcdic based runtime system");
        } else {
            vector.add("   ... running DvConsole on an ascii based runtime system");
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            Object object;
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (4 == DvConsole.theDump.getSystemType() && !DvUtils.runningSystemIsEBCDIC()) {
                object = null;
                for (int j = 0; j < string2.length(); ++j) {
                    boolean bl2 = false;
                    for (int k = 192; k < 256 && !bl2; ++k) {
                        String string3 = DvUtils.byteToEbcdic.substring(k, k + 1);
                        if (!string3.equals(string2.substring(j, j + 1))) continue;
                        bl2 = true;
                        char[] cArray = new char[]{(char)k};
                        String string4 = new String(cArray);
                        object = null == object ? string4 : (String)object + string4;
                    }
                    if (bl2) continue;
                    bl = false;
                    object = (String)object + ".";
                }
                string2 = object;
            }
            object = null;
            CTypeObject cTypeObject3 = null;
            if (0 == i) {
                cTypeObject3 = cTypeObject.getField("header");
            } else {
                CTypeObject cTypeObject4 = cTypeObject2.getField(string);
                cTypeObject3 = cTypeObject4.getField("header");
            }
            object = cTypeObject3.getField("eyecatcher");
            try {
                byte[] byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(((CTypeObject)object).getAddr()), (long)string2.length());
                String string5 = null;
                if (4 != DvConsole.theDump.getSystemType() && DvUtils.runningSystemIsEBCDIC()) {
                    try {
                        string5 = new String(byArray, "ascii");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string5 = new String(byArray);
                    }
                } else {
                    string5 = new String(byArray);
                }
                if (string5.equals(string2)) {
                    vector.add("   ... " + string + " had expected eyecatcher (" + stringArray[i + 1] + ")");
                    continue;
                }
                vector.add("   ... " + string + " had \"" + string5 + "\" rather than the expected eyecatcher (" + string2 + ")");
                bl = false;
                continue;
            }
            catch (DvAddressException dvAddressException) {
                bl = false;
                vector.add("   ... unable to read MAIN eyecatcher memory");
            }
        }
        return bl;
    }

    public boolean onDumpIdentified(DvDump dvDump, Vector vector, Vector vector2, String string) {
        Vector vector3;
        int n;
        int n2;
        Object object;
        Object object2;
        DvUtils.writetoTrace(" Entry to DvGeneralSov:onDumpIdentified (" + string + ")");
        boolean bl = false;
        is64bit = DvUtils.is64BitSystem(dvDump.getArchitecture());
        isBigEndian = DvUtils.isBigEndian(dvDump.getArchitecture());
        DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < dvAddressSpaceArray.length && !bl2; ++i) {
            object2 = dvAddressSpaceArray[i].getProcesses();
            for (int j = 0; j < ((DvProcess[])object2).length && !bl2; ++j) {
                object = object2[j].getThreads();
                if (0 == ((DvThread[])object).length) continue;
                for (n2 = 0; n2 < ((DvThread[])object).length && !bl2; ++n2) {
                    if (0L == ((DvThread)object[n2]).eeAddress().getAddressAsLong()) continue;
                    bl2 = true;
                    n3 = i;
                    n4 = j;
                    n5 = n2;
                }
            }
        }
        if (bl2) {
            DvUtils.setValue("ASID", dvAddressSpaceArray[n3].id());
            DvProcess[] dvProcessArray = dvAddressSpaceArray[n3].getProcesses();
            object2 = dvProcessArray[n4];
            DvThread[] dvThreadArray = ((DvProcess)object2).getThreads();
            DvUtils.setValue("PID", ((DvProcess)object2).id());
            object = dvThreadArray[n5];
            DvUtils.setValue("THREAD", ((DvThread)object).id());
            dvAddressSpaceArray[n3].getMemRanges();
            n2 = 0;
            for (int i = 0; i < dvThreadArray.length; ++i) {
                if (0L == dvThreadArray[i].eeAddress().getAddressAsLong() || !DvUtils.doesThisThreadHaveAnExecenv(dvThreadArray[i], dvAddressSpaceArray[n3])) continue;
                n2 = 1;
                object = dvThreadArray[i];
                DvUtils.setValue("THREAD", ((DvThread)object).id());
                break;
            }
            if (1 == n2) {
                Object object3;
                Object object4;
                DvUtils.setValue("DUMP", string);
                DvEnvData dvEnvData = null;
                dvEnvData = ((DvProcess)object2).getEnvData();
                if (null != dvEnvData) {
                    String string2 = dvEnvData.javaVersion();
                    object4 = DvUtils.getCtypeFile(DvConsole.theDump, string2);
                    if (object4 != null) {
                        // empty if block
                    }
                } else {
                    DvUtils.writetoTrace(" EnvData is null ");
                }
                boolean bl3 = false;
                Object object5 = object4 = (Object)dvDump.getCTypedefs();
                String string3 = DvUtils.getValue("FORMATFILE");
                if (null != string3) {
                    vector.add(" FORMATFILE is set ,named format file will be used if it can be found!");
                    object4 = null;
                }
                bl3 = true;
                if (object4 == null && !(bl3 = DvUtils.loadFormatFile(vector))) {
                    vector.add(" Error establishing format file");
                    vector.add(" Use SET FORMATFILE= command and retry");
                    if (object5 != null) {
                        vector.add(" Incore typedefs defaulted to");
                        object4 = object5;
                        bl3 = true;
                    }
                }
                if (object4 != null && (object3 = new CTypeFile((byte[])object4)) != null & object5 != null) {
                    bl3 = true;
                    vector.add("Using typedefs from core...");
                }
                if (!bl3) {
                    vector.add("  Error establishing format file");
                    return bl;
                }
                bl = true;
                object3 = dvAddressSpaceArray[n3].createAddress(((DvThread)object).eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump((DvAddress)object3, dvAddressSpaceArray[n3])) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpaceArray[n3], (DvAddress)object3, "execenv");
                    if (null != cTypeObject) {
                        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                        if (null != cTypeObject2) {
                            String string4 = cTypeObject2.toString();
                            if (string4.startsWith("null ")) {
                                string4 = string4.substring(5);
                            }
                            if (string4.startsWith("(null) ")) {
                                string4 = string4.substring(7);
                            }
                            string4 = DvUtils.removeAtSign(string4);
                            string4 = DvUtils.remove0x(string4);
                            DvAddress dvAddress = null;
                            DvAddress dvAddress2 = null;
                            boolean bl4 = true;
                            try {
                                dvAddress2 = dvAddressSpaceArray[n3].createAddress(DvUtils.hexToLong(string4));
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl4 = false;
                                DvUtils.writetoTrace(" DvConsole:setTheDump -String returned for jvmP_cTO is:<<" + string4 + ">>");
                                vector.add("\n jvmP addressing failure");
                            }
                            CTypeObject cTypeObject3 = null;
                            if (bl4) {
                                block41: {
                                    try {
                                        dvAddress = dvAddressSpaceArray[n3].readPointer(dvAddress2);
                                    }
                                    catch (DvAddressException dvAddressException) {
                                        if (null == vector) break block41;
                                        vector.add("\n jvmP addressing failure");
                                    }
                                }
                                if (null != dvAddress) {
                                    cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpaceArray[n3], dvAddress, "Jvm");
                                }
                            }
                            if (null != cTypeObject3) {
                                DvUtils.setupJVMHints(cTypeObject3, dvAddress.getAddressAsLong(), dvAddressSpaceArray[n3]);
                            } else if (null != vector) {
                                vector.add(" Unable to format Jvm!");
                            }
                        } else if (null != vector) {
                            vector.add(" Unable to get jvmP!");
                        }
                    }
                } else {
                    DvUtils.writetoTrace(" execenv was 0");
                    vector.add(" execenv was 0!");
                }
            } else {
                vector.add(" No ExecEnv eyeCatchers found in dump");
            }
        } else {
            vector.add(" No Java threads found in dump");
        }
        if (!this.sanityCheck(sanityCheckVector)) {
            DvGeneralSov.sanityCheckDisplayFailure(vector);
        } else {
            vector.add("\nSanity check passed (use \"SANCHK Verbose\" for details)");
        }
        if (sanityCheckVector.size() > 0) {
            for (int i = 0; i < sanityCheckVector.size(); ++i) {
                vector2.add(sanityCheckVector.get(i));
            }
        }
        if (0 == (n = (vector3 = DvConsole.getJvmsInDump()).size())) {
            vector.add("\n    WARNING\n*   No jvms were uncovered in this dump   \n*\n*   Highly likely that futher errors will occur");
        }
        if (n > 1) {
            vector.add("\n******* JVM Sets detected *************\n*\n* " + n + " Jvms found" + "\n* \"SET\" will display information    " + "\n* on which JVM is currently targetted " + "\n* and what JVMs are available.        " + "\n* \"set jvm\" may also be useful.     " + "\n******* JVM Sets detected ************");
        }
        if (n > 0) {
            DvGeneralSov.infoAboutJVMs(vector);
        } else {
            DvUtils.setValue("CURRJVM", "-1");
        }
        DvUtils.writetoTrace(" Exit from DvGeneralSov:onDumpIdentified");
        return bl;
    }

    public String pluginName() {
        return "General Soverign plugin";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public Boolean heapScan(DvHeap dvHeap) {
        Boolean bl = new Boolean(true);
        if ("sov".equals(DvUtils.getSuffix())) {
            extendedAllocBits = null;
            allocBitsAddress = 0L;
            DvGeneralSov.storedObjAddresses[0] = 0L;
            DvGeneralSov.storedObjAddresses[1] = 0L;
            DvGeneralSov.storedObjAddresses[2] = 0L;
            DvGeneralSov.storedObjAddresses[3] = 0L;
            DvGeneralSov.storedObjAddresses[4] = 0L;
            soaPosition = 0;
            totalSwappedObjectCount = 0L;
            totalSwappedObjectLength = 0L;
            totalObjectCount = 0L;
            systemHeapHashByAddr.clear();
            acsHeapHashByAddr.clear();
            lockedObjects = new Vector();
            totalLockedObjectCount = 0L;
            totalHMObjectCount = 0L;
            totalArrayObjectCount = 0L;
            totalHObjectCount = 0L;
            DvHeap.reset();
            boolean bl2 = this.traverseAllHeaps(dvHeap);
            bl = new Boolean(bl2);
        } else {
            bl = new Boolean(false);
        }
        return bl;
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    private boolean traverseAllHeaps(DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseAllHeaps()");
        Object var2_2 = null;
        if (null == DvObjectsCommands.namesIndexFile) {
            DvObjectsCommands.openNamesIndexFile();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        DvConsole.bHeapTraversalInprogress = true;
        classNames = new HashMap();
        DvGeneralSov.traverseEveryTLH(dvHeap);
        DvGeneralSov.traverseMiddlewareHeap(dvHeap);
        DvGeneralSov.traverseTransientHeap(dvHeap);
        DvGeneralSov.traverseSystemHeaps(dvHeap);
        DvGeneralSov.traverseACSHeap(dvHeap);
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseAllHeaps()");
        return true;
    }

    private static void traverseEveryTLH(DvHeap dvHeap) {
        Object object;
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseEveryTLH()");
        int n = 0;
        if (DvConsole.theDump == null) {
            dvHeap.doOutput("Unable to comply as no Dump opened yet\n", true);
            return;
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        String string = "\nTraversing Thread Local Heaps \n";
        dvHeap.doOutput(string, true);
        Vector vector = new Vector();
        try {
            object = as.getProcesses();
            for (int i = 0; i < ((DvProcess[])object).length; ++i) {
                DvThread[] dvThreadArray = object[i].getThreads();
                for (int j = 0; j < dvThreadArray.length; ++j) {
                    if (dvThreadArray[j].isJava()) {
                        if (!DvUtils.threadWithinCurrentJVM(dvThreadArray[j])) continue;
                        n += DvGeneralSov.traverseOneTLH(dvThreadArray[j], j, vector, dvHeap);
                        continue;
                    }
                    if (!verboseTLH) continue;
                    String string2 = "        " + dvThreadArray[j] + " non-Java thread";
                    dvHeap.doOutput(string2, true);
                }
            }
        }
        catch (Exception exception) {
            String string3 = "*** Exception received while traversing TLH - " + exception.getMessage();
            dvHeap.doOutput("Unable to comply as no Dump opened yet\n", true);
            exception.printStackTrace();
        }
        object = "\n        " + javaThreadsWithoutTLH + " of " + (javaThreadsWithTLH + javaThreadsWithoutTLH) + " java threads did not have TLH cache blocks\n" + "        " + javaThreadsWithoutTHTLH + " of " + (javaThreadsWithTHTLH + javaThreadsWithoutTHTLH) + " java threads did not have TH-TLH cache blocks\n" + "TLH finished - " + n + " objects\n";
        dvHeap.doOutput((String)object, true);
        threadLocalH = n;
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.traverseEveryTLH()");
    }

    private static int traverseOneTLH(DvThread dvThread, int n, Vector vector, DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseOneTLH()");
        int n2 = 0;
        DvAddress dvAddress = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 1;
        long l4 = DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture()) ? 0x3FFFFFFFFFFFFFF8L : 0x3FFFFFF8L;
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), as);
        if (cTypeObject == null || as == null || dvThread == null) {
            String string = "        *** Warning: Unable to process TLH for thread - unexpected NULL variable";
            dvHeap.doOutput(string, true);
            DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseOneTLH(DvThread, int, Vector)");
            return 0;
        }
        if (dvThread.eeAddress().getAddressAsLong() == 0L) {
            DvUtils.writetoTrace("Exit:2 DvGeneralSov.traverseOneTLH(DvThread, int, Vector) Warning: ee address is ZERO - thread ignored.");
            return 0;
        }
        for (int i = n3; i <= n4; ++i) {
            String string;
            String string2;
            Object object;
            Object object2;
            CTypeObject cTypeObject2 = null;
            String string3 = "";
            if (i == n3) {
                cTypeObject2 = cTypeObject.getField("alloc_cache.c.tc");
                string3 = "MH-";
            } else {
                cTypeObject2 = cTypeObject.getField("TH_alloc_cache.c.tc");
                string3 = "TH-";
            }
            if (cTypeObject2 == null) {
                object2 = "*** Error: Unable to get tc in DvGeneralSov.traverseOneTLH()";
                dvHeap.doOutput((String)object2, true);
                continue;
            }
            object2 = cTypeObject2.getField("cache_block");
            CTypeObject cTypeObject3 = cTypeObject2.getField("cache_size");
            CTypeObject cTypeObject4 = cTypeObject2.getField("cache_orig_size");
            CTypeObject cTypeObject5 = cTypeObject2.getField("cache_busy");
            if (object2 == null || cTypeObject3 == null || cTypeObject4 == null || cTypeObject5 == null) {
                object = "*** Error: Unexpected NULL variable in DvGeneralSov.traverseOneTLH()";
                dvHeap.doOutput((String)object, true);
                continue;
            }
            try {
                dvAddress = as.readPointer(as.createAddress(((CTypeObject)object2).getAddr()));
                if (null == dvAddress) {
                    l = 0L;
                    DvUtils.trace("*** Unexpected event while getting cache block for " + string3 + "TLH\n thread id is " + dvThread.id() + "(" + dvThread.getThreadName(as) + ")" + "\nThe Address pointed to by the cache_block was 0." + "\nMight be worthy of further investigation", 0, true);
                } else {
                    l = dvAddress.getAddressAsLong();
                }
                if (l == 0L) {
                    if (i == n3) {
                        ++javaThreadsWithoutTLH;
                        continue;
                    }
                    ++javaThreadsWithoutTHTLH;
                    continue;
                }
                l2 = as.readInt(as.createAddress(cTypeObject3.getAddr()));
                l3 = as.readInt(as.createAddress(cTypeObject4.getAddr()));
                object = "        " + string3 + "TLH cache block located at 0x" + Long.toHexString(l) + " for thread " + dvThread.id() + " ee=0x" + Long.toHexString(cTypeObject.getAddr());
                dvHeap.doOutput((String)object, true);
                if (i == n3) {
                    ++javaThreadsWithTLH;
                } else {
                    ++javaThreadsWithTHTLH;
                }
                object = new Range(l, l + l3, n);
                vector.add(object);
            }
            catch (Exception exception) {
                String string4 = "*** Unexpected exception while getting cache block for " + string3 + "TLH : thread id is " + dvThread.id() + "(" + dvThread.getThreadName(as) + ")\n" + "    Exception type = " + exception.getMessage();
                dvHeap.doOutput(string4, true);
                exception.printStackTrace();
            }
            long l5 = 0L;
            if (l3 == l2) {
                if (!verboseTLH) continue;
                string2 = "        Nothing in " + string3 + "TLH for Thread " + "(" + dvThread + ")";
                dvHeap.doOutput(string2, true);
                continue;
            }
            if (0L == l2) {
                if (!verboseTLH) continue;
                string2 = "        cache_size is zero " + string3 + "TLH for Thread " + "(" + dvThread + ")";
                dvHeap.doOutput(string2, true);
                continue;
            }
            if (verboseTLH) {
                string2 = "        Objects in " + string3 + "TLH for Thread " + "(" + dvThread + ")";
                dvHeap.doOutput(string2, true);
            }
            long l6 = l + l2;
            int n5 = 0;
            long l7 = 0L;
            try {
                n5 = as.readInt(as.createAddress(cTypeObject5.getAddr()));
                dvAddress = as.readPointer(as.createAddress(l6));
                l7 = dvAddress.getAddressAsLong();
                l7 &= l4;
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
            }
            if (verboseTLH) {
                string = "        " + string3 + "TLH objects begin at : 0x" + Long.toHexString(l6);
                dvHeap.doOutput(string, true);
            }
            if (0L != l7) {
                l5 = DvGeneralSov.traverseOneTLHCacheBlock(dvThread, l6, l + l3, string3, dvHeap);
                dvHeap.createSubHeap(l, l + l3, string3, dvThread, l5, false);
                n2 = (int)((long)n2 + l5);
                continue;
            }
            string = "      TLH starting at 0x" + Long.toHexString(l) + " ignored \n" + "     Dump may well have been taken while " + "this thread was in process of allocating object\n" + "        " + string3 + "TLH objects begin at : 0x" + Long.toHexString(l6);
            string = 0 != n5 ? string + "\n   cache_busy flag was set (EXPECTED)" : string + "\n   cache_busy flag was NOT set (NOT EXPECTED)";
            dvHeap.doOutput(string, true);
        }
        DvUtils.writetoTrace("Exit:3 DvGeneralSov.traverseOneTLH(DvThread, int, Vector)");
        return n2;
    }

    private static int traverseOneTLHCacheBlock(DvThread dvThread, long l, long l2, String string, DvHeap dvHeap) {
        long l3;
        long l4;
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseOneTLHCacheBlock(DvThread,long,long,String)");
        int n = 0;
        DvGeneralSov.storedObjAddresses[0] = 0L;
        DvGeneralSov.storedObjAddresses[1] = 0L;
        DvGeneralSov.storedObjAddresses[2] = 0L;
        DvGeneralSov.storedObjAddresses[3] = 0L;
        DvGeneralSov.storedObjAddresses[4] = 0L;
        soaPosition = 0;
        Object var8_6 = null;
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        ReaderProxy readerProxy = new ReaderProxy(as);
        if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
            l4 = 0x3FFFFFFFFFFFFFF8L;
            l3 = 1L;
        } else {
            l4 = 0x3FFFFFF8L;
            l3 = 1L;
        }
        try {
            while (l < l2) {
                Object object;
                Object object2;
                readerProxy = ReaderProxy.getProxy(readerProxy, new DvAddress(l));
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                long l8 = 0L;
                CTypeObject cTypeObject = null;
                boolean bl = false;
                try {
                    Object object3;
                    l8 = readerProxy.readPointer(as.createAddress(l));
                    if (1L == (l8 & l3)) {
                        bl = true;
                    }
                    if ((l8 &= l4) + l > l2) {
                        object3 = "\n WARNING \n  The object at 0x" + Long.toHexString(l) + "\n   in TLH for thread " + dvThread.id() + "\n   has a length of 0x" + Long.toHexString(l8) + "\n    ... and this takes it past the end of the cache_block (0x" + Long.toHexString(l2) + "\n This may be due to heap corruption or (more likely) that the \n" + "\tdump has cbeen taken in the middle of a GC cycle.\n" + "objectHistory()" + "\n THIS OBJECT WAS IGNORED AND SCAN OF THIS TLH TERMINATED\n";
                        dvHeap.doOutput((String)object3, true);
                    }
                    cTypeObject = new CTypeObject("Hjava_lang_Object", as.createAddress(l + (long)ptrLength), as);
                    object3 = cTypeObject.getField("locknflags");
                    l5 = readerProxy.readPointer(as.createAddress(((CTypeObject)object3).getAddr()));
                    l5 &= 0xFFFFFFFFL;
                    object2 = cTypeObject.getField("methods");
                    l6 = readerProxy.readPointer(as.createAddress(((CTypeObject)object2).getAddr()));
                    object = cTypeObject.getField("obj");
                    l7 = readerProxy.readPointer(as.createAddress(((CTypeObject)object).getAddr()));
                }
                catch (DvAddressException dvAddressException) {
                    object2 = "*** Unexpected exception processing an object in " + string + "TLH\n" + "    objPointer=" + l;
                    dvHeap.doOutput((String)object2, true);
                    dvAddressException.printStackTrace();
                }
                boolean bl2 = false;
                if ((l5 & 2L) != 0L) {
                    bl2 = true;
                }
                object2 = new DvObject();
                ((DvObject)object2).methods = l6;
                ((DvObject)object2).obj = l7;
                ((DvObject)object2).heapName = string + "TLH:0x" + Long.toHexString(dvThread.eeAddress().getAddressAsLong());
                ((DvObject)object2).length = l8;
                ((DvObject)object2).address = cTypeObject.getAddr();
                ((DvObject)object2).locknflags = l5;
                if (++soaPosition == 5) {
                    soaPosition = 0;
                }
                DvGeneralSov.storedObjAddresses[DvGeneralSov.soaPosition] = l;
                DvGeneralSov.processData((DvObject)object2, dvHeap, readerProxy);
                if (verboseTLH) {
                    if (bl2) {
                        object = "            Array  @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l8) + ") - " + ((DvObject)object2).type + "[" + l6 + "]";
                        dvHeap.doOutput((String)object, true);
                    } else {
                        object = "            Object @ 0x" + Long.toHexString(l + (long)ptrLength) + " (length=0x" + Long.toHexString(l8) + ") - " + ((DvObject)object2).type;
                        dvHeap.doOutput((String)object, true);
                    }
                }
                if (verboseTLH) {
                    object = "            *** putting: " + Long.toHexString(l + (long)ptrLength) + ", " + totalObjectCount;
                    dvHeap.doOutput((String)object, true);
                }
                DvGeneralSov.processFoundObject(l, true, (short)0, l8, bl, dvHeap, readerProxy);
                ++n;
                if (bl) {
                    ++totalSwappedObjectCount;
                    totalSwappedObjectLength += l8;
                }
                l += l8;
            }
        }
        catch (Exception exception) {
            String string2 = "*** Unexpected exception received while examining items on " + string + "TLH\n" + "  Thread=" + dvThread + ", objectPointer=" + l + ", endOfCacheBlock=" + l2;
            dvHeap.doOutput(string2, true);
            exception.printStackTrace();
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseOneTLHCacheBlock(DvThread,long,long,String)");
        return n;
    }

    private static void processData(DvObject dvObject, DvHeap dvHeap, ReaderProxy readerProxy) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processData(ObjectDetails)");
        dvObject.type = DvGeneralSov.processTypes(dvObject);
        dvObject.lock = false;
        dvObject.lkSharedClassLockFlags = false;
        long l = dvObject.locknflags & 0xFFFFFF00L;
        if (l == 0xFFFFFF00L) {
            dvObject.lkSharedClassLockFlags = true;
        }
        if (0L != dvObject.locknflags && l != 0xFFFFFF00L) {
            dvObject.shapeBit = DvGeneralSov.processShapeBit(dvObject);
            if (0L == dvObject.shapeBit) {
                dvObject.entryCount = DvGeneralSov.processEntryCount(dvObject);
                dvObject.threadId = DvGeneralSov.processThreadId(dvObject);
            } else {
                dvObject.monitorIndex = DvGeneralSov.processMonitorIndex(dvObject);
                dvObject.inflMon = DvGeneralSov.processInflMon(dvObject, dvHeap);
            }
            if (0L != dvObject.threadId || 0L != dvObject.entryCount || 0L != dvObject.monitorIndex) {
                dvObject.lock = true;
            }
        } else {
            dvObject.entryCount = 0L;
            dvObject.threadId = 0L;
            dvObject.monitorIndex = 0L;
            dvObject.inflMon = 0L;
            dvObject.lock = false;
        }
        dvObject.objectName = DvGeneralSov.processObjectName(dvObject, dvHeap, readerProxy);
        dvObject.className = DvGeneralSov.processClassName(dvObject);
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processData(ObjectDetails)");
    }

    private static boolean processFoundObject(long l, boolean bl, short s, long l2, boolean bl2, DvHeap dvHeap, ReaderProxy readerProxy) {
        int n;
        long l3;
        DvUtils.writetoTrace("Entry:DvGeneralSov.processFoundObject: 0x " + Long.toHexString(l) + " : " + bl + " : " + l2);
        boolean bl3 = true;
        String string = "";
        if (!DvObjectsCommands.names_index_built) {
            string = false == bl2 ? DvGeneralSov.processObjectName(l + (long)ptrLength, as, dvHeap, readerProxy) : "+IsSwapped+";
            DvObjectsCommands.namesIndexFile.write(string, l, s, l2);
        }
        if (bl) {
            bl3 = DvGeneralSov.flipEAB(l);
        } else if (s == -4) {
            systemHeapHashByAddr.add(new Long(l));
        } else {
            acsHeapHashByAddr.add(new Long(l));
        }
        long l4 = 0L;
        try {
            l4 = readerProxy.readInt(as.createAddress(l + (long)(ptrLength * 2)));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvGeneralSov.processFoundObject(long,boolean,short,long) DvAddressException");
        }
        long l5 = l4 & 0xFFFFFF00L;
        if (l4 != 0L && l5 != 0xFFFFFF00L && (l3 = l4 & 0xFFFFF800L) != 0L) {
            lockedObjects.add(new Long(l));
            ++totalLockedObjectCount;
        }
        if (l4 != 0L && (n = (int)l4 & 2) == 2) {
            ++totalArrayObjectCount;
        }
        ++totalObjectCount;
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processFoundObject(long,boolean,short,long)");
        return bl3;
    }

    public static Long getLockedObject(int n) {
        Long l = null;
        if (n < lockedObjects.size()) {
            l = (Long)lockedObjects.get(n);
        }
        return l;
    }

    public static Vector getLockedObjectsVector() {
        return lockedObjects;
    }

    private static String processTypes(long l) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processTypes(long)");
        String string = "";
        int n = (int)l & 7;
        switch (n) {
            case 4: {
                string = string + "hashedAndMoved ";
                ++totalHMObjectCount;
                break;
            }
            case 2: {
                string = string + "array ";
                break;
            }
            case 1: {
                string = string + "hashed ";
                ++totalHObjectCount;
                break;
            }
            case 6: {
                string = string + "arrayhm ";
                ++totalHMObjectCount;
                break;
            }
            case 3: {
                string = string + "arraym ";
                ++totalHObjectCount;
                break;
            }
            default: {
                if (n == 0) break;
                string = string + "!XXX! ";
            }
        }
        int n2 = (int)(l >> 3) & 0x1F;
        switch (n2) {
            case 5: {
                string = string + "char";
                break;
            }
            case 4: {
                string = string + "boolean";
                break;
            }
            case 6: {
                string = string + "float";
                break;
            }
            case 7: {
                string = string + "double";
                break;
            }
            case 8: {
                string = string + "byte";
                break;
            }
            case 9: {
                string = string + "short";
                break;
            }
            case 10: {
                string = string + "int";
                break;
            }
            case 12: {
                string = string + "uintpointer";
                break;
            }
            case 11: {
                string = string + "long";
                break;
            }
            case 2: {
                string = string + "class";
                break;
            }
            case 0: {
                string = string + "normal_object";
                break;
            }
            default: {
                DvUtils.trace("\n WARNING LockNFlags for object starting at 0x" + Long.toHexString(storedObjAddresses[soaPosition]) + " contains an unrecognised type (" + n2 + ")\n" + " Use \"dis obj(*unknown_type*)\" to find it later\n" + DvGeneralSov.objectHistory() + "\n", 0, true);
                string = string + "unknown_type" + n2;
            }
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processTypes(long)");
        return string;
    }

    private static String processTypes(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processTypes(ObjectDetails)");
        String string = null;
        long l = dvObject.locknflags;
        string = DvGeneralSov.processTypes(l);
        if (string.startsWith("!XXX! ")) {
            DvUtils.trace("WARNING  Suspicious object encountered at 0x" + Long.toHexString(dvObject.address) + "\n" + DvGeneralSov.objectHistory() + "\n" + " Use \"dis mem(0x" + Long.toHexString(dvObject.address) + ")\" to investigate\n Heap possibly corrupted or in unexpected state" + "\n", 0, true);
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processTypes(ObjectDetails)");
        return DvGeneralSov.processTypes(l);
    }

    private static long processShapeBit(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processShapeBit(ObjectDetails)");
        long l = dvObject.locknflags >> 31 & 1L;
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processShapeBit(ObjectDetails) 32bit");
        return l;
    }

    private static long processEntryCount(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processEntryCount(ObjectDetails)");
        long l = dvObject.locknflags >> 8 & 0xFFL;
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processEntryCount(ObjectDetails)");
        return l;
    }

    private static long processThreadId(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processThreadId(ObjectDetails)");
        long l = dvObject.locknflags >> 16 & 0x7FFFL;
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processThreadId(ObjectDetails)");
        return l;
    }

    private static long processMonitorIndex(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processMonitorIndex(ObjectDetails)");
        long l = dvObject.locknflags >> 8 & 0x7FFFFFL;
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processMonitorIndex(ObjectDetails)");
        return l;
    }

    private static long processInflMon(DvObject dvObject, DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processInflMon(ObjectDetails)");
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l = 0L;
        long l2 = 0L;
        l = Long.parseLong(DvUtils.getJVMHint(as, "LKGLOBALPTR"), 16);
        l2 = Long.parseLong(DvUtils.getJVMHint(as, "DGGLOBALPTR"), 16);
        if (l == l2) {
            DvUtils.writetoTrace("Exit:1 DvGeneralSov.processInflMon(ObjectDetails) lk:dataP==dg:dataP");
            return 0L;
        }
        long l3 = dvObject.address;
        long l4 = 0L;
        try {
            long l5 = DvUtils.getControlBlockField("_lkgldata", "micb", l, as);
            long l6 = DvUtils.getControlBlockFieldInt("monitor_index_cb_t", "count", l5, as);
            long l7 = DvUtils.getControlBlockFieldInt("monitor_index_cb_t", "size", l5, as);
            long l8 = DvUtils.getControlBlockField("monitor_index_cb_t", "table", l5, as);
            long l9 = l8 + (long)ptrLength * dvObject.monitorIndex;
            DvAddress dvAddress = as.createAddress(l9);
            dvAddress = as.readPointer(dvAddress);
            if (dvAddress != null) {
                l4 = dvAddress.getAddressAsLong();
            }
        }
        catch (DvAddressException dvAddressException) {
            dvHeap.doOutput("DvAddressException in processInflMon", true);
            DvUtils.writetoTrace("Contine:1 DvGeneralSov.processInflMon(ObjectDetails) DvAddressException");
        }
        catch (NumberFormatException numberFormatException) {
            dvHeap.doOutput("DvNumberFormatException in processInflMon", true);
            dvHeap.doOutput("Possible cause by not having hints setup properly", true);
            DvUtils.writetoTrace("Contine:2 DvGeneralSov.processInflMon(ObjectDetails) NumberFormatException");
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processInflMon(ObjectDetails)");
        return l4;
    }

    public static String processObjectName(long l, DvAddressSpace dvAddressSpace, DvHeap dvHeap) {
        return DvGeneralSov.processObjectName(l, dvAddressSpace, dvHeap, new ReaderProxy(as));
    }

    public static String processObjectName(long l, DvAddressSpace dvAddressSpace, DvHeap dvHeap, ReaderProxy readerProxy) {
        CTypeObject cTypeObject;
        CTypeObject cTypeObject2;
        DvUtils.writetoTrace("Entry:DvGeneralSov.processObjectName(long, DvAddressSpace)");
        String string = "";
        boolean bl = true;
        long l2 = 0L;
        try {
            l2 = readerProxy.readInt(as.createAddress(l + (long)ptrLength));
        }
        catch (DvAddressException dvAddressException) {
            if (null != dvHeap) {
                dvHeap.doOutput("DvAddressException in processObjectName ", true);
            }
            DvUtils.writetoTrace("Exit:1 DvGeneralSov.processObjectName(long, DvAddressSpace) DvAddressException");
            return string;
        }
        if ((l2 >> 3 & 0x1FL) == 0L && (l2 >> 1 & 1L) == 0L) {
            try {
                CTypeObject cTypeObject3 = new CTypeObject("Hjava_lang_Object", l, readerProxy);
                cTypeObject2 = cTypeObject3.getField("methods").deReference();
                string = (String)classNames.get(cTypeObject2);
                if (string == null) {
                    cTypeObject = cTypeObject2.getField("classdescriptor").deReference();
                    CTypeObject cTypeObject4 = cTypeObject.getField("obj").getField("name").deReference();
                    string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject4.getAddr()), 256L));
                    classNames.put(cTypeObject2, string);
                }
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.writetoTrace("Continue:1 DvGeneralSov.processObjectName(long, DvAddressSpace) DvAddressException");
                if (DvConsole.bGuiRequested) {
                    Dumpviewer.showMessage("\n******************\n DvGeneralSov.processObjectName failure(1)\n for 0x" + Long.toHexString(l) + "\n******************\n", false);
                }
                bl = false;
            }
            catch (NullPointerException nullPointerException) {
                DvUtils.writetoTrace("Continue:2 DvGeneralSov.processObjectName(long, DvAddressSpace) NullPointerException");
                System.err.println("NullPointerException in processObjectName.  theObjAddress=0x" + Long.toHexString(l));
                nullPointerException.printStackTrace();
                if (DvConsole.bGuiRequested) {
                    Dumpviewer.showMessage("\n******************\n DvGeneralSov.processObjectName failure(2)\n for 0x" + Long.toHexString(l) + "\n******************\n", false);
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl && (string = DvGeneralSov.processTypes(l2)).equals("array class")) {
            int n = dvAddressSpace.pointerSize();
            cTypeObject2 = new CTypeObject("Hjava_lang_Object", l, dvAddressSpace);
            cTypeObject = cTypeObject2.getField("methods");
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            try {
                l6 = cTypeObject.getValue(n);
                long l7 = l + (long)n * (l6 + 2L);
                l4 = DvUtils.getPtrFromPtr(DvConsole.theDump, dvAddressSpace, l7);
                CTypeObject cTypeObject5 = new CTypeObject("Hjava_lang_Class", l4, readerProxy);
                String string2 = (String)classNames.get(cTypeObject5);
                if (string2 != null) {
                    string = string2;
                } else {
                    CTypeObject cTypeObject6 = cTypeObject5.getField("obj").getField("name").deReference();
                    if (cTypeObject6 != null) {
                        string = "arrObj " + DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject6.getAddr()), 256L));
                        classNames.put(cTypeObject5, string);
                    }
                }
            }
            catch (DvAddressException dvAddressException) {
                System.err.println("DvAddressException whilst figuring out  class name for array of classes !");
                System.err.println("Array object: 0x" + Long.toHexString(l) + "\n" + "   Array Size: " + l6 + "\n" + "   Class of array objects Address: 0x" + Long.toHexString(l4) + "\n" + "   Use \"format 0x" + Long.toHexString(l4) + " Hjava_lang_Class \" to help analyse this error");
            }
        }
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processObjectName(long, DvAddressSpace)");
        return string;
    }

    public static String processClassName(DvObject dvObject) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processClassName(ObjectDetails)");
        if (0 != dvObject.objectName.compareToIgnoreCase("java/lang/Class")) {
            DvUtils.writetoTrace("Exit:1 DvGeneralSov.processClassName(ObjectDetails)");
            return null;
        }
        long l = dvObject.address;
        String string = null;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        try {
            long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
            long l3 = DvUtils.getControlBlockField("Classjava_lang_Class", "name", l2, dvAddressSpace);
            string = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l3), 256L));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvGeneralSov.processClassName(ObjectDetails) DvAddressException");
        }
        DvUtils.writetoTrace("Exit:2 DvGeneralSov.processClassName(ObjectDetails)");
        return string;
    }

    private static String processObjectName(DvObject dvObject, DvHeap dvHeap, ReaderProxy readerProxy) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.processObjectName(ObjectDetails)");
        String string = "";
        long l = dvObject.address;
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.processObjectName(ObjectDetails)");
        return DvGeneralSov.processObjectName(l, (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A"), dvHeap, readerProxy);
    }

    public static boolean flipEAB(long l) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.flipEAB(long)");
        boolean bl = true;
        if (extendedAllocBits == null) {
            DvGeneralSov.createEAB(as);
        }
        long l2 = l;
        long l3 = l2 - startOfMHeap;
        l2 = l3 / 64L;
        int n = (int)(l3 % 64L) / 8;
        try {
            if (0 == (extendedAllocBits[(int)l2] & allocBitsTestBytes[n])) {
                int n2 = (int)l2;
                extendedAllocBits[n2] = (byte)(extendedAllocBits[n2] | allocBitsTestBytes[n]);
                int n3 = extendedAllocBits[(int)l2];
                if (n3 < 0) {
                    n3 += 256;
                }
            } else {
                DvUtils.trace("Continue:2 DvGeneralSov.flipEAB(long) Found extendedAllocBits inconsistency \n for: 0x" + Long.toHexString(l) + " bit already on !\n" + "This is suggestive of heap corruption and\n" + "should be investigated\n", 0, true);
                bl = false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            DvUtils.trace("Continue:2 DvGeneralSov.flipEAB(long) Trying to flip bit outside of array for 0x" + Long.toHexString(l), 0, true);
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.flipEAB(long)");
        return bl;
    }

    private static String objectHistory() {
        StringBuffer stringBuffer = new StringBuffer("\tObject History: ");
        int n = soaPosition;
        long l = storedObjAddresses[n];
        while (l != 0L) {
            stringBuffer.append(" 0x");
            stringBuffer.append(Long.toHexString(l));
            if (--n == -1) {
                n = 4;
            }
            if (n == soaPosition) break;
            l = storedObjAddresses[n];
            if (l == 0L) continue;
            stringBuffer.append(" <--");
        }
        return stringBuffer.toString();
    }

    public static void createEAB(DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.createEAB(DvAddressSpace)");
        String string = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE");
        String string2 = DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPLIMIT");
        String string3 = DvUtils.getJVMHint(dvAddressSpace, "TH_HEAPBASE");
        String string4 = DvUtils.getJVMHint(dvAddressSpace, "TH_HEAPLIMIT");
        startOfMHeap = Long.parseLong(string, 16);
        endOfMHeap = Long.parseLong(string2, 16);
        startOfTransHeap = Long.parseLong(string3, 16);
        endOfTransHeap = Long.parseLong(string4, 16);
        int n = 0;
        n = 0L == endOfTransHeap ? (int)((endOfMHeap - startOfMHeap) / 64L) : (int)((endOfTransHeap - startOfMHeap) / 64L);
        extendedAllocBits = new byte[n];
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.createEAB(DvAddressSpace) Allocated " + n + " bytes for extendedAllocBits");
    }

    private static void traverseMiddlewareHeap(DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseMiddlewareHeap()");
        DvGeneralSov.storedObjAddresses[0] = 0L;
        DvGeneralSov.storedObjAddresses[1] = 0L;
        DvGeneralSov.storedObjAddresses[2] = 0L;
        DvGeneralSov.storedObjAddresses[3] = 0L;
        DvGeneralSov.storedObjAddresses[4] = 0L;
        soaPosition = 0;
        int n = 0;
        String string = "\nTraversing the Middleware heap\n";
        dvHeap.doOutput(string, true);
        startOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMIN"), 16);
        endOfMHeap = Long.parseLong(DvUtils.getJVMHint(as, "CURHEAPMAX"), 16);
        middlewareH = n = DvGeneralSov.traverseHeap(startOfMHeap, endOfMHeap, Long.parseLong(DvUtils.getJVMHint(as, "MH_HEAPBASE"), 16), "Mid", (short)-1, dvHeap);
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseMiddlewareHeap()");
    }

    private static int traverseHeap(long l, long l2, long l3, String string, short s, DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseHeap() - " + string);
        int n = 0;
        int n2 = 0;
        DvGeneralSov.storedObjAddresses[0] = 0L;
        DvGeneralSov.storedObjAddresses[1] = 0L;
        DvGeneralSov.storedObjAddresses[2] = 0L;
        DvGeneralSov.storedObjAddresses[3] = 0L;
        DvGeneralSov.storedObjAddresses[4] = 0L;
        soaPosition = 0;
        boolean bl = false;
        int n3 = DvConsole.theDump.getArchitecture();
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l), dvAddressSpace) || l == l2) {
            String string2 = "Event traverseHeap min value not in dump";
            dvHeap.doOutput(string2, true);
            DvUtils.writetoTrace("Exit:2 DvGeneralSov.traverseHeap() error with min=" + Long.toHexString(l) + " max=" + Long.toHexString(l2) + " value");
            return n;
        }
        if (!DvUtils.checkAddressInDump(dvAddressSpace.createAddress(l2), dvAddressSpace)) {
            DvUtils.writetoTrace("Continue:1 DvGeneralSov.traverseHeap() max=" + Long.toHexString(l2) + " value not in heap");
        }
        long l4 = l;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        ReaderProxy readerProxy = new ReaderProxy(dvAddressSpace);
        if (0 == string.compareToIgnoreCase("MIDDLEWARE") || 0 == string.compareToIgnoreCase("TRANSIENT") || 0 == string.compareToIgnoreCase("MID") || 0 == string.compareToIgnoreCase("TRA")) {
            bl = true;
        }
        for (l4 = l; l4 < l2; l4 += l6) {
            if (++soaPosition == 5) {
                soaPosition = 0;
            }
            DvGeneralSov.storedObjAddresses[DvGeneralSov.soaPosition] = l4;
            long l10 = l4;
            boolean bl2 = false;
            try {
                readerProxy = ReaderProxy.getProxy(readerProxy, new DvAddress(l4));
                if (is64bit) {
                    l6 = readerProxy.readLong(new DvAddress(l10));
                    if (1L == (l6 & 1L)) {
                        bl2 = true;
                    }
                    l6 &= 0x3FFFFFFFFFFFFFF8L;
                } else {
                    l6 = readerProxy.readInt(new DvAddress(l10));
                    if (1L == (l6 & 1L)) {
                        bl2 = true;
                    }
                    l6 &= 0x3FFFFFF8L;
                }
            }
            catch (DvAddressException dvAddressException) {
                String string3 = "DvAddressException in traverseHeap";
                dvHeap.doOutput(string3, true);
                DvUtils.writetoTrace("Exit:3 DvGeneralSov.traverseHeap() DvAddressException");
                return n;
            }
            if (l6 > 0L) {
                if (!bl || DvGeneralSov.checkAllocbit(l4 - l3, dvAddressSpace)) {
                    boolean bl3 = DvGeneralSov.processFoundObject(l4, bl, s, l6, bl2, dvHeap, readerProxy);
                    ++n;
                    if (bl2) {
                        ++totalSwappedObjectCount;
                        totalSwappedObjectLength += l6;
                    }
                    if (!bl3) {
                        l4 = l2;
                    }
                }
                if (n < n2 + 50000) continue;
                long l11 = (l4 - l) * 100L / (l2 - l);
                String string4 = null;
                string4 = null == DvUtils.getProperty("UNITTEST") ? DvUtils.getTime() + " " + n + " objects processed...(" + l11 + "% of range scanned so far)" : n + " objects processed...(" + l11 + "% of range scanned so far)";
                dvHeap.doOutput(string4, true);
                n2 = n;
                continue;
            }
            DvUtils.trace("WARNING Scanning has reached a point in the heap (object length@0x" + Long.toHexString(l4) + ")\n" + " where the object length is 0 or less (" + Long.toHexString(l6) + ")\n" + "This can occur because the dump has been taken in the middle\n" + "of a GC cycle (common) or because the heap is corrupted (rare).\n" + "Analysis of this heap will terminate at this point.\n" + "If dump is in middle of GC cycle then further errors may appear later\n" + " as references may be in a \"transitional\" state.\n" + DvGeneralSov.objectHistory() + "\n", 0, true);
            l4 = l2;
        }
        dvHeap.createSubHeap(l, l2, string, null, n, true);
        String string5 = string + " traversal finished - " + n + " objects";
        dvHeap.doOutput(string5, true);
        DvUtils.writetoTrace("Exit:4 DvGeneralSov.traverseHeap()");
        return n;
    }

    private static boolean checkAllocbit(long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjects.checkAllocbit  (0x" + Long.toHexString(l) + ")");
        boolean bl = false;
        int n = 0;
        long l2 = 0L;
        byte by = 0;
        long l3 = l / 64L;
        if (0L == allocBitsAddress) {
            allocBitsAddress = DvUtils.hexToLong(DvUtils.getJVMHint(as, "ALLOCBITS"));
            allocBitsBuffer = new byte[allocBitsBufferSize];
            allocBitsBufferStart = Long.MAX_VALUE;
        }
        if (0L != allocBitsAddress) {
            try {
                if (l3 < allocBitsBufferStart || l3 >= allocBitsBufferStart + (long)allocBitsBufferSize) {
                    allocBitsBuffer = as.readBytes(dvAddressSpace.createAddress(allocBitsAddress + l3), (long)allocBitsBufferSize);
                    allocBitsBufferStart = l3;
                }
                by = allocBitsBuffer[(int)(l3 - allocBitsBufferStart)];
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("Continue:1 DvObjects.checkAllocbit \n DvAddressException trying to read AllocBits\n Address = 0x" + Long.toHexString(allocBitsAddress + l3) + "\n Address: ", 0, true);
            }
        } else {
            DvUtils.trace("Continue:2 DvObjects.checkAllocbit \n ALLOCBITS hint was 0 - suggests an error in control\n block structure or wrong types file information\n ", 0, true);
        }
        n = (int)(l % 64L) / 8;
        if (!isBigEndian) {
            n = 7 - n;
        }
        if (0 != (by & allocBitsTestBytes[n])) {
            bl = true;
        }
        DvUtils.writetoTrace("Exit:1 DvObjects.checkAllocbit (" + (bl ? "true)" : "false)"));
        return bl;
    }

    private static void traverseTransientHeap(DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseTransientHeap()");
        int n = 0;
        String string = "\nTraversing the transient heap \n";
        dvHeap.doOutput(string, true);
        startOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPBASE"));
        endOfTransHeap = DvUtils.hexToLong(DvUtils.getJVMHint(as, "TH_HEAPLIMIT"));
        transientH = n = DvGeneralSov.traverseHeap(startOfTransHeap, endOfTransHeap, DvUtils.hexToLong(DvUtils.getJVMHint(as, "MH_HEAPBASE")), "Tra", (short)-3, dvHeap);
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseTransientHeap()");
    }

    private static void traverseSystemHeaps(DvHeap dvHeap) {
        Range range;
        long l;
        long l2;
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseSystemHeaps()");
        int n = 0;
        int n2 = 0;
        String string = "Traversing the system heaps \n";
        dvHeap.doOutput(string, true);
        Vector<Range> vector = new Vector<Range>();
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvAddress dvAddress = dvAddressSpace.createAddress(DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "STGLOBALPTR")));
        DvAddress dvAddress2 = dvAddressSpace.createAddress(0L);
        long l3 = DvUtils.hexToLong(DvUtils.getJVMHint(dvAddressSpace, "MH_HEAPBASE"));
        long l4 = DvUtils.getControlBlockField("STGlobal", "st_jab", dvAddress.getAddressAsLong(), dvAddressSpace);
        dvAddress2 = dvAddressSpace.createAddress(DvUtils.getControlBlockField("StorageJab", "system_heap_this_extent", l4, dvAddressSpace));
        if (0L != dvAddress2.getAddressAsLong() && DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = DvUtils.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = DvUtils.getControlBlockField("StorageJab", "system_heap_next", l4, dvAddressSpace);
            range = new Range(l2, l, -1L);
            vector.add(range);
            n += DvGeneralSov.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2), dvHeap);
            ++n2;
        }
        dvAddress2 = dvAddressSpace.createAddress(DvUtils.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        while (0L != dvAddress2.getAddressAsLong() && DvUtils.checkAddressInDump(dvAddress2, dvAddressSpace)) {
            l2 = DvUtils.getControlBlockField("heap_extent_info", "base", dvAddress2.getAddressAsLong(), dvAddressSpace);
            l = DvUtils.getControlBlockField("heap_extent_info", "limit", dvAddress2.getAddressAsLong(), dvAddressSpace);
            range = new Range(l2, l, -1L);
            vector.add(range);
            n += DvGeneralSov.traverseHeap(l2, l, l3, "Sys " + n2, (short)(-4 - n2), dvHeap);
            ++n2;
            dvAddress2 = dvAddressSpace.createAddress(DvUtils.getControlBlockField("heap_extent_info", "prev", dvAddress2.getAddressAsLong(), dvAddressSpace));
        }
        systemH = n;
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.traverseSystemHeaps()");
    }

    private static void traverseACSHeap(DvHeap dvHeap) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.traverseACSHeap()");
        DvDump dvDump = DvConsole.theDump;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        ReaderProxy readerProxy = new ReaderProxy(dvAddressSpace);
        int n2 = dvAddressSpace.pointerSize();
        int n3 = dvDump.getArchitecture();
        boolean bl = DvUtils.is64BitSystem(n3);
        long l3 = 0L;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l4 = DvUtils.jvmFromThreadId(dvThread.id());
        String string = DvUtils.getJVMHint(l4, "LOADEDACSCLASSES");
        if (null != string) {
            long l5;
            l = l5 = DvUtils.hexToLong(string);
            try {
                DvUtils.writetoTrace("  current_start = " + Long.toHexString(l5));
                long l6 = 0L;
                if (0L != l5) {
                    l6 = DvUtils.getFieldAddress(l5, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
                long l7 = l6 - l5;
                while (0L != l6) {
                    long l8 = l5 - (long)n2;
                    l3 = l6;
                    readerProxy = ReaderProxy.getProxy(readerProxy, new DvAddress(l3));
                    long l9 = DvUtils.getFieldAddress(l3, new String[]{"Classjava_lang_Class", "shared_class_id"}, dvAddressSpace);
                    int n4 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l9));
                    if (n4 != 0) {
                        return;
                    }
                    boolean bl2 = false;
                    try {
                        if (is64bit) {
                            l2 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l8));
                            if (1L == (l2 & 1L)) {
                                bl2 = true;
                            }
                            l2 &= 0x3FFFFFFFFFFFFFF8L;
                        } else {
                            l2 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l8));
                            if (1L == (l2 & 1L)) {
                                bl2 = true;
                            }
                            l2 &= 0x3FFFFFF8L;
                        }
                    }
                    catch (DvAddressException dvAddressException) {
                        String string2 = "DvAddressException during traverseACSHeap (objLength calculation)\nACS Heap Traversal terminated.";
                        DvUtils.trace(string2, 0, true);
                        return;
                    }
                    DvGeneralSov.processFoundObject(l8, false, (short)-2, l2, bl2, dvHeap, readerProxy);
                    if (bl2) {
                        ++totalSwappedObjectCount;
                        totalSwappedObjectLength += l2;
                    }
                    ++n;
                    long l10 = DvUtils.getFieldAddress(l3, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
                    l5 = l6 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l10);
                    if (0L == l6) continue;
                    l6 = DvUtils.getFieldAddress(l6, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
            }
            catch (DvAddressException dvAddressException) {
                String string3 = "DvAddressException during traverseACSHeap\ncurrent_start: 0x" + Long.toHexString(l5) + "\nACS Heap Traversal terminated";
                DvUtils.trace(string3, 0, true);
                return;
            }
        }
        String string4 = "Unable to find hint for LOADEDACSCLASSES\nPossible error in control block analysis\nACS Heap Traversal terminated";
        DvUtils.trace(string4, 0, true);
        return;
        acsH = n;
        dvHeap.createSubHeap(l, -1L, "ACS Heap", null, n, true);
        DvUtils.writetoTrace("Exit: DvGeneralSov.traverseACSHeap() :" + n);
    }

    public static void getObjectDetails(DvObject dvObject, DvHeap dvHeap) {
        DvGeneralSov.getObjectDetails(dvObject, dvHeap, new ReaderProxy(as));
    }

    public static void getObjectDetails(DvObject dvObject, DvHeap dvHeap, ReaderProxy readerProxy) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.getObjectDetails(long " + dvObject.address + ")");
        long l = dvObject.address;
        try {
            dvObject.length = readerProxy.readPointer(as.createAddress(l));
            dvObject.length = is64bit ? (dvObject.length &= 0x3FFFFFFFFFFFFFF8L) : (dvObject.length &= 0x3FFFFFF8L);
            dvObject.address = l += (long)as.pointerSize();
            CTypeObject cTypeObject = new CTypeObject("Hjava_lang_Class", new DvAddress(l), readerProxy);
            dvObject.locknflags = cTypeObject.getField("locknflags").getValue();
            dvObject.locknflags &= 0xFFFFFFFFL;
            dvObject.methods = cTypeObject.getField("methods").getValue();
            dvObject.obj = (int)cTypeObject.getField("obj").getAddr();
            dvObject.init_thread = cTypeObject.getField("obj.mirrored_data.init_thread").getValue();
            DvGeneralSov.processData(dvObject, dvHeap, readerProxy);
            dvObject.arrayElementCount = DvGeneralSov.getArrayElementCount(dvObject.address, as);
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("Continue:1 DvGeneralSov.getObjectDetails(long)");
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.getObjectDetails(long)");
    }

    static int getArrayElementCount(long l, DvAddressSpace dvAddressSpace) throws DvAddressException {
        long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Object", "methods"}, dvAddressSpace);
        return dvAddressSpace.readInt(dvAddressSpace.createAddress(l2));
    }

    public String getThreadName(DvAddressSpace dvAddressSpace, DvThread dvThread) {
        String string = " !!! Not determined !!!";
        long l = -1L;
        if (dvThread.eeAddress().getAddressAsLong() == 0L) {
            return string;
        }
        CTypeObject cTypeObject = new CTypeObject("execenv", dvThread.eeAddress(), dvAddressSpace);
        l = DvUtils.readPtrAsLong(cTypeObject.getField("thread"), dvAddressSpace);
        try {
            if (-1L != l) {
                DvDump dvDump = DvConsole.theDump;
                CTypeObject cTypeObject2 = new CTypeObject("Hjava_lang_Thread", dvAddressSpace.createAddress(l), dvAddressSpace);
                CTypeObject cTypeObject3 = cTypeObject2.getField("obj");
                CTypeObject cTypeObject4 = cTypeObject3.getField("name");
                DvAddress dvAddress = null;
                dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject4.getAddr()));
                CTypeObject cTypeObject5 = new CTypeObject("Hjava_lang_Object", dvAddressSpace.createAddress(dvAddress.getAddressAsLong()), dvAddressSpace);
                CTypeObject cTypeObject6 = cTypeObject5.getField("obj");
                CTypeObject cTypeObject7 = cTypeObject5.getField("methods");
                long l2 = 0L;
                l2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject7.getAddr())).getAddressAsLong();
                if (l2 > 0L) {
                    if (l2 > 100L) {
                        l2 = 100L;
                    }
                    byte[] byArray = null;
                    byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(cTypeObject6.getAddr()), l2 * 2L);
                    byte[] byArray2 = new byte[byArray.length / 2];
                    int n = 0;
                    if (isBigEndian) {
                        n = 1;
                    }
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = byArray[2 * i + n];
                    }
                    string = new String(byArray2, "ascii");
                }
            }
        }
        catch (Exception exception) {
            DvUtils.writetoTrace(" Unable to establish thread name from 0x" + Long.toHexString(l));
            DvUtils.writetoTrace(" Stack: " + exception.toString());
        }
        return string;
    }

    public static Long getObjectLength(Long l) {
        long l2 = 0L;
        long l3 = l;
        try {
            if (is64bit) {
                l2 = as.readLong(as.createAddress(l3));
                l2 &= 0x3FFFFFFFFFFFFFF8L;
            } else {
                l2 = as.readInt(as.createAddress(l3));
                l2 &= 0x3FFFFFF8L;
            }
        }
        catch (DvAddressException dvAddressException) {
            // empty catch block
        }
        return new Long(l2);
    }

    public static Boolean checkForKnownObject(Long l) {
        DvUtils.writetoTrace("Entry:DvGeneralSov.checkForKnownObject(long)");
        boolean bl = false;
        long l2 = l;
        if (0L == (l2 + (long)ptrLength) % 8L) {
            if (l2 >= startOfMHeap && l2 <= endOfMHeap) {
                long l3 = l2;
                long l4 = l3 - startOfMHeap;
                int n = (int)(l4 % 64L) / 8;
                if (0 != (extendedAllocBits[(int)(l3 = l4 / 64L)] & allocBitsTestBytes[n])) {
                    bl = true;
                }
            } else {
                Long l5 = new Long(l2);
                if (systemHeapHashByAddr.contains(l5) || acsHeapHashByAddr.contains(l5)) {
                    bl = true;
                }
            }
        }
        DvUtils.writetoTrace("Exit:1 DvGeneralSov.checkForKnownObject(long)");
        return new Boolean(bl);
    }

    public static boolean isInGC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
        int n = 0;
        try {
            CTypeObject cTypeObject2 = cTypeObject.getField("facade.st.dataP").deReference("STGlobal");
            CTypeObject cTypeObject3 = cTypeObject2.getField("currently_in_GC0");
            long l = cTypeObject3.getAddr();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            n = dvAddressSpace.readInt(dvAddress);
        }
        catch (Exception exception) {
            return false;
        }
        return n != 0;
    }

    public static boolean isInResetGC(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
        int n = 0;
        try {
            CTypeObject cTypeObject2 = cTypeObject.getField("facade.st.dataP").deReference("STGlobal");
            CTypeObject cTypeObject3 = cTypeObject2.getField("performing_reset_GC");
            long l = cTypeObject3.getAddr();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            n = dvAddressSpace.readInt(dvAddress);
        }
        catch (Exception exception) {
            return false;
        }
        return n != 0;
    }

    public static int signalReceived(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
        int n = -1;
        try {
            CTypeObject cTypeObject2 = cTypeObject.getField("facade.dg.dataP").deReference("DgData");
            CTypeObject cTypeObject3 = cTypeObject2.getField("signalNumber");
            long l = cTypeObject3.getAddr();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            n = dvAddressSpace.readInt(dvAddress);
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    public static boolean isResettable(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
        int n = -1;
        try {
            CTypeObject cTypeObject2 = cTypeObject.getField("jab").deReference("JvmSetAnchorBlock");
            CTypeObject cTypeObject3 = cTypeObject2.getField("xm.resettable");
            long l = cTypeObject3.getAddr();
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            n = dvAddressSpace.readInt(dvAddress);
        }
        catch (Exception exception) {
            return false;
        }
        return n != 0;
    }

    public static Vector postDisOsInfo() {
        Vector<String> vector = new Vector<String>();
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l = DvUtils.jvmFromExecenv(dvAddressSpace, dvThread.eeAddress());
        CTypeObject cTypeObject = new CTypeObject("Jvm", new DvAddress(l), dvAddressSpace);
        summarySB = new StringBuffer();
        summarySB.append("\n\n Total number of \"Swapped\" objects         = " + totalSwappedObjectCount + " (" + totalSwappedObjectLength + " bytes)\n");
        summarySB.append(" Total number of \"Locked\" objects          = " + totalLockedObjectCount + "\n");
        summarySB.append(" Total number of Hashed and Moved objects  = " + totalHMObjectCount + "\n");
        summarySB.append(" Total number of Hashed objects            = " + totalHObjectCount + "\n");
        summarySB.append(" Total number of Arrays                    = " + totalArrayObjectCount + "\n\n");
        if (DvGeneralSov.isInGC(cTypeObject, dvAddressSpace)) {
            vector.add("\n *** The JVM appears to be in a Garbage Collection cycle (within GC0).\n");
            if (totalSwappedObjectCount != 0L) {
                summarySB.append(" *** As various heap objects were marked as \"Swapped\" then\n *** its likely that heap compaction was taking place when this\n *** jvm was dumped. The addresses of the marked objects can be\n *** found using \"dis obj(+IsSwapped+)\"   \n");
            }
        } else if (DvGeneralSov.isResettable(cTypeObject, dvAddressSpace) && DvGeneralSov.isInResetGC(cTypeObject, dvAddressSpace)) {
            vector.add("\n *** The JVM appears to be in a Reset GC cycle.\n");
        } else {
            vector.add("\n *** The JVM does not seem to be in Garbage Collection (not within GC0).\n");
            if (totalSwappedObjectCount != 0L) {
                summarySB.append(" Various heap objects were marked as \"Swapped\".  As the JVM\n is not in GC, it is likely that these are in fact multi-pinned.\n The addresses of these objects can be found using:\n \"dis obj(+IsSwapped+)\" \n");
            }
        }
        vector.add(DvGeneralSov.getSummaryInfo());
        return vector;
    }

    private static String getSummaryInfo() {
        return summarySB.toString();
    }

    static {
        javaThreadsWithoutTLH = 0L;
        javaThreadsWithTLH = 0L;
        javaThreadsWithoutTHTLH = 0L;
        javaThreadsWithTHTLH = 0L;
        verboseTLH = false;
        ptrLength = 4;
        totalSwappedObjectCount = 0L;
        totalSwappedObjectLength = 0L;
        totalObjectCount = 0L;
        systemHeapHashByAddr = new HashSet();
        acsHeapHashByAddr = new HashSet();
        lockedObjects = new Vector();
        totalLockedObjectCount = 0L;
        totalHMObjectCount = 0L;
        totalArrayObjectCount = 0L;
        totalHObjectCount = 0L;
        extendedAllocBits = null;
        allocBitsAddress = 0L;
        allocBitsTestBytes = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        startOfMHeap = 0L;
        endOfMHeap = 0L;
        startOfTransHeap = 0L;
        endOfTransHeap = 0L;
        is64bit = false;
        isBigEndian = false;
        allocBitsBufferSize = 2048;
        storedObjAddresses = new long[]{0L, 0L, 0L, 0L, 0L};
        soaPosition = 0;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
        classNames = new HashMap();
        hits = 0L;
        misses = 0L;
    }

    private static class Range {
        protected long start;
        protected long end;
        protected long index;

        protected Range(long l, long l2, long l3) {
            this.start = l;
            this.end = l2;
            this.index = l3;
        }
    }
}

