/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.lang.reflect.Method;
import java.util.Vector;

public class DvJavacorePlugin
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvJavacorePlugin";
    protected static Vector output = new Vector();
    protected static DvAddressSpace as = null;
    private static boolean tags = true;
    private static boolean verbose = false;
    private static boolean DEBUG = false;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final long DG_TRC_BUFFER_ACTIVE = 0x80000000L;
    private static String[] commandsSupported = new String[]{"JAVACORE,JAV,HELP,*,CMD_JavacoreHelp", "HELP,?,JAVACORE,JAV,CMD_JavacoreHelp", "JAVACORE,JAV,TAGS,TAG,CMD_JavacoreTags", "JAVACORE,JAV,VERBOSE,*,CMD_JavacoreVerbose", "JAVACORE,JAV,SECTION,SEC,CMD_JavacoreSection", "JAVACORE,JAV,*,*,CMD_Javacore", "JC,J,HELP,*,CMD_JavacoreHelp", "HELP,?,JC,J,CMD_JavacoreHelp", "JC,J,TAGS,TAG,CMD_JavacoreTags", "JC,J,VERBOSE,*,CMD_JavacoreVerbose", "JC,J,SECTION,SEC,CMD_JavacoreSection", "JC,J,*,*,CMD_Javacore", "JC,J,H,?,CMD_JavacoreHelp", "JC,J,T,T,CMD_JavacoreTags", "JC,J,VERBOSE,V,CMD_JavacoreVerbose", "JC,J,SECTION,S,CMD_JavacoreSection", "JC,J,*,*,CMD_Javacore", "JAVADUMP,*,HELP,*,CMD_JavacoreHelp", "HELP,?,JAVACORE,JAV,CMD_JavacoreHelp", "JAVADUMP,*,TAGS,TAG,CMD_JavacoreTags", "JAVADUMP,*,VERBOSE,*,CMD_JavacoreVerbose", "JAVADUMP,*,SECTION,*,CMD_JavacoreSection", "JAVADUMP,*,*,*,CMD_Javacore"};
    public static DvJavacorePlugin that;

    public DvJavacorePlugin() {
        that = this;
        DvJavacorePlugin.initStatics();
    }

    public void CMD_JavacoreHelp() {
        output.add("\nHELP FOR USING JAVACORE\n=======================\n");
        output.add("These are the currently supported commands:\n");
        output.add("JAVACORE HELP               - this information.");
        output.add("JAVACORE TAGS true|false    - turn the tags ON or OFF.");
        output.add("JAVACORE                    - produce a Javacore.");
        output.add("JAVACORE SECTION xx         - produce Javacore for named section.");
        output.add("JAVACORE VERBOSE true|false - set verbose mode on|off");
        output.add("JAVACORE SECTION xx         - produce Javacore for named section.");
        output.add(" ");
        output.add("NB - all commands may also be entered as JAVADUMP...");
        output.add(" ");
        this.returnControl();
    }

    protected static void initStatics() {
        DvDump dvDump = DvConsole.theDump;
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
    }

    public void CMD_JavacoreTags() {
        String string = "Usage error:\n   Javacore tags true|false";
        if (DvJavacorePlugin.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (this.paramString == null) {
            output.add(string);
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("TRUE")) {
            tags = true;
            output.add("\nJavacore tags have been turned ON\n");
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("FALSE")) {
            tags = false;
            output.add("\nJavacore tags have been turned OFF\n");
            this.returnControl();
            return;
        }
        output.add(string);
        this.returnControl();
    }

    public void CMD_JavacoreVerbose() {
        String string = "Usage error:\n   Javacore verbose true|false";
        if (DvJavacorePlugin.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (this.paramString == null) {
            output.add(string);
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("TRUE")) {
            verbose = true;
            output.add("\nJavacore verbose mode has been turned ON\n");
            this.returnControl();
            return;
        }
        if (this.paramString.toUpperCase().equals("FALSE")) {
            verbose = false;
            output.add("\nJavacore verbose mode has been turned OFF\n");
            this.returnControl();
            return;
        }
        output.add(string);
        this.returnControl();
    }

    public void CMD_JavacoreSection() {
        DvDump dvDump = DvConsole.theDump;
        if (DvJavacorePlugin.noDumpAccessed()) {
            output.add(" ");
            this.returnControl();
            return;
        }
        if (dvDump.getSystemType() == 4) {
            try {
                DvAddressSpace dvAddressSpace = dvDump.getCurrentAddressSpace();
            }
            catch (Error error) {
                output.add("*** SVC DUMP DETECTED ***");
                output.add(" ");
                output.add("-----------------------------------------------------------------------------------");
                output.add("When working with a z/OS SVC dump, in this version of the dump formatter, Javacore");
                output.add("and Javadump commands are unable to provide all the information typically available");
                output.add("in JAVADUMP, but they will show what they can.");
                output.add("-----------------------------------------------------------------------------------");
                output.add(" ");
            }
        }
        if (this.paramString == null) {
            output.add("Usage Error: No javacore section specified, expected:");
            output.add("   Javacore section TITLE|XHPI|CI|DC|DG|ST|XE|LK|XM|CL|END");
            this.returnControl();
            return;
        }
        DvJavacorePlugin.initStatics();
        this.doSection(this.paramString.toUpperCase(), output);
        DvJavacorePlugin.printWithTag("NULL", "---------------------------------------------------------------");
        this.returnControl();
    }

    public void CMD_Javacore() {
        Vector vector = new Vector();
        this.CMD_Javacore(vector);
        this.cpr.output(vector);
        DvJavacorePlugin.outputFlush();
        this.returnControl();
    }

    public void CMD_Javacore(Vector vector) {
        if (vector != null) {
            output = vector;
        }
        vector.add("\nProduce a Javacore...\n");
        DvDump dvDump = DvConsole.theDump;
        if (DvJavacorePlugin.noDumpAccessed()) {
            vector.add(" ");
            consolidatedOutput = false;
            return;
        }
        if (dvDump.getSystemType() == 4) {
            try {
                DvAddressSpace dvAddressSpace = dvDump.getCurrentAddressSpace();
            }
            catch (Error error) {
                vector.add("*** SVC DUMP DETECTED ***");
                vector.add(" ");
                vector.add("-----------------------------------------------------------------------------------");
                vector.add("When working with a z/OS SVC dump, in this version of the dump formatter, Javacore");
                vector.add("and Javadump commands are unable to provide all the information typically available");
                vector.add("in JAVADUMP, but they will show what they can.");
                vector.add("-----------------------------------------------------------------------------------");
                vector.add(" ");
            }
        }
        this.ensureHeapsTraversed();
        DvJavacorePlugin.initStatics();
        this.doSection("TITLE", vector);
        this.doSection("XHPI", vector);
        this.doSection("CI", vector);
        this.doSection("DC", vector);
        this.doSection("DG", vector);
        this.doSection("ST", vector);
        this.doSection("XE", vector);
        this.doSection("LK", vector);
        this.doSection("XM", vector);
        this.doSection("CL", vector);
        this.doSection("END", vector);
        if (consolidatedOutput) {
            this.cpr.output(vector);
            this.forcedEnd = true;
            consolidatedOutput = false;
        } else {
            this.returnControl();
        }
    }

    private void ensureHeapsTraversed() {
        if (!DvObjectsCommands.heapsAlreadyTraversed()) {
            output.add("\nJavacore is traversing heaps... please wait");
            output.add("(This is because you had not yet run display objects.)\n");
            DvJavacorePlugin.outputFlush();
            String[] stringArray = DvConsole.execValidCmdToArray("dis os");
        }
    }

    protected static void newSection(String string) {
        String string2 = string + " subcomponent dump routine";
        String string3 = "";
        for (int i = 0; i < string2.length(); ++i) {
            string3 = string3.concat("=");
        }
        DvJavacorePlugin.printWithTag("NULL", "---------------------------------------------------------------");
        DvJavacorePlugin.printWithTag("0SECTION", string2);
        DvJavacorePlugin.printWithTag("NULL", string3);
    }

    protected static void printWithTag(String string, String string2) {
        String string3 = "               ";
        String string4 = string.concat(string3);
        string4 = string4.substring(0, 15);
        string4 = string4.concat(" ");
        string4 = string4.concat(string2);
        if (tags) {
            output.add(string4);
        } else {
            output.add(string2);
        }
    }

    protected static boolean noDumpAccessed() {
        if (DvConsole.theDump == null) {
            output.add("Unable to comply as no dump accessed yet.");
            return true;
        }
        return false;
    }

    private String getEnvVar(String string) {
        String string2 = "NULL";
        try {
            string2 = DvUtils.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = "NULL";
        }
        return string2;
    }

    protected static String[] getEnvVarsFromDump() {
        boolean bl = false;
        int n = 0;
        String[] stringArray = DvConsole.execValidCmdToArray("DIS PROC");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].toUpperCase().indexOf("LOADED DATA") != -1 || stringArray[i].indexOf("======") != -1) {
                bl = false;
            }
            if (bl && stringArray[i].indexOf(61) != -1) {
                vector.add(stringArray[i]);
                ++n;
            }
            if (stringArray[i].indexOf("Environment Variables") == -1) continue;
            bl = true;
        }
        if (n == 0) {
            return null;
        }
        vector.trimToSize();
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        if (((String)objectArray[0]).indexOf("No loaded information for this process") != -1) {
            return null;
        }
        return objectArray;
    }

    private String restOfLineAfter(String[] stringArray, String string) {
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            char c;
            int n;
            if (stringArray[i].toUpperCase().indexOf(string.toUpperCase()) == -1) continue;
            string2 = stringArray[i];
            string2 = string2.substring(string2.toUpperCase().indexOf(string.toUpperCase()), string2.length());
            string2 = string2.substring(string.length(), string2.length());
            for (n = 0; n < string2.length() && (Character.isLetterOrDigit(c = string2.charAt(n)) || " \u001a`!\u001a$%^&*()_+-={}[]:@~;'#<>?,./|\\".indexOf(c) != -1); ++n) {
            }
            if (n == 0) {
                return "*** Error: ZERO length string";
            }
            return string2.substring(0, n);
        }
        return null;
    }

    protected static long readPtrAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            DvAddress dvAddress = as.readPointer(as.createAddress(cTypeObject.getAddr()));
            l = dvAddress.getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            DvJavacorePlugin.outputFlush();
        }
        return l;
    }

    protected static int readAnInt(CTypeObject cTypeObject) {
        int n = -1;
        try {
            long l = cTypeObject.getAddr();
            DvAddress dvAddress = as.createAddress(l);
            n = as.readInt(dvAddress);
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read field from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            DvJavacorePlugin.outputFlush();
        }
        return n;
    }

    protected static byte readAByte(CTypeObject cTypeObject) {
        byte by = 0;
        try {
            long l = cTypeObject.getAddr();
            DvAddress dvAddress = as.createAddress(l);
            by = as.readByte(dvAddress);
        }
        catch (DvAddressException dvAddressException) {
            output.add("Exception while trying to read byte from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            output.add(dvAddressException.toString());
            DvJavacorePlugin.outputFlush();
        }
        return by;
    }

    public static void reInitialize() {
    }

    protected static String boolFieldToString(CTypeObject cTypeObject, String string, String string2) throws Exception {
        String string3 = "*** Dunno ***";
        int n = DvJavacorePlugin.readAnInt(cTypeObject);
        string3 = n == 0 ? string2 : string;
        return string3;
    }

    protected static String getCStringFromPtr(CTypeObject cTypeObject) throws DvAddressException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        long l = cTypeObject.getAddr();
        DvAddress dvAddress = as.readPointer(as.createAddress(cTypeObject.getAddr()));
        if (dvAddress.getAddressAsLong() != 0L) {
            byte by = as.readByte(dvAddress);
            for (int i = 0; by != 0 && i < 128; ++i) {
                stringBuffer.append((char)by);
                dvAddress = as.createAddress(dvAddress.getAddressAsLong() + 1L);
                by = as.readByte(dvAddress);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected static String truncateAtIllegalChar(String string) {
        String string2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ |\\,./<>?;'#:@~[]{}`\u00ac\u00a6!\u00a3$%^&*()_+-=\"0123456789";
        for (int i = 0; i < string.length(); ++i) {
            if (string2.indexOf(string.substring(i, i + 1)) != -1) continue;
            if (i == 0) {
                return new String("<ERROR>");
            }
            return string.substring(0, i);
        }
        return string;
    }

    private String xSpaces(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string.concat(" ");
        }
        return string;
    }

    protected static void outputFlush() {
        if (!consolidatedOutput) {
            DvJavacorePlugin.that.cpr.output(output);
            output.clear();
        }
    }

    protected static void outputAdd(String string) {
        output.add(string);
    }

    private void returnControl() {
        if (!consolidatedOutput) {
            DvJavacorePlugin.outputFlush();
            this.forcedEnd = true;
        }
    }

    private void doSection(String string, Vector vector) {
        Method method = null;
        Vector vector2 = new Vector();
        String string2 = "do" + string + "Section";
        Vector vector3 = DvUtils.findMethodForCurrentSuffix(string2, new Class[0]);
        if (null != vector3 && vector3.size() == 2) {
            CommandPlugin commandPlugin = (CommandPlugin)vector3.get(0);
            method = (Method)vector3.get(1);
            try {
                method.invoke((Object)commandPlugin, new Object[0]);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \"" + string2 + "\" supporting " + DvUtils.getSuffix(), 0, true);
                String string3 = exception.toString();
                DvUtils.trace(string3, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \"" + string2 + "\" supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvJavacorePlugin.properties");
        return vector;
    }

    public String pluginName() {
        return "Javacore plugin (DvJavacorePlugin)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }
}

