/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdffArchive;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.SDFFClock;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdffArchive.SdffArchive;
import com.ibm.jvm.util.FileCRC32;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class SdffArchiveInputStream {
    private JarInputStream jarIn;
    private String extractSdffHeaderName;
    private String extractOriginalDumpName;
    private long sdffHeaderCrc32FromManifest;
    private long originalDumpCrc32FromManifest;
    private String sdffHeaderNameFromManifest;
    private String originalDumpNameFromManifest;
    private int newSdffFormatVersion;
    static int BUFFER_SIZE = 32768;
    static int CLOCK_TICK = 10;

    public SdffArchiveInputStream(String string) throws IOException {
        File file;
        JarEntry jarEntry;
        DvUtils.writetoTrace("Entry to SdffArchiveInputStream constructor (" + string + ")");
        this.jarIn = null;
        this.jarIn = new JarInputStream(new FileInputStream(string));
        DvUtils.writetoTrace("SdffArchiveInputStream opened Jar, getting manifest (" + string + ")");
        Manifest manifest = this.jarIn.getManifest();
        DvUtils.writetoTrace("SdffArchiveInputStream got manifest (" + string + ")");
        Attributes attributes = manifest.getMainAttributes();
        String string2 = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (!string2.equals("1")) {
            DvUtils.writetoTrace("SdffArchiveInputStream: sdff manifest version is " + string2 + " but should be " + "1");
            throw new RuntimeException("sdff manifest version is " + string2 + " but should be " + "1");
        }
        DvUtils.writetoTrace("SdffArchiveInputStream manifest version OK for (" + string + ")");
        String string3 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        if (!string3.equals("IBM JTC (Hursley Park, UK)")) {
            DvUtils.writetoTrace("SdffArchiveInputStream:sdff manifest vendor is " + string3 + " but should be " + "IBM JTC (Hursley Park, UK)");
            throw new RuntimeException("sdff manifest vendor is " + string3 + " but should be " + "IBM JTC (Hursley Park, UK)");
        }
        DvUtils.writetoTrace("SdffArchiveInputStream manifest vendor OK for (" + string + ")");
        this.newSdffFormatVersion = Integer.parseInt(attributes.getValue(SdffArchive.FORMAT_VERSION));
        if (this.newSdffFormatVersion != 1 && this.newSdffFormatVersion != 2) {
            DvUtils.writetoTrace("SdffArchiveInputStream:sdff format version is " + this.newSdffFormatVersion + " but should be " + 1 + "or" + 2);
            throw new RuntimeException("sdff format version is " + this.newSdffFormatVersion + " but should be " + 1 + "or" + 2);
        }
        DvUtils.writetoTrace("SdffArchiveInputStream format version OK for (" + string + ")");
        this.sdffHeaderNameFromManifest = attributes.getValue(SdffArchive.SDFF_HEADER_NAME);
        this.sdffHeaderCrc32FromManifest = Long.parseLong(attributes.getValue(SdffArchive.SDFF_HEADER_CRC32));
        this.originalDumpNameFromManifest = attributes.getValue(SdffArchive.ORIGINAL_DUMP_NAME);
        this.originalDumpCrc32FromManifest = Long.parseLong(attributes.getValue(SdffArchive.ORIGINAL_DUMP_CRC32));
        SdffArchiveData sdffArchiveData = null;
        try {
            DvUtils.writetoTrace("SdffArchiveInputStream getting SDFF header (" + string + ")");
            jarEntry = this.jarIn.getNextJarEntry();
            sdffArchiveData = new SdffArchiveData(new String(jarEntry.getExtra()));
            if (sdffArchiveData.contentType == null || !sdffArchiveData.contentType.equals("SDFF Header")) {
                DvUtils.writetoTrace("SdffArchiveInputStream:Did not find an sdff header");
                throw new IOException("Did not find an sdff header");
            }
            file = new File(jarEntry.getName());
            this.extractSdffHeaderName = file.getName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            DvUtils.writetoTrace("SdffArchiveInputStream didn't get header for (" + string + ")" + " expected content type '" + "SDFF Header" + "'" + " but found '" + sdffArchiveData.contentType + "'");
            throw new RuntimeException(throwable.toString());
        }
        if (!this.extractSdffHeaderName.equals(this.sdffHeaderNameFromManifest)) {
            DvUtils.writetoTrace("SdffArchiveInputStream - Sdff header name " + this.extractSdffHeaderName + " differs from that in the manifest " + this.sdffHeaderNameFromManifest);
            throw new RuntimeException("Corrupted Sdff Archive - invalid sdff header name");
        }
        try {
            DvUtils.writetoTrace("SdffArchiveInputStream getting original dump (" + string + ")");
            jarEntry = this.jarIn.getNextJarEntry();
            sdffArchiveData = new SdffArchiveData(new String(jarEntry.getExtra()));
            if (sdffArchiveData.contentType == null || !sdffArchiveData.contentType.equals("Original Dump")) {
                DvUtils.writetoTrace("SdffArchiveInputStream:Did not find the original dump");
                throw new IOException("Did not find the original dump");
            }
            file = new File(jarEntry.getName());
            this.extractOriginalDumpName = file.getName();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            DvUtils.writetoTrace("SdffArchiveInputStream didn't get original dump for (" + string + ")" + " expected content type '" + "Original Dump" + "'" + " but found '" + sdffArchiveData.contentType + "'");
            throw new RuntimeException(throwable.toString());
        }
        if (!this.extractOriginalDumpName.equals(this.originalDumpNameFromManifest)) {
            DvUtils.writetoTrace("SdffArchiveInputStream - original dump name " + this.extractOriginalDumpName + " differs from that in the manifest " + this.originalDumpNameFromManifest);
            throw new RuntimeException("Corrupted Sdff Archive - invalid original dump name");
        }
        this.close();
        this.jarIn = new JarInputStream(new FileInputStream(string));
    }

    public void extractHeader(boolean bl) throws IOException {
        Object object;
        JarEntry jarEntry = this.jarIn.getNextJarEntry();
        File file = new File(jarEntry.getName());
        SdffArchiveData sdffArchiveData = new SdffArchiveData(new String(jarEntry.getExtra()));
        this.checkedExtractFile(this.extractSdffHeaderName, this.sdffHeaderCrc32FromManifest, sdffArchiveData.size, DvUtils.getValue("SdffDir"));
        if (bl) {
            jarEntry = this.jarIn.getNextJarEntry();
            object = new File(jarEntry.getName());
            sdffArchiveData = new SdffArchiveData(new String(jarEntry.getExtra()));
            this.checkedExtractFile(this.extractOriginalDumpName, this.originalDumpCrc32FromManifest, sdffArchiveData.size, DvUtils.getValue("DumpDir"));
        }
        if ((object = DvUtils.getValue("LibDir")) != null) {
            DvUtils.writetoTrace("SdffArchiveInputStream: Extracting libraries to " + (String)object);
            while ((jarEntry = this.jarIn.getNextJarEntry()) != null) {
                sdffArchiveData = new SdffArchiveData(new String(jarEntry.getExtra()));
                if (!sdffArchiveData.contentType.equals("Library")) continue;
                this.checkedExtractFile(jarEntry.getName(), sdffArchiveData.crc, sdffArchiveData.size, (String)object);
            }
        }
    }

    private void checkedExtractFile(String string, long l, long l2, String string2) throws IOException {
        Object object;
        DvUtils.writetoTrace("SdffArchiveInputStream.checkedExtractFile  File is " + string + " Extract directory is " + string2 + " expectedChecksum is " + l + " (0x" + Long.toHexString(l) + ")" + " expectedSize is " + l2);
        String string3 = string2 != null ? string2 + File.separator + string : ((object = DvUtils.getProperty("WorkDir")) != null ? (String)object + File.separator + string : string);
        object = new File(string3).getAbsoluteFile();
        if (!((File)object).exists()) {
            DvUtils.writetoTrace("Parent is " + ((File)object).getParent());
            if (!((File)object).getParentFile().exists() && !((File)object).getParentFile().mkdirs()) {
                System.err.println("Could not create directory path " + string3);
                return;
            }
            this.doExtract((File)object, l, l2);
            return;
        }
        try {
            this.checkExtractedFile((File)object, l, l2);
            DvUtils.writetoTrace(((File)object).getPath() + " already exists with correct checksum and size - will not extract");
            return;
        }
        catch (RuntimeException runtimeException) {
            if (DvUtils.isForce()) {
                DvUtils.writetoTrace(((File)object).getPath() + " already exists but with the wrong checksum or size -" + " as force is set, will extract over it");
                this.doExtract((File)object, l, l2);
                return;
            }
            DvUtils.writetoTrace(((File)object).getPath() + " already exists but with the wrong checksum or size - cannot extract without force option");
            throw new RuntimeException(((File)object).getPath() + " already exists but with the wrong checksum or size - cannot extract without force option");
        }
    }

    private void doExtract(File file, long l, long l2) {
        SDFFClock sDFFClock = new SDFFClock("Extracting " + file.getPath() + " (1 tick = " + BUFFER_SIZE * CLOCK_TICK + " bytes) ...", CLOCK_TICK);
        byte[] byArray = new byte[BUFFER_SIZE];
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), byArray.length);
        }
        catch (IOException iOException) {
            DvUtils.writetoTrace("SdffArchiveInputStream.doExtract: " + iOException);
            iOException.printStackTrace();
        }
        try {
            int n;
            while ((n = this.jarIn.read(byArray, 0, byArray.length)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
                sDFFClock.tick();
            }
        }
        catch (IOException iOException) {
            DvUtils.writetoTrace("SdffArchiveInputStream.doExtract: " + iOException);
            iOException.printStackTrace();
        }
        sDFFClock.end();
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.checkExtractedFile(file, l, l2);
    }

    private void checkExtractedFile(File file, long l, long l2) {
        long l3;
        if (this.newSdffFormatVersion == 1) {
            l3 = new FileCRC32(file).getValue();
        } else {
            if (file.length() != l2) {
                DvUtils.writetoTrace("SdffArchiveInputStream.doExtract: Length for " + file.getName() + " is " + file.length() + " but was expected to be " + l2);
                throw new RuntimeException("Truncated SDFF Archive - invalid size for " + file.getName());
            }
            l3 = new FileCRC32(file, Sdff.HOW_MUCH_TO_CHECKSUM).getValue();
        }
        if (l3 != l) {
            DvUtils.writetoTrace("SdffArchiveInputStream.doExtract: Checksum for " + file.getName() + " is calculated as " + l3 + " but was expected to be " + l);
            throw new RuntimeException("Corrupt SDFF Archive - invalid checksum for " + file.getName());
        }
    }

    public void close() {
        try {
            this.jarIn.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setExtractSdffHeaderName(String string) {
        this.extractSdffHeaderName = string;
    }

    public String getExtractSdffHeaderName() {
        return this.extractSdffHeaderName;
    }

    public void setExtractOriginalDumpName(String string) {
        this.extractOriginalDumpName = string;
    }

    public String getExtractOriginalDumpName() {
        return this.extractOriginalDumpName;
    }

    private class SdffArchiveData {
        String contentType;
        long crc;
        long size;

        SdffArchiveData(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            this.contentType = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            this.crc = Long.parseLong(string2);
            if (SdffArchiveInputStream.this.newSdffFormatVersion == 1) {
                this.size = 0L;
            } else {
                String string3 = stringTokenizer.nextToken();
                this.size = Long.parseLong(string3);
            }
        }
    }
}

