/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdffArchive;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.SDFFClock;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdffArchive.SdffArchive;
import com.ibm.jvm.util.FileCRC32;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class SdffArchiveOutputStream {
    private JarOutputStream jarOut;
    static int PUT_BUFFER_SIZE = 32768;
    static int CLOCK_TICK = 10;

    public SdffArchiveOutputStream(String string, File file, File file2) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1");
        attributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, "IBM JTC (Hursley Park, UK)");
        attributes.put(SdffArchive.FORMAT_VERSION, Integer.toString(2));
        attributes.put(SdffArchive.SDFF_HEADER_NAME, file.getName());
        FileCRC32 fileCRC32 = new FileCRC32(file, Sdff.HOW_MUCH_TO_CHECKSUM);
        attributes.put(SdffArchive.SDFF_HEADER_CRC32, Long.toString(fileCRC32.getValue()));
        attributes.put(SdffArchive.ORIGINAL_DUMP_NAME, file2.getName());
        FileCRC32 fileCRC322 = new FileCRC32(file2, Sdff.HOW_MUCH_TO_CHECKSUM);
        attributes.put(SdffArchive.ORIGINAL_DUMP_CRC32, Long.toString(fileCRC322.getValue()));
        this.jarOut = null;
        try {
            this.jarOut = new JarOutputStream((OutputStream)new FileOutputStream(string), manifest);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void putFile(File file, String string) throws IOException {
        this.putFile(file, string, false);
    }

    public void putFile(File file, String string, boolean bl) throws IOException {
        SDFFClock sDFFClock = null;
        if (!file.getName().endsWith("hdr")) {
            sDFFClock = new SDFFClock("Dumping " + file.getName() + " (1 tick = " + PUT_BUFFER_SIZE * CLOCK_TICK + " bytes) ...", CLOCK_TICK);
        } else {
            System.out.println("Dumping " + file.getName());
        }
        String string2 = null;
        String string3 = "";
        if (bl) {
            string2 = file.getAbsolutePath();
        } else {
            string2 = file.getName();
            string3 = "/";
        }
        if (string.equals("Library")) {
            string2 = "libs" + string3 + string2;
        }
        JarEntry jarEntry = new JarEntry(string2);
        jarEntry.setTime(file.lastModified());
        long l = new FileCRC32(file, Sdff.HOW_MUCH_TO_CHECKSUM).getValue();
        String string4 = string + "/" + Long.toString(l) + "/" + Long.toString(file.length());
        jarEntry.setExtra(string4.getBytes());
        DvUtils.writetoTrace("Saving " + file.getName() + " as " + string + " crc " + l + " (0x" + Long.toHexString(l) + ")" + " size " + file.length());
        try {
            this.jarOut.putNextEntry(jarEntry);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = new byte[PUT_BUFFER_SIZE];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), byArray.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            int n;
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                this.jarOut.write(byArray, 0, n);
                if (sDFFClock == null) continue;
                sDFFClock.tick();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (sDFFClock != null) {
            sDFFClock.end();
        }
    }

    public void close() {
        try {
            this.jarOut.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

