/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.DumpClass;
import com.ibm.jvm.findroots.HeapdumpReader;
import com.ibm.jvm.findroots.PortableHeapDumpListener;
import java.io.PrintStream;

public class PrintHeapdump
extends Base {
    boolean hash;
    String[] types = new String[]{"bool", "char", "float", "double", "byte", "short", "int", "long"};
    int objectCount;
    int objectArrayCount;
    int classCount;
    int primitiveArrayCount;
    int totalObjectCount;
    int refCount;
    PrintStream out;

    public static void main(String[] stringArray) {
        new PrintHeapdump(stringArray);
    }

    public PrintHeapdump(String[] stringArray) {
        this.parseOptions(stringArray);
        this.out = System.out;
        this.parse(stringArray[stringArray.length - 1]);
    }

    public PrintHeapdump(String string) {
        this.out = System.out;
        this.parse(string);
    }

    public PrintHeapdump(String string, PrintStream printStream) {
        this.out = printStream;
        this.parse(string);
    }

    int roundup(int n) {
        return n + 8 & 0xFFFFFFF8;
    }

    void printRefs(long[] lArray) {
        this.out.print("\t");
        for (int i = 0; i < lArray.length; ++i) {
            this.out.print("0x" + PrintHeapdump.hex((int)lArray[i]) + " ");
        }
        this.out.println("");
        this.refCount += lArray.length;
    }

    public void parse(String string) {
        HeapdumpReader heapdumpReader = new HeapdumpReader(string);
        this.out.println("// Version: " + heapdumpReader.full_version());
        heapdumpReader.parse(new PortableHeapDumpListener(){

            public void objectDump(long l, long l2, int n, int n2, long[] lArray) {
                DumpClass.foundClass(l2);
            }

            public void objectArrayDump(long l, long l2, int n, int n2, long[] lArray) {
                DumpClass.foundClass(l2);
            }

            public void classDump(long l, long l2, String string, int n, int n2, int n3, long[] lArray) {
                DumpClass.put(l, string, n);
            }

            public void primitiveArrayDump(long l, int n, int n2, int n3, int n4) {
            }
        });
        heapdumpReader = new HeapdumpReader(string);
        heapdumpReader.parse(new PortableHeapDumpListener(){

            public void objectDump(long l, long l2, int n, int n2, long[] lArray) {
                DumpClass dumpClass = DumpClass.get(l2);
                int n3 = dumpClass.instanceSize + 12;
                n3 = PrintHeapdump.this.roundup(n3);
                PrintHeapdump.this.out.println("0x" + Base.hex(l).toUpperCase() + " [" + n3 + "] " + dumpClass.name + (PrintHeapdump.this.hash ? " [hashcode = " + PrintHeapdump.hex(n2) + "]" : ""));
                PrintHeapdump.this.printRefs(lArray);
                ++PrintHeapdump.this.objectCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void objectArrayDump(long l, long l2, int n, int n2, long[] lArray) {
                DumpClass dumpClass = DumpClass.get(l2);
                int n3 = (lArray.length << 2) + 12;
                n3 = PrintHeapdump.this.roundup(n3);
                PrintHeapdump.this.out.println("0x" + Base.hex(l).toUpperCase() + " [" + n3 + "] array of " + dumpClass.name + (PrintHeapdump.this.hash ? " [hashcode = " + PrintHeapdump.hex(n2) + "]" : ""));
                PrintHeapdump.this.printRefs(lArray);
                ++PrintHeapdump.this.objectArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void classDump(long l, long l2, String string, int n, int n2, int n3, long[] lArray) {
                PrintHeapdump.this.out.println("0x" + Base.hex(l).toUpperCase() + " [304] class " + string + (PrintHeapdump.this.hash ? " [hashcode = " + PrintHeapdump.hex(n3) + "]" : ""));
                PrintHeapdump.this.printRefs(lArray);
                ++PrintHeapdump.this.classCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void primitiveArrayDump(long l, int n, int n2, int n3, int n4) {
                int n5 = (n2 << (n & 3)) + 12;
                n5 = PrintHeapdump.this.roundup(n5);
                if (n >= PrintHeapdump.this.types.length) {
                    PrintHeapdump.this.out.println("Warning! bad type " + n + " found in following object");
                    n = 0;
                }
                PrintHeapdump.this.out.println("0x" + Base.hex(l).toUpperCase() + " [" + n5 + "] " + PrintHeapdump.this.types[n] + "[]" + (PrintHeapdump.this.hash ? " [hashcode = " + PrintHeapdump.hex(n4) + "]" : ""));
                ++PrintHeapdump.this.primitiveArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }
        });
        this.out.println("");
        this.out.println("// Breakdown - Classes: " + this.classCount + ", Objects: " + this.objectCount + ", ObjectArrays: " + this.objectArrayCount + ", PrimitiveArrays: " + this.primitiveArrayCount);
        this.out.println("// EOF:  Total 'Objects',Refs(null) : " + this.totalObjectCount + "," + this.refCount + "(0)");
    }

    String[] options() {
        return new String[]{"-hash"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tInclude the hash codes"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-hash".equals(string)) {
            this.hash = true;
            return true;
        }
        return super.parseOption(string, string2);
    }

    String className() {
        return "PrintHeapdump";
    }

    public static String hex(int n) {
        String string = Integer.toHexString(n);
        for (int i = string.length(); i < 8; ++i) {
            string = "0" + string;
        }
        return string;
    }
}

