/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.DllFunction;
import com.ibm.jvm.svcdump.DllVariable;
import com.ibm.jvm.svcdump.Dsa;

public final class Dll {
    AddressSpace space;
    String name;
    int wsa;
    int dlcb;
    DllFunction[] functions;
    DllVariable[] variables;

    public String getName() {
        return this.name;
    }

    public long getWsa() {
        return this.wsa;
    }

    Dll(AddressSpace addressSpace, int n) throws Exception {
        this.space = addressSpace;
        this.dlcb = n;
        int n2 = addressSpace.readUnsignedShort(n + 60);
        int n3 = addressSpace.readInt(n + 64);
        this.name = addressSpace.getString(n3, n2);
        this.wsa = addressSpace.readInt(n + 20);
    }

    DllFunction[] functions() throws Exception {
        int n;
        if (this.functions != null) {
            return this.functions;
        }
        int n2 = this.space.readInt(this.dlcb + 68);
        int n3 = this.space.readInt(n2);
        if (n3 == -909777214) {
            int n4 = this.space.readInt(n2 + 12);
            int n5 = this.space.readInt(n2 + 16);
            this.functions = new DllFunction[n5];
            for (int i = 0; i < n5; ++i) {
                int n6 = this.space.readInt(n4 + 4 + i * 36);
                int n7 = this.space.readInt(n4 + 8 + i * 36);
                String string = this.space.getStringWithLength(n7);
                String string2 = Dsa.program(this.space, n6, true);
                if (string2.length() == 0) {
                    string2 = Dsa.program(this.space, n6, false);
                }
                this.functions[i] = new DllFunction(string, n6, string2);
            }
            return this.functions;
        }
        int n8 = this.space.readInt(n2 + 16);
        int n9 = this.space.readInt(n2 + n8);
        if (n9 < 0) {
            System.out.println("dlcb = " + Dll.hex(this.dlcb));
            System.out.println("dlcbiewbcie = " + Dll.hex(n2));
            System.out.println("offset_expfuncs = " + Dll.hex(n8));
            System.out.println("count = " + Dll.hex(n9));
            System.out.println("wsa = " + Dll.hex(this.wsa));
            System.out.println("name = " + this.name);
            for (n = 0; n < 24; n += 4) {
                System.out.println("dlcbiewbcie + " + n + " = " + Dll.hex(this.space.readInt(n2 + n)));
            }
        }
        this.functions = new DllFunction[n9];
        n = n2 + n8 + 4;
        for (int i = 0; i < n9; ++i) {
            int n10 = this.space.readInt(n);
            int n11 = this.space.readInt(n + 4);
            String string = this.space.getStringWithLength(n2 + n10);
            String string3 = Dsa.program(this.space, n11, true);
            if (string3.length() == 0) {
                string3 = Dsa.program(this.space, n11, false);
            }
            this.functions[i] = new DllFunction(string, n11, string3);
            n += 8;
        }
        return this.functions;
    }

    DllVariable[] variables() throws Exception {
        if (this.variables != null) {
            return this.variables;
        }
        int n = this.space.readInt(this.dlcb + 68);
        int n2 = this.space.readInt(n);
        if (n2 == -909777214) {
            int n3 = this.space.readInt(n + 20);
            int n4 = this.space.readInt(n + 24);
            this.variables = new DllVariable[n4];
            for (int i = 0; i < n4; ++i) {
                short s = this.space.readShort(n3 + 12 + i * 16);
                int n5 = this.space.readInt(n3 + 4 + i * 16);
                int n6 = this.space.readInt(n3 + 8 + i * 16);
                int n7 = s == 0 ? n5 + this.wsa : n5;
                String string = this.space.getStringWithLength(n6);
                int n8 = this.space.readInt(n7);
                this.variables[i] = new DllVariable(string, n7, n8);
            }
            return this.variables;
        }
        int n9 = this.space.readInt(n + 20);
        int n10 = this.space.readInt(n + n9);
        this.variables = new DllVariable[n10];
        int n11 = n + n9 + 4;
        for (int i = 0; i < n10; ++i) {
            int n12 = this.space.readInt(n11);
            int n13 = this.space.readInt(n11 + 4);
            String string = this.space.getStringWithLength(n + n12);
            int n14 = this.space.readInt(this.wsa + n13);
            this.variables[i] = new DllVariable(string, this.wsa + n13, n14);
            n11 += 8;
        }
        return this.variables;
    }

    int getVariableValue(String string) throws Exception {
        for (int i = 0; i < this.variables().length; ++i) {
            DllVariable dllVariable = this.variables()[i];
            if (!dllVariable.name.equals(string)) continue;
            return dllVariable.value;
        }
        throw new Exception("no such variable: " + string);
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

