/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.JavaFrame;
import com.ibm.jvm.svcdump.Jvm;
import java.util.Enumeration;

public class HeapMethod
extends Base {
    Jvm jvm;
    int mb;
    AddressSpace space;
    HeapClass classclass;
    String fullname;
    String fullnameNoSig;
    int native_routine;
    boolean gotAccess;
    int access;
    int mbByteCode;
    int mbByteCodeLength;

    HeapMethod(HeapClass heapClass, int n) {
        this.jvm = heapClass.jvm;
        this.mb = n;
        this.classclass = heapClass;
        this.space = this.jvm.space;
    }

    HeapMethod(Jvm jvm, int n) throws Exception {
        this.space = jvm.space;
        int n2 = this.space.readInt(n);
        this.classclass = jvm.getClass(n2);
        this.jvm = jvm;
        this.mb = n;
    }

    public int mb() {
        return this.mb;
    }

    public String fullname() throws Exception {
        if (this.fullname == null) {
            this.fullname = this.classclass + "." + this;
        }
        return this.fullname;
    }

    String fullnameNoSig() throws Exception {
        if (this.fullnameNoSig == null) {
            this.fullnameNoSig = this.classclass + "." + this.mbName();
        }
        return this.fullnameNoSig;
    }

    String mbName() throws Exception {
        int n = this.space.readInt(this.mb + 8);
        return n == 0 ? "none" : this.space.readString(n);
    }

    String mbSignature() throws Exception {
        int n = this.space.readInt(this.mb + 4);
        return n == 0 ? "none" : this.space.readString(n);
    }

    public String toString() {
        try {
            return this.mbName() + " " + this.mbSignature();
        }
        catch (Exception exception) {
            System.err.println("problem with toString for mb " + HeapMethod.hex(this.mb));
            exception.printStackTrace();
            throw new Error("error getting mbName: " + exception);
        }
    }

    public int mbLocalVariableCount() throws Exception {
        return this.space.readUnsignedShort(this.mb + CType.offsetof("methodblock", "nlocals", -1));
    }

    int native_index() throws Exception {
        return this.space.readUnsignedShort(this.mb + CType.offsetof("methodblock", "native_index", -1));
    }

    int mbByteCode() throws Exception {
        if (this.mbByteCode != 0) {
            return this.mbByteCode;
        }
        int n = CType.offsetof("methodblock", "code", 20);
        this.mbByteCode = this.space.readInt(this.mb + n);
        return this.mbByteCode;
    }

    int mbCode() throws Exception {
        return this.mbByteCode();
    }

    int mbByteCodeLength() throws Exception {
        if (this.mbByteCodeLength != 0) {
            return this.mbByteCodeLength;
        }
        int n = CType.offsetof("methodblock", "code_length", -1);
        this.mbByteCodeLength = this.space.readUnsignedShort(this.mb + n);
        return this.mbByteCodeLength;
    }

    int mbAccess() throws Exception {
        if (this.gotAccess) {
            return this.access;
        }
        int n = CType.offsetof("methodblock", "member", 0);
        int n2 = CType.offsetof("MemberBlock", "access", 12);
        this.access = this.space.readUnsignedShort(this.mb + n + n2);
        this.gotAccess = true;
        return this.access;
    }

    public int mbCompiledCode() throws Exception {
        int n = CType.offsetof("methodblock", "xe", -1);
        int n2 = CType.offsetof("XeMethodData", "jit_data", -1);
        int n3 = CType.offsetof("JitMethodData", "CompiledCode", -1);
        int n4 = this.space.readInt(this.mb + n + n2 + n3);
        return n4;
    }

    public int before_compile() throws Exception {
        int n = CType.offsetof("methodblock", "xe", -1);
        int n2 = CType.offsetof("XeMethodData", "before_compile", -1);
        int n3 = this.space.readUnsignedShort(this.mb + n + n2);
        return n3;
    }

    boolean mbIsNative() throws Exception {
        return (this.mbAccess() & 0x100) != 0;
    }

    boolean mbIsSynchronized() throws Exception {
        return (this.mbAccess() & 0x20) != 0;
    }

    int pc2LineNumber(int n) throws Exception {
        int n2 = n - this.mbByteCode();
        LineNumberEntry[] lineNumberEntryArray = this.mbLineNumberTable();
        if (lineNumberEntryArray.length > 0) {
            int n3 = 0;
            int n4 = lineNumberEntryArray.length;
            if (n2 < lineNumberEntryArray[n3].pc) {
                throw new Exception("pc_offset " + n2 + " smaller than " + lineNumberEntryArray[n3].pc + " pc " + HeapMethod.hex(n));
            }
            if (n2 >= lineNumberEntryArray[n4 - 1].pc) {
                int n5 = lineNumberEntryArray[n4 - 1].line_number;
                return n5;
            }
            while (n3 < n4) {
                int n6 = n3 + n4 >> 1;
                if (n2 < lineNumberEntryArray[n6].pc) {
                    n4 = n6;
                    continue;
                }
                if (n2 >= lineNumberEntryArray[n6 + 1].pc) {
                    n3 = n6;
                    continue;
                }
                int n7 = lineNumberEntryArray[n6].line_number;
                return n7;
            }
            throw new Error("pc_offset " + n2 + " not found in line number table");
        }
        throw new Exception("no line number table found in " + this.fullname());
    }

    LineNumberEntry[] mbLineNumberTable() throws Exception {
        int n = CType.offsetof("methodblock", "line_number_table", 44);
        int n2 = this.space.readInt(this.mb + n);
        int n3 = CType.offsetof("methodblock", "line_number_table_length", 52);
        int n4 = this.space.readInt(this.mb + n3);
        LineNumberEntry[] lineNumberEntryArray = new LineNumberEntry[n4];
        CType cType = CType.find("LineNumberEntry");
        HeapMethod.Assert(cType == null || cType.getSize() == 4);
        for (int i = 0; i < n4; ++i) {
            int n5 = this.space.readUnsignedShort(n2 + (i << 2));
            int n6 = this.space.readUnsignedShort(n2 + (i << 2) + 2);
            lineNumberEntryArray[i] = new LineNumberEntry(n5, n6);
        }
        return lineNumberEntryArray;
    }

    boolean mbIsInJavaMethod(int n) throws Exception {
        return n >= this.mbCode() && n < this.mbCode() + this.mbByteCodeLength();
    }

    boolean mbIsInNativeMethod(int n) throws Exception {
        return this.mbIsNative() && this.mbJNIRoutine() == n;
    }

    int mbJNIRoutine() throws Exception {
        if (this.native_routine != 0) {
            return this.native_routine;
        }
        int n = this.classclass.cbNativeMethodTable();
        int n2 = n + this.native_index() * 8;
        this.native_routine = this.space.readInt(n2 + CType.offsetof("NativeMethodBlock", "native_routine", -1));
        return this.native_routine;
    }

    public static HeapMethod clProgramCounter2Method(Jvm jvm, int n) throws Exception {
        Enumeration enumeration = jvm.getClasses();
        while (enumeration.hasMoreElements()) {
            HeapClass heapClass = (HeapClass)enumeration.nextElement();
            HeapMethod[] heapMethodArray = heapClass.getMethods();
            for (int i = 0; i < heapMethodArray.length; ++i) {
                HeapMethod heapMethod = heapMethodArray[i];
                if (!heapMethod.mbIsInJavaMethod(n) && !heapMethod.mbIsInNativeMethod(n)) continue;
                return heapMethod;
            }
        }
        return JavaFrame.search_committed_code(jvm, n);
    }

    class LineNumberEntry {
        int pc;
        int line_number;

        LineNumberEntry(int n, int n2) {
            this.pc = n;
            this.line_number = n2;
        }
    }
}

