/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.plugins.DvXeCommandsSov;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.svcdump.Tcb;

public class JavaFrame
extends DvJavaFrame {
    Dsa dsa;
    AddressSpace space;
    JavaFrame previous;
    int sf;
    int address;
    int javaf;
    Tcb tcb;
    HeapMethod mb;
    String toString;
    String description;
    int jitPC;

    public JavaFrame(Dsa dsa, int n) throws Exception {
        this.dsa = dsa;
        this.frameType = n;
        this.space = dsa.space;
        this.tcb = dsa.tcb;
        if (this.frameType == 2) {
            int n2;
            int n3 = dsa.getMdata();
            int n4 = dsa.reg(14) & Integer.MAX_VALUE;
            int n5 = this.space.readInt(n3);
            if (n5 != 0 && n5 != -1 && (n2 = this.space.readInt(n3 + 12)) != 0) {
                int n6 = this.space.readInt(n2);
                n2 += 4;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = this.space.readInt(n2);
                    if (n8 == n4) {
                        this.sf = this.space.readInt(n2 + 4);
                        break;
                    }
                    if (n8 > n4) break;
                    ++n7;
                    n2 += 8;
                }
            }
        }
    }

    public JavaFrame(Dsa dsa, int n, int n2) throws Exception {
        this.dsa = dsa;
        this.frameType = n;
        this.sf = n2;
        this.space = dsa.space;
        this.tcb = dsa.tcb;
    }

    public JavaFrame(int n, Tcb tcb) {
        this.address = n;
        this.javaf = n;
        this.tcb = tcb;
        this.space = tcb.space;
        this.frameType = 1;
    }

    public JavaFrame(int n, Tcb tcb, int n2) {
        this.address = n;
        this.tcb = tcb;
        this.jitPC = n2;
        this.space = tcb.space;
        this.frameType = 2;
    }

    public JavaFrame(Tcb tcb) throws Exception {
        this.tcb = tcb;
        this.space = tcb.space;
        switch (tcb.exec_mode()) {
            case 0: {
                this.frameType = 1;
                this.javaf = this.address = tcb.current_frame();
                if (!Dump.debug) break;
                System.out.println("new java JavaFrame, address = " + JavaFrame.hex(this.address));
                break;
            }
            case 1: {
                int n = tcb.last_frame();
                if (Dump.debug) {
                    System.out.println("new jit JavaFrame, jitlf = " + JavaFrame.hex(n));
                }
                if (tcb.IsLJITFSet()) {
                    Dsa dsa = tcb.topJitDsa();
                    this.address = dsa != null ? dsa.address : this.space.readInt(n + 2048);
                } else {
                    throw new Error("jitf undefined!");
                }
                this.jitPC = this.space.readInt(n + 2048 + 12);
                this.javaf = tcb.current_frame();
                this.frameType = 2;
                break;
            }
            case 2: {
                int n = tcb.last_frame();
                if (n == 0) {
                    this.address = this.javaf = tcb.current_frame();
                    if (Dump.debug) {
                        System.out.println("new jit compile JavaFrame, address = " + JavaFrame.hex(this.address));
                    }
                    this.frameType = 1;
                    break;
                }
                this.address = this.space.readInt(n + 2048);
                this.jitPC = this.space.readInt(n + 2048 + 12);
                this.javaf = tcb.current_frame();
                this.frameType = 5;
                if (!Dump.debug) break;
                System.out.println("new jiting JavaFrame, address = " + JavaFrame.hex(this.address));
                break;
            }
            default: {
                throw new Error("unkown exec_mode: " + tcb.exec_mode());
            }
        }
        this.fi_adjust_frame();
    }

    void fi_adjust_frame() throws Exception {
        switch (this.frameType) {
            case 1: {
                int n;
                int n2 = this.profiler_info();
                if (this.current_method() != 0 || (n2 & 3) == 0) break;
                if (this.tcb.IsLJITFSet()) {
                    n = n2 & 0xFFFFFFFC;
                    if (n == 0) break;
                } else {
                    throw new Error("to be completed");
                }
                this.jitPC = this.space.readInt(n + 2048 + 12);
                this.address = this.space.readInt(n + 2048);
                this.frameType = 2;
                this.fi_adjust_frame();
                break;
            }
            case 2: {
                int n;
                if (this.is_invoker_jitf_frompc(this.address, this.jitPC)) {
                    JavaFrame.Assert(this.javaf != 0);
                    int n3 = CType.offsetof("JavaFrame", "prev", -1);
                    this.address = this.javaf = this.space.readInt(this.javaf + n3);
                    this.frameType = 1;
                    this.fi_adjust_frame();
                    break;
                }
                int n4 = this.tcb.GET_MDATA(this.address);
                int n5 = this.space.readInt(n4);
                if (n5 != 0 && n5 != -1 && (n = this.space.readInt(n5 + 20)) != 0) {
                    this.sf = this.tcb.stptbl_lookup(this.address, this.jitPC);
                }
                if (this.sf == 0) break;
                this.frameType = 4;
                break;
            }
            case 4: {
                JavaFrame.Assert(this.sf != 0);
                int n = this.space.readInt(this.sf + 4);
                if (n != 0) break;
                this.frameType = 2;
                this.sf = 0;
                break;
            }
            case 5: {
                if (!this.tcb.EE_JIT_CALLED_FROM_INTERPRETER()) {
                    Dsa dsa;
                    JavaFrame.Assert(this.javaf != 0);
                    int n = CType.offsetof("JavaFrame", "prev", -1);
                    this.javaf = this.space.readInt(this.javaf + n);
                    this.jitPC = 0;
                    this.frameType = 2;
                    if (Dump.debug) {
                        System.out.println("adjust to jit");
                    }
                    if (this.mb141() != null || (dsa = this.tcb.topJitDsa()) == null) break;
                    this.address = dsa.address;
                    break;
                }
                this.address = this.javaf;
                this.jitPC = 0;
                this.frameType = 1;
                if (!Dump.debug) break;
                System.out.println("adjust to java");
                break;
            }
            default: {
                throw new Error("unexpected frame type: " + this.frameType);
            }
        }
    }

    boolean is_invoker_jitf_frompc(int n, int n2) {
        try {
            Dsa dsa = new Dsa(this.tcb, n, true);
            String string = Dsa.function(this.space, dsa.entryPoint());
            if (string.equals("INVFXFER") || string.equals("INVFRMMI")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isPseudo() {
        return false;
    }

    public int profiler_info() throws Exception {
        int n = CType.offsetof("JavaFrame", "profiler_info", -1);
        return this.space.readInt(this.address + n);
    }

    public JavaFrame previous141() throws Exception {
        switch (this.frameType) {
            case 1: {
                int n = CType.offsetof("JavaFrame", "prev", -1);
                int n2 = this.space.readInt(this.address + n);
                this.previous = n2 == 0 ? null : new JavaFrame(n2, this.tcb);
                break;
            }
            case 2: {
                int n = -1;
                int n3 = this.address;
                JavaFrame.Assert(n3 != 0);
                if (this.tcb.IsLJITFSet()) {
                    n = this.tcb.getJitPC(n3);
                }
                if ((n3 = this.tcb.getFirstPrevDSA(n3)) == 0) break;
                this.previous = new JavaFrame(n3, this.tcb, n);
                this.previous.javaf = this.javaf;
                break;
            }
            case 4: {
                int n = this.space.readInt(this.sf + 4);
                this.previous = new JavaFrame(this.address, this.tcb, this.jitPC);
                this.previous.frameType = 4;
                this.previous.sf = n;
                this.previous.javaf = this.javaf;
                break;
            }
            default: {
                throw new Error("unexpected frame type: " + this.frameType);
            }
        }
        if (this.previous != null) {
            this.previous.fi_adjust_frame();
        }
        if (this.previous != null && this.previous.mb() == null) {
            this.previous = this.previous.previous();
        }
        return this.previous;
    }

    public JavaFrame previous() throws Exception {
        JavaFrame.Assert(this.tcb != null);
        if (this.previous != null) {
            return this.previous;
        }
        if (this.tcb.is141) {
            return this.previous141();
        }
        if (this.frameType == 2) {
            Dsa dsa;
            int n = this.sf;
            if (n != 0) {
                n = this.space.readInt(n + 4);
            }
            this.previous = n != 0 ? new JavaFrame(this.dsa, this.frameType, n) : ((dsa = this.dsa.jitFramePrevious()).isJitFrame() ? new JavaFrame(dsa, 2) : new JavaFrame(dsa, 0));
        } else if (this.frameType == 1) {
            JavaFrame.Assert(this.dsa == null);
            int n = CType.offsetof("JavaFrame", "prev", 16);
            int n2 = CType.offsetof("JavaFrame", "profiler_info", 36);
            int n3 = this.space.readInt(this.address + n2);
            int n4 = this.space.readInt(this.address + n);
            if (n4 == 0 || n3 == 0 || (n3 & 0xFFFFFFFC) == n4) {
                if (n4 != 0) {
                    this.previous = new JavaFrame(n4, this.tcb);
                } else if (this.tcb.verbose) {
                    System.out.println("yes! we found last mmi frame!");
                }
            } else {
                int n5 = CType.offsetof("JavaFrame", "returnpc", 4);
                int n6 = this.space.readInt(this.address + n5);
                Dsa dsa = new Dsa(this.tcb, n6);
                if (dsa.isJitFrame()) {
                    if (this.tcb.verbose && n4 != 0) {
                        System.out.println("skipping to jit frame because prev was " + JavaFrame.hex(n4) + " profiler_info is " + JavaFrame.hex(n3));
                    }
                    this.previous = new JavaFrame(dsa, 2);
                } else {
                    this.previous = new JavaFrame(dsa, 0);
                }
            }
        } else {
            Dsa dsa = this.dsa.jitFramePrevious();
            while (true) {
                if (!dsa.isMmiFrame()) {
                    if (dsa.isJitFrame()) {
                        this.previous = new JavaFrame(dsa, 2);
                        break;
                    }
                } else {
                    int n = dsa.prevJavaFrame();
                    if (n != 0) {
                        this.previous = new JavaFrame(n, this.tcb);
                        break;
                    }
                    this.previous = new JavaFrame(dsa, 0);
                    break;
                }
                dsa = dsa.jitFramePrevious();
            }
        }
        if (this.previous == null || this.previous.mb() == null) {
            // empty if block
        }
        return this.previous;
    }

    public int current_method() throws Exception {
        int n = CType.offsetof("JavaFrame", "current_method", 28);
        return this.space.readInt(this.address + n);
    }

    public HeapMethod mb141() throws Exception {
        switch (this.frameType) {
            case 1: {
                int n = this.current_method();
                if (n != 0) {
                    this.mb = new HeapMethod(this.tcb.jvm, n);
                }
                if (!Dump.debug) break;
                System.out.println("java mb141 address = " + (this.mb == null ? "0" : JavaFrame.hex(this.mb.mb)));
                break;
            }
            case 2: {
                int n;
                int n2 = this.tcb.GET_MDATA(this.address);
                if (this.sf != 0) {
                    throw new Error("to be completed");
                }
                int n3 = this.space.readInt(n2);
                if (n3 == -1) {
                    if (!this.tcb.IsLJITFSet()) {
                        throw new Error("to be completed");
                    }
                    n = this.jitPC;
                    n3 = JavaFrame.search_committed_code0(this.space, n & Integer.MAX_VALUE);
                }
                if (n3 != 0) {
                    n = this.space.readInt(n3 + 20);
                    if (n != 0) {
                        this.mb = new HeapMethod(this.tcb.jvm, n);
                    }
                } else if (Dump.debug) {
                    System.out.println("jit mb141 cc = zero");
                }
                if (!Dump.debug) break;
                System.out.println("jit mb141 dsa = " + JavaFrame.hex(this.address) + " address = " + (this.mb == null ? "0" : JavaFrame.hex(this.mb.mb)));
                break;
            }
            case 4: {
                JavaFrame.Assert(this.sf != 0);
                int n = this.space.readInt(this.sf);
                this.mb = new HeapMethod(this.tcb.jvm, n);
                if (!Dump.debug) break;
                System.out.println("inlined mb141 address = " + (this.mb == null ? "0" : JavaFrame.hex(this.mb.mb)));
                break;
            }
            default: {
                throw new Error("unexpected frame type: " + this.frameType);
            }
        }
        return this.mb;
    }

    static int search_committed_code0(AddressSpace addressSpace, int n) throws Exception {
        CTypeObject cTypeObject = DvXeCommandsSov.findAvlTreeRoot(addressSpace, addressSpace.dump);
        CTypeObject cTypeObject2 = DvXeCommandsSov.findJitMethod(cTypeObject, n);
        if (cTypeObject2 != null) {
            return (int)cTypeObject2.getAddr();
        }
        return 0;
    }

    static HeapMethod search_committed_code(Jvm jvm, int n) throws Exception {
        int n2;
        int n3 = JavaFrame.search_committed_code0(jvm.space, n & Integer.MAX_VALUE);
        if (n3 != 0 && (n2 = jvm.space.readInt(n3 + 20)) != 0) {
            return new HeapMethod(jvm, n2);
        }
        return null;
    }

    public HeapMethod mb() throws Exception {
        if (this.mb == null) {
            if (this.tcb.is141) {
                return this.mb141();
            }
            if (this.tcb.verbose) {
                System.out.println("*** try and get mb for address " + JavaFrame.hex(this.address) + " ***");
            }
            if (this.frameType == 2) {
                int n = this.dsa.getMdata();
                int n2 = this.dsa.entryPoint();
                if (n == 0 || n < n2 || n > n2 + 256) {
                    if (this.tcb.verbose) {
                        System.out.println("Warning: couldn't get mb because mdata is out of range");
                    }
                    return null;
                }
                if (this.sf != 0) {
                    int n3 = this.space.readInt(this.sf);
                    this.mb = new HeapMethod(this.tcb.jvm, n3);
                } else {
                    int n4 = this.space.readInt(n);
                    if (n4 == -1) {
                        if (this.tcb.verbose) {
                            System.out.println("Warning: couldn't get mb because mdata is dodgy");
                        }
                        return null;
                    }
                    this.mb = new HeapMethod(this.tcb.jvm, n4);
                }
            } else if (this.frameType == 0) {
                this.mb = this.dsa.mb();
            } else if (this.frameType == 1) {
                int n = this.current_method();
                if (this.tcb.verbose) {
                    System.out.println("JavaFrame.mb() == " + JavaFrame.hex(n) + " frame = " + JavaFrame.hex(this.address));
                }
                if (n != 0) {
                    this.mb = new HeapMethod(this.tcb.jvm, n);
                } else if (this.tcb.verbose) {
                    System.out.println("Contents of frame:");
                    for (int i = 0; i < 12; ++i) {
                        System.out.println(JavaFrame.hex(this.address + (i << 2)) + ": " + JavaFrame.hex(this.space.readInt(this.address + (i << 2))));
                    }
                }
            } else {
                JavaFrame.Assert(false);
            }
        }
        return this.mb;
    }

    String sourceName(HeapClass heapClass) throws Exception {
        String string = heapClass.cbSourceName();
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n);
        }
        return string;
    }

    String sourceName() throws Exception {
        return this.sourceName(this.mb().classclass);
    }

    int lastpc() throws Exception {
        if (this.frameType == 0) {
            return this.dsa.last_pc();
        }
        if (this.frameType == 1) {
            int n = CType.offsetof("JavaFrame", "lastpc", 28);
            int n2 = this.space.readInt(this.address + n);
            return n2;
        }
        throw new Error("uh oh");
    }

    public String description() {
        block10: {
            if (this.description != null) {
                return this.description;
            }
            try {
                if (this.mb() == null) {
                    this.description = "";
                    break block10;
                }
                if (this.mb().mbIsNative()) {
                    this.description = "Native Method";
                    break block10;
                }
                if (this.frameType == 0 || this.frameType == 1) {
                    try {
                        int n = this.mb().mbByteCode();
                        int n2 = this.mb().pc2LineNumber(this.lastpc());
                        this.description = this.sourceName() + ":" + n2;
                    }
                    catch (Exception exception) {
                        this.description = this.sourceName();
                    }
                    break block10;
                }
                if (this.frameType == 2) {
                    this.description = this.sf != 0 && this.space.readInt(this.sf + 4) != 0 ? this.sourceName() + "(Inlined Compiled Code)" : this.sourceName() + "(Compiled Code)";
                    break block10;
                }
                if (this.frameType == 4) {
                    this.description = this.sourceName() + "(Inlined Compiled Code)";
                    break block10;
                }
                throw new Error("unknown frame type: " + this.frameType);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Unexpected exception: " + exception);
            }
        }
        return this.description;
    }

    public byte[] getName() {
        return (this.fullname() + "(" + this.description() + ")").getBytes();
    }

    public String fullname() {
        try {
            if (this.mb() == null) {
                return "empty frame";
            }
            return this.mb().fullnameNoSig();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Unexpected exception: " + exception);
        }
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        try {
            if (this.mb() == null) {
                return "empty frame";
            }
            this.toString = this.mb().fullnameNoSig() + "(" + this.description() + ")";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Unexpected exception: " + exception);
        }
        return this.toString;
    }

    String describe() {
        if (this.tcb.is141) {
            return "141 - to be completed";
        }
        if (this.frameType == 2) {
            return "jit " + this.dsa;
        }
        if (this.frameType == 1) {
            return "mmi at address " + JavaFrame.hex(this.address);
        }
        return "other " + this.dsa;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }
}

