/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.svcdump.AddressSpace;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class Ras
extends DvRas {
    AddressSpace space;
    byte[] ctypedefs;

    public Ras(AddressSpace addressSpace, long l, long l2) {
        this.space = addressSpace;
        this.jvmRas = addressSpace.jvmRasAddress;
        this.hpiRas = addressSpace.hpiRasAddress;
        this.typedefs = l;
        this.typedefsLen = l2;
    }

    public byte[] getCTypedefs() {
        if (this.ctypedefs == null) {
            if (this.typedefsLen < 30000L) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int n;
                    InputStream inputStream = Ras.class.getResourceAsStream("jvmdcf.fix");
                    while ((n = inputStream.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                }
                catch (Exception exception) {
                    throw new Error("bad typedefs length and can't read jvmdcf.fix!");
                }
                this.ctypedefs = byteArrayOutputStream.toByteArray();
            } else {
                this.ctypedefs = new byte[(int)this.typedefsLen];
                try {
                    int n = 0;
                    while ((long)n < this.typedefsLen) {
                        this.ctypedefs[n] = this.space.readByte(this.typedefs + (long)n);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new Error("problem: " + exception);
                }
            }
            new CTypeFile(this.ctypedefs, false);
            if (CType.find("execenv") == null) {
                this.ctypedefs = null;
            }
        }
        return this.ctypedefs;
    }
}

