/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump.examples;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapClass;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapObject;
import com.ibm.jvm.svcdump.Jvm;
import java.util.Enumeration;

public class LoaderCache {
    static final int LOADER_CACHE_TABLE_SIZE = 101;

    public static void main(String[] stringArray) {
        try {
            String string = new String("com/ibm/etools/archive/util/ArchiveFileDynamicClassLoader");
            Dump dump = new Dump(stringArray[0]);
            Jvm jvm = dump.getDefaultJvm();
            AddressSpace addressSpace = dump.getDefaultAddressSpace();
            Heap heap = jvm.getHeap();
            HeapClass heapClass = heap.getClass(string);
            if (heapClass == null) {
                System.out.println("could not find class: " + string);
                System.exit(0);
            }
            HeapField heapField = heapClass.getField("loaderCachePointer");
            int n = CType.offsetof("ClassCacheEntry", "cb", -1);
            int n2 = CType.offsetof("ClassLoaderShadow", "cache", 0);
            int n3 = CType.offsetof("ClassCacheTable", "utf8_bucket", -1);
            int n4 = CType.offsetof("LoaderCacheEntry", "cache", 0);
            int n5 = CType.offsetof("Classjava_lang_Class", "mirrored_data", -1);
            n5 += CType.offsetof("MirroredClassData", "self", -1);
            Enumeration enumeration = heap.getObjects();
            while (enumeration.hasMoreElements()) {
                HeapObject heapObject = (HeapObject)enumeration.nextElement();
                if (!heapObject.getHeapClass().equals(heapClass)) continue;
                System.out.println("found object at " + LoaderCache.hex(heapObject.getAddress()) + " points to " + heapObject.getField(heapField));
                int n6 = (int)heapObject.getLongField(heapField);
                if (n6 == 0) continue;
                int n7 = addressSpace.readInt(n6 + n2 + n3);
                System.out.println(" which points to " + LoaderCache.hex(n3));
                for (int i = 0; i < 101; ++i) {
                    int n8 = addressSpace.readInt(n7 + i * 4);
                    if (n8 == 0) continue;
                    System.out.println("    this then points to " + LoaderCache.hex(n8));
                    int n9 = addressSpace.readInt(n8 + n4 + n);
                    System.out.print("         which then points to " + LoaderCache.hex(n9));
                    int n10 = addressSpace.readInt(n9 + n5 + 8);
                    if (n10 == n9) {
                        System.out.println("");
                        continue;
                    }
                    System.out.println(" is a NOT classblock ");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Oops: " + exception);
            exception.printStackTrace();
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

