/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Column;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Text;

public class Cell
extends Element {
    Element contents;
    Column column;
    boolean isHeader;
    int width = -1;
    boolean usePercent;
    String bgcolor;

    public Cell(Element element) {
        this.contents = element;
    }

    public Cell(Element element, int n, String string) {
        this.contents = element;
        this.width = n;
        this.bgcolor = string;
    }

    public Cell(Element element, int n, boolean bl, String string) {
        this(element, n, string);
        this.usePercent = true;
    }

    public Cell(String string) {
        this.contents = new Text(string);
    }

    public Cell(String string, String string2) {
        this(string);
        this.bgcolor = string2;
    }

    public void setHeader(boolean bl) {
        this.isHeader = bl;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Column column() {
        return this.column;
    }

    public String toString() {
        return this.contents.toString();
    }

    protected String toHtmlString() {
        char c = this.isHeader ? (char)'h' : 'd';
        String string = "<t" + c;
        if (this.width != -1) {
            string = string + " width=\"" + this.width;
            if (this.usePercent) {
                string = string + "%";
            }
            string = string + "\"";
        }
        if (this.bgcolor != null) {
            string = string + " bgcolor=\"" + this.bgcolor + "\"";
        }
        string = string + ">";
        string = this.beautify(string);
        String string2 = this.contents.toHtmlString();
        if (string2.length() == 0) {
            string2 = "&nbsp;";
        }
        return this.beautify(string + string2 + "</t" + c + ">");
    }

    protected String toTextString() {
        return this.contents.toTextString();
    }

    public int width() {
        return this.toTextString().length();
    }
}

