/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.PortletContainer;
import com.ibm.ws.portletcontainer.PortletContainerInvokerCollaboratorChainImpl;
import com.ibm.ws.portletcontainer.PortletContainerServices;
import com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry;
import com.ibm.ws.portletcontainer.core.InternalActionResponse;
import com.ibm.ws.portletcontainer.factory.PortletObjectAccess;
import com.ibm.ws.portletcontainer.invoker.PortletInvoker;
import com.ibm.ws.portletcontainer.invoker.PortletInvokerAccess;
import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.service.information.InformationProviderAccess;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaboratorChain;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import com.ibm.wsspi.portletcontainer.services.information.PortletActionProvider;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletContainerImpl
implements PortletContainer {
    private static final String CLASS_NAME = PortletContainerImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public void renderPortlet(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext) throws PortletException, IOException, PortletContainerException {
        List list;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "renderPortlet", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext});
        }
        if ((list = CollaboratorRegistry.getInstance().getPortletContainerInvokerCollaborators()).size() == 0) {
            this.doRender(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, null);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "renderPortlet", "Calling collaborators. Count: " + list.size());
            }
            Iterator iterator = list.iterator();
            PortletContainerInvokerCollaboratorChainImpl portletContainerInvokerCollaboratorChainImpl = new PortletContainerInvokerCollaboratorChainImpl(false, this, iterator);
            portletContainerInvokerCollaboratorChainImpl.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
        }
        logger.exiting(CLASS_NAME, "renderPortlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRender(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "doRender", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext});
        }
        PortletContainerServices.prepare(portletContainerContext);
        try {
            PortletWindow portletWindow = this.getPortletWindow(portletWindowIdentifier);
            PortletDefinition portletDefinition = portletWindow.getPortletDefinition();
            RenderRequest renderRequest = PortletObjectAccess.getRenderRequest(portletWindow, httpServletRequest, httpServletResponse);
            RenderResponse renderResponse = PortletObjectAccess.getRenderResponse(portletWindow, httpServletRequest, httpServletResponse);
            PortletInvoker portletInvoker = PortletInvokerAccess.getPortletInvoker(portletDefinition);
            portletInvoker.render(renderRequest, renderResponse);
        }
        finally {
            PortletContainerServices.release();
        }
        logger.exiting(CLASS_NAME, "doRender");
    }

    public void processPortletAction(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext) throws PortletException, IOException, PortletContainerException {
        List list;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "processPortletAction", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext});
        }
        if ((list = CollaboratorRegistry.getInstance().getPortletContainerInvokerCollaborators()).size() == 0) {
            this.doAction(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, null);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "processPortletAction", "Calling collaborators. Count: " + list.size());
            }
            Iterator iterator = list.iterator();
            PortletContainerInvokerCollaboratorChainImpl portletContainerInvokerCollaboratorChainImpl = new PortletContainerInvokerCollaboratorChainImpl(true, this, iterator);
            portletContainerInvokerCollaboratorChainImpl.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
        }
        logger.exiting(CLASS_NAME, "processPortletAction");
    }

    void doAction(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "doAction", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext});
        }
        PortletContainerServices.prepare(portletContainerContext);
        String string = null;
        InternalActionResponse internalActionResponse = null;
        ActionRequest actionRequest = null;
        PortletWindow portletWindow = this.getPortletWindow(portletWindowIdentifier);
        PortletDefinition portletDefinition = portletWindow.getPortletDefinition();
        InformationProvider informationProvider = InformationProviderAccess.getProvider();
        try {
            actionRequest = PortletObjectAccess.getActionRequest(portletWindow, httpServletRequest, httpServletResponse);
            ActionResponse actionResponse = PortletObjectAccess.getActionResponse(portletWindow, httpServletRequest, httpServletResponse);
            PortletInvoker portletInvoker = PortletInvokerAccess.getPortletInvoker(portletDefinition);
            internalActionResponse = (InternalActionResponse)((Object)actionResponse);
            portletInvoker.action(actionRequest, actionResponse);
            string = internalActionResponse.getRedirectLocation();
            PortletActionProvider portletActionProvider = informationProvider.getPortletActionProvider(portletWindowIdentifier);
            if (string != null) {
                portletActionProvider.setRedirectURL(string);
            } else {
                if (internalActionResponse.getChangedPortletMode() != null) {
                    portletActionProvider.setPortletMode(internalActionResponse.getChangedPortletMode());
                }
                if (internalActionResponse.getChangedWindowState() != null) {
                    portletActionProvider.setPortletWindowState(internalActionResponse.getChangedWindowState());
                }
                portletActionProvider.setRenderParameters(internalActionResponse.getRenderParameters());
            }
        }
        catch (PortletException portletException) {
            FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.PortletContainerImpl.processPortletAction", (String)"97", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "doAction", "process.portlet.action.error.0", portletException);
            throw portletException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.PortletContainerImpl.processPortletAction", (String)"101", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "doAction", "process.portlet.action.error.0", iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.portletcontainer.PortletContainerImpl.processPortletAction", (String)"105", (Object)this);
            logger.logp(Level.SEVERE, CLASS_NAME, "doAction", "process.portlet.action.error.0", runtimeException);
            throw runtimeException;
        }
        finally {
            PortletContainerServices.release();
        }
        logger.exiting(CLASS_NAME, "doAction");
    }

    private PortletWindow getPortletWindow(PortletWindowIdentifier portletWindowIdentifier) throws InvalidPortletWindowIdentifierException {
        return OMAccess.createPortletWindow(portletWindowIdentifier);
    }
}

