/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer;

import com.ibm.ws.portletcontainer.PortletContainerImpl;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaboratorChain;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletContainerInvokerCollaboratorChainImpl
implements PortletContainerInvokerCollaboratorChain {
    private static final String CLASS_NAME = PortletContainerInvokerCollaboratorChainImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private boolean action;
    private PortletContainerImpl container;
    private Iterator iter;

    PortletContainerInvokerCollaboratorChainImpl(boolean bl, PortletContainerImpl portletContainerImpl, Iterator iterator) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "PortletContainerInvokerCollaboratorChainImpl", new Object[]{bl, portletContainerImpl});
        }
        this.action = bl;
        this.container = portletContainerImpl;
        this.iter = iterator;
        logger.exiting(CLASS_NAME, "PortletContainerInvokerCollaboratorChainImpl");
    }

    public void doCollaborator(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext) throws PortletException, IOException, PortletContainerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doCollaborator", new Object[]{portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext});
        }
        if (this.iter.hasNext()) {
            PortletContainerInvokerCollaborator portletContainerInvokerCollaborator = (PortletContainerInvokerCollaborator)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Calling doDispatch of collaborator: " + portletContainerInvokerCollaborator);
            }
            if (this.action) {
                portletContainerInvokerCollaborator.doAction(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, this);
            } else {
                portletContainerInvokerCollaborator.doRender(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, this);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Last collaborator called. Proceeding with normal execution.");
            }
            if (this.action) {
                this.container.doAction(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, this);
            } else {
                this.container.doRender(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext, this);
            }
        }
        logger.exiting(CLASS_NAME, "doCollaborator");
    }
}

