/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer;

import com.ibm.wsspi.portletcontainer.services.ContainerService;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletContainerServices {
    private static final String CLASS_NAME = PortletContainerServices.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static ThreadLocal currentContainerService = new StackedThreadLocale();

    public static ContainerService get(Class clazz) {
        Stack stack = (Stack)currentContainerService.get();
        if (stack.isEmpty()) {
            logger.logp(Level.SEVERE, CLASS_NAME, "get", "portlet.container.context.error.0");
            throw new IllegalStateException("The prepare method was never called");
        }
        PortletContainerContext portletContainerContext = (PortletContainerContext)stack.peek();
        if (portletContainerContext == null) {
            logger.logp(Level.SEVERE, CLASS_NAME, "get", "portlet.container.context.error.0");
            throw new IllegalStateException("The prepare method was never called");
        }
        return portletContainerContext.getContainerService(clazz);
    }

    public static void prepare(PortletContainerContext portletContainerContext) {
        logger.entering(CLASS_NAME, "prepare", portletContainerContext);
        Stack stack = (Stack)currentContainerService.get();
        stack.push(portletContainerContext);
        logger.exiting(CLASS_NAME, "prepare");
    }

    public static void release() {
        Stack stack = (Stack)currentContainerService.get();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    private static class StackedThreadLocale
    extends ThreadLocal {
        private StackedThreadLocale() {
        }

        public Object initialValue() {
            return new Stack();
        }
    }
}

