/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AggregationLibValidator
extends TagLibraryValidator {
    private static final String CLASS_NAME = AggregationLibValidator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private ResourceBundle bundle = logger.getResourceBundle();
    private final String INIT = "init";
    private final String STATE = "state";
    private final String URLPARAM = "urlParam";
    private final String INSERT = "insert";
    private final String JSP_TEXT = "jsp:text";
    protected static final int TYPE_PORTLET = 3;
    protected static final String VAR = "var";
    protected static final String SCOPE = "scope";
    protected String uri;
    protected String prefix;
    protected Vector messageVector;
    protected Map config;
    protected boolean failed;
    protected String lastElementId;
    private boolean enabled = true;

    public AggregationLibValidator() {
        this.init();
    }

    private void init() {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setInitParameters(Map map) {
        Boolean bl = new Boolean((String)map.get("enabled"));
        this.setEnabled(bl);
    }

    public void release() {
        super.release();
        this.init();
    }

    static ValidationMessage[] validationMessageFromString(String string) {
        return new ValidationMessage[]{new ValidationMessage(null, string)};
    }

    static ValidationMessage[] validationMessageFromVector(Vector vector) {
        ValidationMessage[] validationMessageArray = new ValidationMessage[vector.size()];
        for (int i = 0; i < validationMessageArray.length; ++i) {
            validationMessageArray[i] = (ValidationMessage)vector.get(i);
        }
        return validationMessageArray;
    }

    protected boolean isTag(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return false;
        }
        if (string.length() > string3.length()) {
            return string.startsWith(string3) && string2.equals(string4);
        }
        return string3.startsWith(string) && string2.equals(string4);
    }

    private boolean isTag(int n, String string, String string2, String string3) {
        return 3 == n && this.isTag(string, string2, this.uri, string3);
    }

    protected boolean isPortletTag(String string, String string2, String string3) {
        return this.isTag(3, string, string2, string3);
    }

    protected void fail(String string, String string2) {
        this.failed = true;
        this.messageVector.add(new ValidationMessage(string2, string));
    }

    protected String getLocalPart(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public synchronized ValidationMessage[] validate(String string, String string2, PageData pageData) {
        if (this.enabled) {
            try {
                this.uri = string2;
                this.messageVector = new Vector();
                this.prefix = string;
                Handler handler = new Handler();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(pageData.getInputStream(), (DefaultHandler)handler);
                if (this.messageVector.size() == 0) {
                    return null;
                }
                return AggregationLibValidator.validationMessageFromVector(this.messageVector);
            }
            catch (SAXException sAXException) {
                return AggregationLibValidator.validationMessageFromString(sAXException.toString());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return AggregationLibValidator.validationMessageFromString(parserConfigurationException.toString());
            }
            catch (IOException iOException) {
                return AggregationLibValidator.validationMessageFromString(iOException.toString());
            }
        }
        return null;
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack initTagDepths = new Stack();
        private int initTagCount = 0;
        private Stack stateTagDepths = new Stack();
        private Stack urlParamTagDepths = new Stack();
        private Stack insertDepths = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            if (string2 == null) {
                string2 = AggregationLibValidator.this.getLocalPart(string3);
            }
            if (string3.equals("jsp:text")) {
                return;
            }
            if (this.bodyIllegal) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.illegal") + " " + string3, string4);
            }
            if ((AggregationLibValidator.this.isPortletTag(string, string2, "insert") || AggregationLibValidator.this.isPortletTag(string, string2, "state")) && this.initTagDepths.empty() && this.stateTagDepths.empty()) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.init.tag") + " " + string3, string4);
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "urlParam") && this.stateTagDepths.empty()) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.state.tag") + " " + string3, string4);
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "init")) {
                this.initTagDepths.push(new Integer(this.depth));
                ++this.initTagCount;
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "init") && this.initTagCount > 1) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.one.init.tag.allowed") + " " + string3, string4);
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "insert")) {
                this.insertDepths.push(new Integer(this.depth));
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "state")) {
                this.stateTagDepths.push(new Integer(this.depth));
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "urlParam")) {
                this.urlParamTagDepths.push(new Integer(this.depth));
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (AggregationLibValidator.this.isPortletTag(string, string2, "init")) {
                this.bodyNecessary = true;
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "insert") || AggregationLibValidator.this.isPortletTag(string, string2, "urlParam")) {
                this.bodyIllegal = true;
            }
            this.lastElementName = string3;
            AggregationLibValidator.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        public void characters(char[] cArray, int n, int n2) {
            this.bodyNecessary = false;
            String string = new String(cArray, n, n2).trim();
            if (string.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.illegal") + " " + this.lastElementName, AggregationLibValidator.this.lastElementId);
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("jsp:text")) {
                return;
            }
            if (this.bodyNecessary) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.mandatory") + " " + this.lastElementName, AggregationLibValidator.this.lastElementId);
            }
            this.bodyIllegal = false;
            if (AggregationLibValidator.this.isPortletTag(string, string2, "init")) {
                this.initTagDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "insert")) {
                this.insertDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "state")) {
                this.stateTagDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(string, string2, "urlParam")) {
                this.urlParamTagDepths.pop();
            }
            --this.depth;
        }
    }
}

