/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InsertRespWrapper;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import com.ibm.wsspi.portletcontainer.util.FilterRequestHelper;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class InitTag
extends TagSupport {
    private static final long serialVersionUID = 7824534969503650886L;
    private static final String CLASS_NAME = InitTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private String portletURLPrefix;
    private String portletURLSuffix;
    private String portletURLQueryParams;
    private String context;
    private String portletName;
    private String windowId;
    private String requestURI;
    private String modeValue;
    private String stateValue;
    private String targetUrlWithoutContext;
    private boolean isAction;
    private Map rparams;

    public InitTag() {
        this.init();
    }

    private void init() {
        this.portletURLQueryParams = null;
        this.portletURLSuffix = null;
        this.portletURLPrefix = null;
        this.initUrlVars();
    }

    private void initUrlVars() {
        this.targetUrlWithoutContext = null;
        this.stateValue = null;
        this.modeValue = null;
        this.requestURI = null;
        this.windowId = null;
        this.portletName = null;
        this.context = null;
        this.rparams = null;
        this.isAction = false;
    }

    public int doStartTag() throws JspException {
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException("Non-HTTP request not allowed.");
        }
        if (this.pageContext.getSession() == null) {
            throw new JspTagException("No session found. Aggregation Tag Library requires a session.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "Enter InitTag.doStartTag()");
        }
        this.pageContext.getRequest().setAttribute("com.ibm.ws.portletcontainer.aggregation_taglib", (Object)Boolean.TRUE);
        this.getUrlParts();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "isAction: [" + this.isAction + "]");
        }
        if (this.isAction) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "inside isAction block...");
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "context: [" + this.context + "] portletName: [" + this.portletName + "]");
            }
            if (this.context != null && this.portletName != null) {
                InsertRespWrapper insertRespWrapper = null;
                try {
                    FilterRequestHelper.setRedirect(this.pageContext.getRequest());
                    insertRespWrapper = new InsertRespWrapper((HttpServletResponse)this.pageContext.getResponse());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "about to call getResponseAsString");
                    }
                    if (!this.context.startsWith("/")) {
                        this.context = "/" + this.context;
                    }
                    Utils.getResponseAsString(this.pageContext, this.context, this.targetUrlWithoutContext, this.portletURLPrefix, this.portletURLSuffix, this.portletURLQueryParams, this.windowId, this.windowId, insertRespWrapper);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.doStartTag", (String)"72", (Object)((Object)this));
                    throw new JspTagException(iOException.toString(), (Throwable)iOException);
                }
                if (insertRespWrapper != null) {
                    HttpServletResponse httpServletResponse = (HttpServletResponse)insertRespWrapper.getResponse();
                    Map map = insertRespWrapper.getCookies();
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        Cookie cookie = (Cookie)iterator.next();
                        httpServletResponse.addCookie(cookie);
                    }
                    try {
                        httpServletResponse.sendRedirect(insertRespWrapper.getLocation());
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.doStartTag", (String)"89", (Object)((Object)this));
                        throw new JspTagException(iOException.toString(), (Throwable)iOException);
                    }
                }
                return 0;
            }
        }
        return 1;
    }

    private void getUrlParts() throws JspTagException {
        int n;
        String string;
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException("non-HTTP request not allowed.");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "Enter InitTag.getUrlParts()  req: [" + httpServletRequest + "]");
        }
        if ((string = (String)httpServletRequest.getAttribute("javax.servlet.forward.path_info")) != null && string.length() > 1) {
            this.requestURI = string;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "request was forwarded.");
            }
            this.logURLReqInfo(httpServletRequest, true);
        } else {
            this.requestURI = httpServletRequest.getPathInfo();
            this.logURLReqInfo(httpServletRequest, false);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "requestURI: [" + this.requestURI + "]");
        }
        if (this.requestURI != null && this.portletURLSuffix != null && (n = this.requestURI.indexOf(this.portletURLSuffix)) > 0) {
            this.requestURI = this.requestURI.substring(0, n);
        }
        try {
            if (this.requestURI != null && this.requestURI.length() > 1) {
                Object object;
                PortletURLHelper portletURLHelper = null;
                this.context = null;
                this.portletName = null;
                if (httpServletRequest.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope") != null) {
                    Object object2;
                    object = (Map)httpServletRequest.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope");
                    Set set = object.keySet();
                    Object object3 = null;
                    int n2 = -1;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        if (!this.requestURI.startsWith((String)object2) || n2 >= ((String)object2).length()) continue;
                        object3 = object2;
                        n2 = ((String)object2).length();
                    }
                    object2 = (Map)object.get(object3);
                    if (object2 != null) {
                        this.context = (String)object2.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.context");
                        this.portletName = (String)object2.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.portletname");
                        this.targetUrlWithoutContext = this.requestURI.substring(this.context.length());
                        portletURLHelper = new PortletURLHelper(this.context, this.portletName, this.requestURI.substring(((String)object3).length()));
                    } else {
                        portletURLHelper = new PortletURLHelper(this.requestURI);
                    }
                } else {
                    portletURLHelper = new PortletURLHelper(this.requestURI);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "portletURLHelper: [" + portletURLHelper + "]");
                }
                if (this.context == null) {
                    this.context = portletURLHelper.getContext();
                }
                if (this.portletName == null) {
                    this.portletName = portletURLHelper.getPortletName();
                }
                if (this.targetUrlWithoutContext == null) {
                    this.targetUrlWithoutContext = this.requestURI;
                    if (this.targetUrlWithoutContext.startsWith("/")) {
                        this.targetUrlWithoutContext = this.targetUrlWithoutContext.substring(1);
                    }
                    this.targetUrlWithoutContext = this.targetUrlWithoutContext.substring(this.targetUrlWithoutContext.indexOf(47));
                }
                this.windowId = portletURLHelper.getPortletWindowId();
                this.rparams = portletURLHelper.getRenderParameters();
                this.modeValue = portletURLHelper.getPortletMode();
                this.stateValue = portletURLHelper.getWindowState();
                this.isAction = portletURLHelper.isAction();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "context: [" + this.context + "] portletName: [" + this.portletName + "] windowId: [" + this.windowId + "] targetUrlWithoutContext: [" + this.targetUrlWithoutContext + "] rparams: [" + this.rparams + "] modeValue: [" + this.modeValue + "] stateValue: [" + this.stateValue + "] isAction: [" + this.isAction + "] ");
                }
                object = PortletStateHashtable.createKey(this.context, this.portletName, this.windowId);
                this.pageContext.getSession().removeAttribute((String)object);
                this.pageContext.getSession().setAttribute((String)object, (Object)PortletStateHashtable.createStateHashtable(this.modeValue, this.stateValue, this.rparams));
            }
        }
        catch (InvalidURLException invalidURLException) {
            FFDCFilter.processException((Throwable)((Object)invalidURLException), (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.getUrlParts", (String)"137", (Object)((Object)this));
            invalidURLException.printStackTrace();
        }
    }

    private void logURLReqInfo(HttpServletRequest httpServletRequest, boolean bl) {
        if (logger.isLoggable(Level.FINE)) {
            if (!bl) {
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getScheme(): [" + httpServletRequest.getScheme() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServerName(): [" + httpServletRequest.getServerName() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServerPort(): [" + httpServletRequest.getServerPort() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getContextPath(): [" + httpServletRequest.getContextPath() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServletPath(): [" + httpServletRequest.getServletPath() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getPathInfo(): [" + httpServletRequest.getPathInfo() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getQueryString(): [" + httpServletRequest.getQueryString() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getRequestURI()(): [" + httpServletRequest.getRequestURI() + "]");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.servlet_path: [" + httpServletRequest.getAttribute("javax.servlet.forward.servlet_path") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.request_uri: [" + httpServletRequest.getAttribute("javax.servlet.forward.request_uri") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.context_path: [" + httpServletRequest.getAttribute("javax.servlet.forward.context_path") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.path_info: [" + httpServletRequest.getAttribute("javax.servlet.forward.path_info") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.query_string: [" + httpServletRequest.getAttribute("javax.servlet.forward.query_string") + "]");
            }
        }
    }

    public int doEndTag() throws JspException {
        this.init();
        return 6;
    }

    public void release() {
        this.init();
    }

    public void setPortletURLPrefix(String string) {
        this.portletURLPrefix = string;
    }

    public void setPortletURLSuffix(String string) {
        this.portletURLSuffix = string;
    }

    public void setPortletURLQueryParams(String string) {
        this.portletURLQueryParams = string;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = null;
        string2 = string + "portletURLPrefix =                [" + this.portletURLPrefix + "]" + string + "portletURLSuffix =                [" + this.portletURLSuffix + "]" + string + "portletURLQueryParams=            [" + this.portletURLQueryParams + "]";
        return string2;
    }

    protected String getPortletURLPrefix() {
        return this.portletURLPrefix;
    }

    protected String getPortletURLQueryParams() {
        return this.portletURLQueryParams;
    }

    protected String getPortletURLSuffix() {
        return this.portletURLSuffix;
    }

    protected String getWindowState() {
        return this.stateValue;
    }

    protected String getPortletMode() {
        return this.modeValue;
    }

    protected String getTargetWindowId() {
        return this.windowId;
    }
}

