/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InitTag;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class InsertTag
extends TagSupport {
    private static final long serialVersionUID = -7677661301921728389L;
    private static final String CLASS_NAME = InsertTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private ResourceBundle bundle = logger.getResourceBundle();
    private String url;
    private String windowId;
    private String targetWindowId;
    private String targetUrl;
    private String targetUrlWithoutContext;
    private String contentVar;
    private String contentScope;
    private String titleVar;
    private String titleScope;
    private InitTag parent;
    private Map scopeValues;
    private String context;

    public InsertTag() {
        this.init();
    }

    private void init() {
        this.titleScope = null;
        this.titleVar = null;
        this.contentScope = null;
        this.contentVar = null;
        this.targetUrlWithoutContext = null;
        this.targetUrl = null;
        this.windowId = null;
        this.context = null;
        this.url = null;
        this.parent = null;
    }

    public void release() {
        this.init();
    }

    public int doStartTag() throws JspException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "Enter InsertTag.doStartTag()");
        }
        this.parent = (InitTag)InsertTag.findAncestorWithClass((Tag)this, (Class)InitTag.class);
        if (this.parent == null) {
            throw new JspTagException(this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.init.tag"));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "parent: [" + (Object)((Object)this.parent) + "]");
        }
        this.scopeValues = Utils.getScopeValues(this.pageContext.getRequest(), this.url);
        if (this.scopeValues != null) {
            this.context = (String)this.scopeValues.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.context");
        }
        if (this.context == null) {
            this.context = this.url.substring(0, this.url.indexOf("/"));
        }
        String string = PortletStateHashtable.createKey(this.url, this.windowId);
        Hashtable hashtable = (Hashtable)this.pageContext.getSession().getAttribute(string);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "key: [" + string + "]");
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "stateHashtable: [" + hashtable + "]");
        }
        String string2 = null;
        String string3 = null;
        Hashtable hashtable2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get(Utils.modeSuffix);
            string3 = (String)hashtable.get(Utils.stateSuffix);
            hashtable2 = (Hashtable)hashtable.get(Utils.rparamSuffix);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "modeValue: [" + string2 + "] stateValue: [" + string3 + "] rparams: [" + hashtable2 + "]");
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "about to call Utils.assembleURL...");
        }
        this.targetUrl = Utils.assembleURL(null, this.url, this.windowId, false, string2, string3, hashtable2, null, null);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "back from Utils.assembleURL, targetUrl: [" + this.targetUrl + "]");
        }
        this.getUrlParts();
        this.targetWindowId = this.parent.getTargetWindowId();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "targetWindowId: [" + this.targetWindowId + "]");
        }
        return 0;
    }

    private void getUrlParts() {
        this.targetUrlWithoutContext = this.targetUrl.substring(this.context.length());
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "targetUrlContext [" + this.context + "], targetUrlWithoutContext [" + this.targetUrlWithoutContext + "]");
        }
    }

    public int doEndTag() throws JspException {
        try {
            String string;
            String string2 = Utils.getResponseAsString(this.pageContext, this.context, this.targetUrlWithoutContext, this.parent.getPortletURLPrefix(), this.parent.getPortletURLSuffix(), this.parent.getPortletURLQueryParams(), this.targetWindowId, this.windowId);
            if (this.contentVar != null) {
                this.pageContext.setAttribute(this.contentVar, (Object)string2, Utils.getScope(this.contentScope));
            } else {
                this.pageContext.getOut().print(string2);
            }
            if (this.titleVar != null && (string = (String)this.pageContext.getAttribute("javax.portlet.title", 2)) != null) {
                this.pageContext.setAttribute(this.titleVar, (Object)string, Utils.getScope(this.titleScope));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InsertTag.doEndTag", (String)"99", (Object)((Object)this));
            this.init();
            throw new JspTagException(iOException.toString(), (Throwable)iOException);
        }
        this.init();
        return 6;
    }

    public void setUrl(String string) {
        this.url = string;
        if (this.url != null && this.url.startsWith("/")) {
            this.url = this.url.substring(1);
        }
    }

    public void setWindowId(String string) {
        this.windowId = string;
    }

    public void setContentVar(String string) {
        this.contentVar = string;
    }

    public void setContentScope(String string) {
        this.contentScope = string;
    }

    public void setTitleVar(String string) {
        this.titleVar = string;
    }

    public void setTitleScope(String string) {
        this.titleScope = string;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = null;
        string2 = string + "url =                [" + this.url + "]" + string + "context =            [" + this.context + "]" + string + "windowId =           [" + this.windowId + "]" + string + "contentVar =         [" + this.contentVar + "]" + string + "contentScope =       [" + this.contentScope + "]" + string + "titleVar =           [" + this.titleVar + "]" + string + "titleScope =         [" + this.titleScope + "]";
        return string2;
    }
}

