/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.ws.portletcontainer.cache.CacheHelper;
import com.ibm.ws.portletcontainer.cache.response.CacheHttpServletResponseWrapper;
import com.ibm.ws.portletcontainer.ext.ExtInformationProviderWrapper;
import com.ibm.wsspi.portletcontainer.collaborator.PortletServletCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletServletCollaboratorChain;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheCollaborator
implements PortletServletCollaborator {
    private static final String CLASS_NAME = CacheCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletServletCollaboratorChain portletServletCollaboratorChain) throws ServletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doDispatch", new Object[]{httpServletRequest, httpServletResponse, portletServletCollaboratorChain});
        }
        if (CacheHelper.isPortletCacheable(httpServletRequest)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doDispatch", "Portlet caching enabled.");
            }
            ExtInformationProviderWrapper.getExtProvider().activateCaching(CacheHelper.getServletCacheResponse(httpServletResponse));
            try {
                portletServletCollaboratorChain.doCollaborator(httpServletRequest, httpServletResponse);
            }
            finally {
                ExtInformationProviderWrapper.getExtProvider().activateCaching(null);
                CacheHelper.createCacheInformation(httpServletRequest);
            }
        } else {
            CacheHttpServletResponseWrapper.disableCacheResponseWrapper(httpServletResponse);
            portletServletCollaboratorChain.doCollaborator(httpServletRequest, httpServletResponse);
        }
        logger.exiting(CLASS_NAME, "doDispatch");
    }

    public void doAction(ActionRequest actionRequest, ActionResponse actionResponse, PortletServletCollaboratorChain portletServletCollaboratorChain) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doAction", new Object[]{actionRequest, actionResponse, portletServletCollaboratorChain});
        }
        portletServletCollaboratorChain.doCollaborator(actionRequest, actionResponse);
        logger.exiting(CLASS_NAME, "doAction");
    }

    public void doRender(RenderRequest renderRequest, RenderResponse renderResponse, PortletServletCollaboratorChain portletServletCollaboratorChain) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doRender", new Object[]{renderRequest, renderResponse, portletServletCollaboratorChain});
        }
        portletServletCollaboratorChain.doCollaborator(renderRequest, renderResponse);
        logger.exiting(CLASS_NAME, "doRender");
    }

    public void doInit(PortletConfig portletConfig, PortletServletCollaboratorChain portletServletCollaboratorChain) throws PortletException {
        portletServletCollaboratorChain.doCollaborator(portletConfig);
    }
}

