/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.ext.ExtInformationProviderWrapper;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class CacheDynamicContentProvider
implements DynamicContentProvider {
    private static final String CLASS_NAME = CacheDynamicContentProvider.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private Map parameters;

    public CacheDynamicContentProvider(Map map) {
        this.parameters = map;
    }

    public void provideDynamicContent(HttpServletRequest httpServletRequest, OutputStream outputStream) throws IOException {
    }

    public void provideDynamicContent(HttpServletRequest httpServletRequest, Writer writer) throws IOException {
        this.rewriteURL(httpServletRequest, this.parameters, writer);
    }

    public void rewriteURL(HttpServletRequest httpServletRequest, Map map, Writer writer) throws IOException {
        RenderRequest renderRequest = (RenderRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletWindow portletWindow = CoreUtils.getInternalRequest(renderRequest).getPortletWindow();
        this.rewriteURL(httpServletRequest, portletWindow, map, writer);
    }

    public void rewriteURL(HttpServletRequest httpServletRequest, PortletWindow portletWindow, Map map, Writer writer) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "rewriteURL", new Object[]{httpServletRequest, portletWindow, map, writer});
        }
        boolean bl = logger.isLoggable(Level.FINEST);
        PortletURLProvider portletURLProvider = CacheDynamicContentProvider._getPortletURLProvider(portletWindow);
        String[] stringArray = (String[])map.get("_pStateArray");
        map.remove("_pStateArray");
        WindowState windowState = null;
        PortletMode portletMode = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray != null) {
            if (!"null".equals(stringArray[0])) {
                windowState = PortletURLHelper.getWindowState(stringArray[0]);
            }
            if (!"null".equals(stringArray[1])) {
                portletMode = PortletURLHelper.getPortletMode(stringArray[1]);
            }
            bl2 = "true".equals(stringArray[2]);
            bl3 = "true".equals(stringArray[3]);
        } else {
            logger.logp(Level.FINE, CLASS_NAME, "rewriteURL", "No state information found: URL token has been corrupted");
        }
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "rewriteURL", "state: " + windowState + ", " + portletMode + ", " + bl2 + ", " + bl3);
        }
        if (windowState != null) {
            portletURLProvider.setWindowState(windowState);
        }
        if (portletMode != null) {
            portletURLProvider.setPortletMode(portletMode);
        }
        if (bl2) {
            portletURLProvider.setAction();
        }
        if (bl3) {
            portletURLProvider.setSecure();
        }
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "rewriteURL", "_pState: ");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    logger.logp(Level.FINEST, CLASS_NAME, "strPortletState", "strPortletState[" + i + "]=" + stringArray[i]);
                }
            }
        }
        portletURLProvider.setParameters(map);
        String string = ((Object)portletURLProvider).toString();
        logger.logp(Level.FINE, CLASS_NAME, "rewriteURL", "PortletURLProvider creating URL " + string);
        writer.write(string);
        logger.exiting(CLASS_NAME, "rewriteURL");
    }

    private static PortletURLProvider _getPortletURLProvider(PortletWindow portletWindow) {
        return ExtInformationProviderWrapper.getExtProvider().getPortletURLProvider(portletWindow.getPortletWindowIdentifier(), true);
    }
}

