/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.websphere.cache.DynamicCacheAccessor;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.websphere.servlet.cache.ServletCacheResponse;
import com.ibm.ws.portletcontainer.cache.CacheInformation;
import com.ibm.ws.webcontainer.cache.CacheManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheHelper {
    public static final String KEY_STATEARRAY = "_pStateArray";
    public static final String TRUE = "true";
    private static final String CLASS_NAME = CacheHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private static String INTERNAL_CACHE_CONTROL = "com.ibm.ws.portletcontainer.cache.CacheInformation";
    private static String CACHE_EXPIRATION_REMAINING = "com.ibm.websphere.portlet.cache.remainingTime";
    private static String CACHE_EXPIRATION_LIMIT = "com.ibm.websphere.portlet.cache.definedTime";
    private static String CACHE_EXPIRATION_VALUE = "expirationTime";

    public static final boolean isCachingEnabled() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "isCachingEnabled()", "DynamicCacheAccessor.isCacheEnabled = " + DynamicCacheAccessor.isCachingEnabled());
            logger.logp(Level.FINEST, CLASS_NAME, "isCachingEnabled()", "CacheManager.isCacheEnabled = " + CacheManager.cacheEnabled);
            logger.logp(Level.FINEST, CLASS_NAME, "isCachingEnabled()", "PortletContainer.isCacheEnabled = " + com.ibm.ws.portletcontainer.util.CacheHelper.isPortletContainerCachingEnabled());
        }
        return DynamicCacheAccessor.isCachingEnabled() && CacheManager.cacheEnabled && com.ibm.ws.portletcontainer.util.CacheHelper.isPortletContainerCachingEnabled();
    }

    public static final boolean isPortletCacheable(HttpServletRequest httpServletRequest) {
        logger.entering(CLASS_NAME, "isPortletCacheable", httpServletRequest);
        ServletCacheRequest servletCacheRequest = CacheHelper.getServletCacheRequest(httpServletRequest);
        boolean bl = false;
        if (servletCacheRequest != null) {
            boolean bl2 = bl = !servletCacheRequest.isUncacheable();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "isPortletCacheable()", "ServletCacheRequest.isUncacheable = " + servletCacheRequest.isUncacheable());
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "isPortletCacheable()", "ServletCacheRequest not found. Portlet is not cacheable for this request.");
        }
        logger.exiting(CLASS_NAME, "isPortletCacheable", bl);
        return bl;
    }

    public static final ServletCacheRequest getServletCacheRequest(HttpServletRequest httpServletRequest) {
        logger.entering(CLASS_NAME, "getServletCacheRequest", httpServletRequest);
        if (!CacheHelper.isCachingEnabled()) {
            logger.exiting(CLASS_NAME, "getServletCacheRequest", null);
            return null;
        }
        boolean bl = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getServletCacheRequest()", "Verifying request " + httpServletRequest);
        }
        while (true) {
            if (httpServletRequest instanceof ServletCacheRequest) {
                logger.exiting(CLASS_NAME, "getServletCacheRequest", httpServletRequest);
                return (ServletCacheRequest)httpServletRequest;
            }
            if (!(httpServletRequest instanceof HttpServletRequestWrapper)) break;
            httpServletRequest = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest).getRequest();
            if (!bl) continue;
            logger.logp(Level.FINEST, CLASS_NAME, "getServletCacheRequest()", "Request found: " + httpServletRequest);
        }
        logger.exiting(CLASS_NAME, "getServletCacheRequest", null);
        return null;
    }

    public static final ServletCacheResponse getServletCacheResponse(HttpServletResponse httpServletResponse) {
        logger.entering(CLASS_NAME, "getServletCacheResponse", httpServletResponse);
        if (!CacheHelper.isCachingEnabled()) {
            logger.exiting(CLASS_NAME, "getServletCacheResponse", null);
            return null;
        }
        boolean bl = logger.isLoggable(Level.FINEST);
        if (bl) {
            logger.logp(Level.FINEST, CLASS_NAME, "getServletCacheResponse()", "Verifying response " + httpServletResponse);
        }
        while (true) {
            if (httpServletResponse instanceof ServletCacheResponse) {
                logger.exiting(CLASS_NAME, "getServletCacheResponse", httpServletResponse);
                return (ServletCacheResponse)httpServletResponse;
            }
            if (!(httpServletResponse instanceof HttpServletResponseWrapper)) break;
            httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
            if (!bl) continue;
            logger.logp(Level.FINEST, CLASS_NAME, "getServletCacheResponse()", "Response found: " + httpServletResponse);
        }
        logger.exiting(CLASS_NAME, "getServletCacheResponse", null);
        return null;
    }

    public static void createCacheInformation(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute(INTERNAL_CACHE_CONTROL, (Object)CacheInformation.createCacheInformationDetails(httpServletRequest));
    }

    public static void processCacheInformation(HttpServletRequest httpServletRequest) {
        String string;
        Integer n;
        String[] stringArray = (String[])httpServletRequest.getAttribute(INTERNAL_CACHE_CONTROL);
        httpServletRequest.removeAttribute(INTERNAL_CACHE_CONTROL);
        CacheInformation cacheInformation = null;
        if (stringArray != null) {
            cacheInformation = new CacheInformation(stringArray);
        }
        if (CACHE_EXPIRATION_VALUE.equals(httpServletRequest.getAttribute(CACHE_EXPIRATION_LIMIT))) {
            n = cacheInformation != null ? cacheInformation.getCacheExpirationTime() : null;
            string = n != null ? Integer.toString(n) : null;
            httpServletRequest.setAttribute(CACHE_EXPIRATION_LIMIT, (Object)string);
        }
        if (CACHE_EXPIRATION_VALUE.equals(httpServletRequest.getAttribute(CACHE_EXPIRATION_REMAINING))) {
            n = cacheInformation != null ? cacheInformation.getCacheRemainingTime() : null;
            string = n != null ? Integer.toString(n) : null;
            httpServletRequest.setAttribute(CACHE_EXPIRATION_REMAINING, (Object)string);
        }
    }
}

