/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.portletcontainer.cache.CacheHelper;
import com.ibm.wsspi.cache.CacheEntry;
import com.ibm.wsspi.cache.CacheMonitor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class CacheInformation {
    private static final String CLASS_NAME = CacheInformation.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private String instanceName;
    private String cacheId;

    public static String[] createCacheInformationDetails(HttpServletRequest httpServletRequest) {
        FragmentInfo fragmentInfo;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "createCacheInformationDetails", new Object[]{httpServletRequest});
        }
        ServletCacheRequest servletCacheRequest = CacheHelper.getServletCacheRequest(httpServletRequest);
        String[] stringArray = null;
        FragmentInfo fragmentInfo2 = fragmentInfo = servletCacheRequest != null ? (FragmentInfo)servletCacheRequest.getFragmentInfo() : null;
        if (fragmentInfo != null) {
            String string = fragmentInfo.getInstanceName();
            String string2 = fragmentInfo.getId();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "createCacheInformationDetails", "Retrieve data for cache entry <" + string2 + "> of cache instance <" + string + ">");
            }
            if (string2 != null) {
                stringArray = new String[]{string, string2};
            }
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "createCacheInformationDetails", stringArray);
        }
        return stringArray;
    }

    public CacheInformation(String[] stringArray) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "CacheInformation", "Init CacheInformation with data for cache entry <" + stringArray[0] + "> of cache instance <" + stringArray[1] + ">");
        }
        this.instanceName = stringArray[0];
        this.cacheId = stringArray[1];
    }

    public Integer getCacheRemainingTime() {
        boolean bl = logger.isLoggable(Level.FINEST);
        Integer n = null;
        CacheEntry cacheEntry = this.getCacheEntry();
        if (cacheEntry != null) {
            long l = cacheEntry.getExpirationTime();
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "getCacheRemainingTime", "Retrieved absolute expiration time for cache entry <" + l + ">");
            }
            int n2 = -1;
            if (l >= 0L) {
                long l2 = System.currentTimeMillis();
                if (l >= l2) {
                    long l3 = l - l2;
                    if (bl) {
                        logger.logp(Level.FINEST, CLASS_NAME, "getCacheRemainingTime", "Calculated expiration time for cache entry <" + l3 + ">");
                    }
                    if ((n2 = Math.round(l3 / 1000L)) < 0) {
                        n2 = 0;
                    }
                } else {
                    n2 = 0;
                }
            }
            n = new Integer(n2);
        }
        return n;
    }

    public Integer getCacheExpirationTime() {
        Integer n = null;
        CacheEntry cacheEntry = this.getCacheEntry();
        if (cacheEntry != null) {
            n = new Integer(cacheEntry.getTimeLimit());
        }
        return n;
    }

    public boolean isCacheEntryAvailable() {
        return this.getCacheEntry() != null;
    }

    private CacheEntry getCacheEntry() {
        CacheEntry cacheEntry = null;
        if (this.cacheId != null) {
            cacheEntry = CacheMonitor.getCache((String)this.instanceName).getEntry((Object)this.cacheId);
        }
        return cacheEntry;
    }
}

