/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.ws.portletcontainer.cache.CacheHelper;
import com.ibm.ws.portletcontainer.cache.response.CacheHttpServletResponseWrapper;
import com.ibm.wsspi.portletcontainer.PortletContainerException;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaboratorChain;
import com.ibm.wsspi.portletcontainer.services.PortletContainerContext;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheInvokerCollaborator
implements PortletContainerInvokerCollaborator {
    private static final String CLASS_NAME = CacheInvokerCollaborator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doRender", new Object[]{httpServletRequest, httpServletResponse, portletContainerInvokerCollaboratorChain});
        }
        if (CacheHelper.isCachingEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doDispatch", "Caching enabled. Wrapping response.");
            }
            CacheHttpServletResponseWrapper cacheHttpServletResponseWrapper = new CacheHttpServletResponseWrapper(httpServletRequest, httpServletResponse);
            try {
                portletContainerInvokerCollaboratorChain.doCollaborator(portletWindowIdentifier, httpServletRequest, (HttpServletResponse)cacheHttpServletResponseWrapper, portletContainerContext);
            }
            finally {
                cacheHttpServletResponseWrapper.release();
            }
        } else {
            portletContainerInvokerCollaboratorChain.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
        }
        logger.exiting(CLASS_NAME, "doRender");
    }

    public void doAction(PortletWindowIdentifier portletWindowIdentifier, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletContainerContext portletContainerContext, PortletContainerInvokerCollaboratorChain portletContainerInvokerCollaboratorChain) throws PortletException, IOException, PortletContainerException {
        portletContainerInvokerCollaboratorChain.doCollaborator(portletWindowIdentifier, httpServletRequest, httpServletResponse, portletContainerContext);
    }
}

