/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.ws.portletcontainer.cache.parser.Codec;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachePortletURLPatternHelper {
    private static final String URL_TOKEN_MARKER = "token_rewrite/";
    private static int TOKEN_SIZE_GUESS = 256;
    private static final String CLASS_NAME = CachePortletURLPatternHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");

    public static String getStdPortletURLToken(Codec codec, Codec codec2, String string, String string2, boolean bl, boolean bl2, Map map) {
        String[] stringArray = new String[]{string != null ? string.toString() : "null", string2 != null ? string2.toString() : "null", bl ? "true" : "false", bl2 ? "true" : "false"};
        return CachePortletURLPatternHelper.getStdPortletURLToken(codec, codec2, stringArray, map);
    }

    public static String getStdPortletURLToken(Codec codec, Codec codec2, String[] stringArray, Map map) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getStdPortletURLToken");
        }
        StringBuffer stringBuffer = new StringBuffer(TOKEN_SIZE_GUESS);
        stringBuffer.append(URL_TOKEN_MARKER);
        CachePortletURLPatternHelper.encodePair(codec, codec2, "_pStateArray", stringArray, stringBuffer);
        if (map != null && !map.isEmpty()) {
            stringBuffer.append('&');
            CachePortletURLPatternHelper.hashMap2String(codec, codec2, map, stringBuffer);
        }
        stringBuffer.append("/token_rewrite");
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "getStdPortletURLToken", stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static boolean isCacheTokenURL(String string) {
        return string.startsWith(URL_TOKEN_MARKER);
    }

    public static void hashMap2String(Codec codec, Codec codec2, Map map, StringBuffer stringBuffer) {
        boolean bl = logger.isLoggable(Level.FINEST);
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        if (bl) {
            logger.entering(CLASS_NAME, "hashMap2String()");
            logger.logp(Level.FINEST, CLASS_NAME, "hashMap2String()", iterator.toString());
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (n++ > 0) {
                stringBuffer.append('&');
            }
            if (bl) {
                logger.logp(Level.FINEST, CLASS_NAME, "hashMap2String()", "++++++ Key = " + entry.getKey() + ", Value = " + entry.getValue() + " ++++++");
            }
            CachePortletURLPatternHelper.encodePair(codec, codec2, entry.getKey(), entry.getValue(), stringBuffer);
        }
        if (bl) {
            logger.exiting(CLASS_NAME, "hashMap2String()", stringBuffer);
        }
    }

    private static void encodePair(Codec codec, Codec codec2, Object object, Object object2, StringBuffer stringBuffer) {
        codec.encode(object, stringBuffer);
        stringBuffer.append('=');
        codec2.encode(object2, stringBuffer);
    }
}

