/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache;

import com.ibm.websphere.servlet.cache.ServletCacheResponse;
import com.ibm.ws.portletcontainer.cache.CachePortletURLPatternHelper;
import com.ibm.ws.portletcontainer.cache.parser.CacheCodec;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.services.information.PortletURLProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class CachePortletURLProviderWrapper
implements PortletURLProvider {
    private static final String CLASS_NAME = CachePortletURLProviderWrapper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private PortletURLProvider urlProvider;
    private PortletWindowIdentifier id;
    private ServletCacheResponse response;
    private PortletMode mode;
    private WindowState state;
    private Map parameters = new HashMap();
    private boolean secure = false;
    private boolean action = false;

    public static PortletURLProvider getPortletURLProvider(PortletWindowIdentifier portletWindowIdentifier, PortletURLProvider portletURLProvider, HttpServletRequest httpServletRequest, ServletCacheResponse servletCacheResponse) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "getPortletURLProvider", new Object[]{portletWindowIdentifier, httpServletRequest, servletCacheResponse});
        }
        CachePortletURLProviderWrapper cachePortletURLProviderWrapper = new CachePortletURLProviderWrapper(portletWindowIdentifier, portletURLProvider, servletCacheResponse);
        if (bl) {
            logger.exiting(CLASS_NAME, "getPortletURLProvider", cachePortletURLProviderWrapper.getClass().getName() + "#" + cachePortletURLProviderWrapper.hashCode());
        }
        return cachePortletURLProviderWrapper;
    }

    CachePortletURLProviderWrapper(PortletWindowIdentifier portletWindowIdentifier, PortletURLProvider portletURLProvider, ServletCacheResponse servletCacheResponse) {
        this.id = portletWindowIdentifier;
        this.urlProvider = portletURLProvider;
        this.response = servletCacheResponse;
    }

    public boolean isSecuritySupported() {
        return this.urlProvider.isSecuritySupported();
    }

    public void setWindowState(WindowState windowState) {
        logger.entering(CLASS_NAME, "setWindowState", windowState);
        this.urlProvider.setWindowState(windowState);
        this.state = windowState;
        logger.exiting(CLASS_NAME, "setWindowState");
    }

    public void setPortletMode(PortletMode portletMode) {
        logger.entering(CLASS_NAME, "setPortletMode", portletMode);
        this.urlProvider.setPortletMode(portletMode);
        this.mode = portletMode;
        logger.exiting(CLASS_NAME, "setPortletMode");
    }

    public void setParameters(Map map) {
        logger.entering(CLASS_NAME, "setParameters", map);
        this.urlProvider.setParameters(map);
        this.parameters = map;
        logger.exiting(CLASS_NAME, "setParameters");
    }

    public void setSecure() {
        logger.entering(CLASS_NAME, "setSecure");
        this.urlProvider.setSecure();
        this.secure = true;
        logger.exiting(CLASS_NAME, "setSecure");
    }

    public void setAction() {
        logger.entering(CLASS_NAME, "setAction");
        this.urlProvider.setAction();
        this.action = true;
        logger.exiting(CLASS_NAME, "setAction");
    }

    public String toString() {
        logger.entering(CLASS_NAME, "toString");
        String string = this.state != null ? this.state.toString() : "null";
        String string2 = this.mode != null ? this.mode.toString() : "null";
        String string3 = CachePortletURLPatternHelper.getStdPortletURLToken(CacheCodec.getStringCodec(), CacheCodec.getStringArrayCodec(), string, string2, this.action, this.secure, this.parameters);
        logger.exiting(CLASS_NAME, "toString", string3);
        return string3;
    }
}

