/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.parser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.cache.parser.Codec;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class CacheCodec {
    private static final Codec stringCodec = new UrlCodec();
    private static final Codec arrayCodec = new StringArrayCodec(stringCodec);

    public static Codec getStringCodec() {
        return stringCodec;
    }

    public static Codec getStringArrayCodec() {
        return arrayCodec;
    }

    private static final class StringArrayCodec
    implements Codec {
        private final String separator;
        private final Codec codec;

        public StringArrayCodec(Codec codec) {
            this(",", codec);
        }

        public StringArrayCodec(String string, Codec codec) {
            this.codec = codec;
            this.separator = string;
        }

        public Object decode(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.separator);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.codec.decode(stringTokenizer.nextToken());
            }
            return stringArray;
        }

        public void encode(Object object, StringBuffer stringBuffer) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(this.separator);
                }
                this.codec.encode(stringArray[i], stringBuffer);
            }
        }
    }

    private static final class UrlCodec
    implements Codec {
        private UrlCodec() {
        }

        public void encode(Object object, StringBuffer stringBuffer) {
            if (object != null) {
                try {
                    stringBuffer.append(URLEncoder.encode(object.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.portletcontainer.cache.CacheCodec.encode", (String)"39", (Object)this);
                    throw new IllegalStateException();
                }
            }
        }

        public Object decode(String string) {
            if (string == null) {
                return "";
            }
            try {
                return URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.portletcontainer.cache.CacheCodec.decode", (String)"53", (Object)this);
                throw new IllegalStateException();
            }
        }
    }
}

