/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.response;

import com.ibm.ws.portletcontainer.cache.parser.ContentHandler;
import com.ibm.ws.portletcontainer.cache.parser.ParserException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletResponse;

public abstract class AbstractCacheContentHandler
implements ContentHandler {
    private static final String CLASS_NAME = AbstractCacheContentHandler.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    protected Writer out = null;
    private ServletResponse response;

    public AbstractCacheContentHandler(ServletResponse servletResponse) {
        this.response = servletResponse;
    }

    public void characters(char[] cArray, int n, int n2) throws IOException {
        this.getWriter().write(cArray, n, n2);
    }

    public void characters(String string, int n, int n2) throws IOException {
        this.getWriter().write(string, n, n2);
    }

    public void flush() throws IOException {
        this.getWriter().flush();
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "flush");
            logger.exiting(CLASS_NAME, "flush");
        }
    }

    public void endDocument() throws IOException {
        this.getWriter().flush();
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "endDocument");
            logger.exiting(CLASS_NAME, "endDocument");
        }
    }

    public boolean handleError(String string) throws ParserException, IOException {
        return true;
    }

    public void namespacePrefix() throws IOException {
        throw new IllegalStateException();
    }

    public abstract void rewriteURL(Map var1) throws IOException;

    public void startDocument() throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "startDocument");
            logger.exiting(CLASS_NAME, "startDocument");
        }
    }

    protected Writer getWriter() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
        return this.out;
    }
}

