/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.response;

import com.ibm.ws.portletcontainer.cache.parser.Codec;
import com.ibm.ws.portletcontainer.cache.parser.Constants;
import com.ibm.ws.portletcontainer.cache.parser.ContentHandler;
import com.ibm.ws.portletcontainer.cache.parser.ParserException;
import com.ibm.ws.portletcontainer.cache.util.CharArray;
import com.ibm.ws.portletcontainer.cache.util.CharWriter;
import com.ibm.ws.portletcontainer.cache.util.StringMatcher;
import com.ibm.ws.portletcontainer.cache.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class CacheFilterWriter
extends Writer
implements Constants {
    private static final boolean DEBUG = false;
    private static final Codec identityCodec = new IdentityCodec();
    private static final int MAX_TOKEN_LEN = "/token_rewrite".length();
    protected static final int NAMESPACE_TOKEN = 0;
    protected static final int NO_TOKEN = 1;
    protected static final int PARAMS_TOKEN = 2;
    protected static final int REWRITE_TOKEN = 3;
    protected static final int START_TOKEN = 4;
    protected static final int STOP_TOKEN = 5;
    protected static final int CLOSED = 6;
    private static final char[] TOKEN_PARAM_SEP_CHARS = "&amp;".toCharArray();
    private boolean disabled;
    protected final Codec keycodec;
    protected final Codec paramcodec;
    protected int currentState = 6;
    protected ContentHandler handler;
    protected final CharWriter paramBuffer = new CharWriter();
    private final ContentHandler parameterHandler = new ParameterHandler();
    protected Map params;
    protected final StringMatcher startTokenFinder;
    protected final StringMatcher stopTokenFinder;
    protected final CharArray tokenBuffer = new CharArray(2 * MAX_TOKEN_LEN - 1);

    public void disable() {
        this.disabled = true;
    }

    public static Codec getDefaultCodec() {
        return identityCodec;
    }

    private static final void assertRange(char[] cArray, int n, int n2, String string) {
        if (cArray == null) {
            throw new IllegalStateException("cbuf == null @" + string);
        }
        if (n < 0) {
            throw new IllegalStateException("off < 0 @" + string);
        }
        if (n + n2 > cArray.length) {
            throw new IllegalStateException("off+len > cbuf.length @" + string);
        }
    }

    private static final void assertRange(String string, int n, int n2, String string2) {
        if (string == null) {
            throw new IllegalStateException("cbuf == null @" + string2);
        }
        if (n < 0) {
            throw new IllegalStateException("off < 0 @" + string2);
        }
        if (n + n2 > string.length()) {
            throw new IllegalStateException("off+len > cbuf.length @" + string2);
        }
    }

    private static final boolean equals(char[] cArray, char[] cArray2, int n) {
        return CacheFilterWriter.equals(cArray, 0, cArray2, 0, n);
    }

    private static final boolean equals(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3 - 1;
        int n5 = n2 + n3 - 1;
        for (int i = n3 - 1; i >= 0; --i) {
            if (cArray[n4--] == cArray2[n5--]) continue;
            return false;
        }
        return true;
    }

    private static final int indexOf(char[] cArray, int n, int n2, char c) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public CacheFilterWriter() {
        this((Codec)null, (Codec)null);
    }

    public CacheFilterWriter(Codec codec, Codec codec2) {
        this.paramcodec = codec == null ? identityCodec : codec;
        this.keycodec = codec2 == null ? identityCodec : codec2;
        this.startTokenFinder = StringUtils.getStringMatcher("token_rewrite");
        this.stopTokenFinder = StringUtils.getStringMatcher("/token_rewrite");
    }

    public CacheFilterWriter(Map map, ContentHandler contentHandler) throws IOException {
        this((Codec)null, (Codec)null);
        this.reset(map, contentHandler);
    }

    public CacheFilterWriter(Map map, ContentHandler contentHandler, Codec codec, Codec codec2) throws IOException {
        this(codec, codec2);
        this.reset(map, contentHandler);
    }

    public void close() throws IOException {
        this.flushFilter();
        this.currentState = 6;
        this.handler.endDocument();
    }

    public void flush() throws IOException {
        this.flushFilter();
        this.currentState = 1;
        this.handler.flush();
    }

    private void flushFilter() throws IOException {
        while (this.currentState == 5) {
            this.handleStopToken((char[])null, 0, 0);
        }
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.handler.handleError(null)) break;
                this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
                this.handler.characters(new char[]{'/'}, 0, 1);
                if (this.paramBuffer.isEmpty()) break;
                this.handler.characters(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize());
                break;
            }
            case 4: {
                this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.tokenBuffer.align();
        if (!this.tokenBuffer.isEmpty()) {
            this.handler.characters(this.tokenBuffer.getData(), this.tokenBuffer.getBegin(), this.tokenBuffer.getSize());
            this.tokenBuffer.reset();
        }
    }

    protected int handleNamespaceToken(char[] cArray, int n, int n2) throws IOException {
        this.handler.namespacePrefix();
        this.currentState = 1;
        return 0;
    }

    protected int handleNoToken(char[] cArray, int n, int n2) throws IOException {
        return this.handleToken(cArray, n, n2, this.startTokenFinder, 4, this.handler);
    }

    protected int handleParamsToken(char[] cArray, int n, int n2) throws IOException {
        return this.handleToken(cArray, n, n2, this.stopTokenFinder, 5, this.parameterHandler);
    }

    protected int handleRewriteToken(char[] cArray, int n, int n2) {
        this.paramBuffer.reset();
        this.currentState = 2;
        return 0;
    }

    protected int handleStartToken(char[] cArray, int n, int n2) throws IOException {
        if (this.tokenBuffer.isEmpty()) {
            this.tokenBuffer.write(cArray, n, 1);
            return 1;
        }
        switch (this.tokenBuffer.getFirst()) {
            case '/': {
                this.currentState = 3;
                this.tokenBuffer.trimLeft(1);
                return 0;
            }
            case '_': {
                this.currentState = 0;
                this.tokenBuffer.trimLeft(1);
                return 0;
            }
        }
        this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
        this.currentState = 1;
        return 0;
    }

    protected int handleStopToken(char[] cArray, int n, int n2) throws IOException {
        this.params.clear();
        if (this.parseParams(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize(), this.params)) {
            this.handler.rewriteURL(this.params);
        } else if (this.handler.handleError(String.valueOf(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize()))) {
            this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
            this.handler.characters(new char[]{'/'}, 0, 1);
            this.handler.characters(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize());
            this.handler.characters(this.stopTokenFinder.getPattern(), 0, this.stopTokenFinder.getPatternLen());
        }
        this.currentState = 1;
        return 0;
    }

    protected int handleToken(char[] cArray, int n, int n2, StringMatcher stringMatcher, int n3, ContentHandler contentHandler) throws IOException {
        char[] cArray2 = stringMatcher.getPattern();
        int n4 = cArray2.length;
        int n5 = Math.min(n2, n4 - 1);
        this.tokenBuffer.write(cArray, n, n5);
        if (this.tokenBuffer.getSize() < n4) {
            return n5;
        }
        int n6 = this.tokenBuffer.indexOf(stringMatcher);
        if (n6 >= 0) {
            int n7 = this.tokenBuffer.getBegin();
            if (n6 > n7) {
                contentHandler.characters(this.tokenBuffer.getData(), n7, n6 - n7);
            }
            this.tokenBuffer.trimLeft(n6 - n7 + n4);
            this.currentState = n3;
            return n5;
        }
        if (n2 >= n4) {
            contentHandler.characters(this.tokenBuffer.getData(), this.tokenBuffer.getBegin(), this.tokenBuffer.getSize() - n5);
            this.tokenBuffer.reset();
            n6 = stringMatcher.indexOf(cArray, n, n2);
            if (n6 >= 0) {
                int n8 = n6 - n;
                contentHandler.characters(cArray, n, n8);
                this.currentState = n3;
                return n8 + n4;
            }
            if (n2 > n5) {
                contentHandler.characters(cArray, n, n2 - n5);
            }
            this.tokenBuffer.write(cArray, n + n2 - n5, n5);
            return n2;
        }
        int n9 = Math.min(n5, this.tokenBuffer.getSize() - n4 + 1);
        contentHandler.characters(this.tokenBuffer.getData(), this.tokenBuffer.getBegin(), n9);
        this.tokenBuffer.trimLeft(n9);
        this.tokenBuffer.trimRight(n5 - n9);
        return n9;
    }

    protected boolean parseNameValue(char[] cArray, int n, int n2, Map map) throws ParserException, IOException {
        int n3 = CacheFilterWriter.indexOf(cArray, n, n2, '=');
        if (n3 > n) {
            map.put(this.keycodec.decode(String.valueOf(cArray, n, n3 - n)), this.paramcodec.decode(String.valueOf(cArray, n3 + 1, n2 - n3 + n - 1)));
            return true;
        }
        this.handler.handleError(String.valueOf(cArray, n, n2));
        return false;
    }

    protected boolean parseParams(char[] cArray, int n, int n2, Map map) throws ParserException, IOException {
        int n3;
        int n4 = n;
        int n5 = n + n2;
        while (n4 < n5 && (n3 = CacheFilterWriter.indexOf(cArray, n4, n5 - n4, '&')) >= 0) {
            if (!this.parseNameValue(cArray, n4, n3 - n4, map)) {
                return false;
            }
            if (CacheFilterWriter.equals(cArray, n3, TOKEN_PARAM_SEP_CHARS, 0, TOKEN_PARAM_SEP_STRG_LEN)) {
                n4 = n3 + TOKEN_PARAM_SEP_STRG_LEN;
                continue;
            }
            n4 = n3 + 1;
        }
        if (n4 < n5) {
            return this.parseNameValue(cArray, n4, n5 - n4, map);
        }
        return true;
    }

    public final void reset(Map map, ContentHandler contentHandler) throws IOException {
        if (contentHandler == null) {
            throw new IllegalArgumentException();
        }
        if (this.currentState != 6) {
            throw new IllegalStateException();
        }
        this.handler = contentHandler;
        if (map != null) {
            this.params = map;
        } else if (this.params == null) {
            this.params = new HashMap();
        }
        this.currentState = 1;
        this.tokenBuffer.reset();
        this.paramBuffer.reset();
        this.handler.startDocument();
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.disabled) {
            this.handler.characters(cArray, n, n2);
            return;
        }
        while (n2 > 0) {
            int n3 = 0;
            switch (this.currentState) {
                case 1: {
                    n3 = this.handleNoToken(cArray, n, n2);
                    break;
                }
                case 4: {
                    n3 = this.handleStartToken(cArray, n, n2);
                    break;
                }
                case 3: {
                    n3 = this.handleRewriteToken(cArray, n, n2);
                    break;
                }
                case 0: {
                    n3 = this.handleNamespaceToken(cArray, n, n2);
                    break;
                }
                case 2: {
                    n3 = this.handleParamsToken(cArray, n, n2);
                    break;
                }
                case 5: {
                    n3 = this.handleStopToken(cArray, n, n2);
                    break;
                }
                case 6: {
                    return;
                }
                default: {
                    this.handler.handleError(String.valueOf(cArray, n, n2));
                    return;
                }
            }
            n += n3;
            n2 -= n3;
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.disabled) {
            this.handler.characters(string, n, n2);
            return;
        }
        while (n2 > 0) {
            int n3 = 0;
            switch (this.currentState) {
                case 1: {
                    n3 = this.handleNoToken(string, n, n2);
                    break;
                }
                case 4: {
                    n3 = this.handleStartToken(string, n, n2);
                    break;
                }
                case 3: {
                    n3 = this.handleRewriteToken(string, n, n2);
                    break;
                }
                case 0: {
                    n3 = this.handleNamespaceToken(string, n, n2);
                    break;
                }
                case 2: {
                    n3 = this.handleParamsToken(string, n, n2);
                    break;
                }
                case 5: {
                    n3 = this.handleStopToken(string, n, n2);
                    break;
                }
                case 6: {
                    return;
                }
                default: {
                    this.handler.handleError(string.substring(n, n + n2));
                    return;
                }
            }
            n += n3;
            n2 -= n3;
        }
    }

    protected int handleNamespaceToken(String string, int n, int n2) throws IOException {
        this.handler.namespacePrefix();
        this.currentState = 1;
        return 0;
    }

    protected int handleNoToken(String string, int n, int n2) throws IOException {
        return this.handleToken(string, n, n2, this.startTokenFinder, 4, this.handler);
    }

    protected int handleParamsToken(String string, int n, int n2) throws IOException {
        return this.handleToken(string, n, n2, this.stopTokenFinder, 5, this.parameterHandler);
    }

    protected int handleRewriteToken(String string, int n, int n2) {
        this.paramBuffer.reset();
        this.currentState = 2;
        return 0;
    }

    protected int handleStartToken(String string, int n, int n2) throws IOException {
        if (this.tokenBuffer.isEmpty()) {
            this.tokenBuffer.write(string, n, 1);
            return 1;
        }
        switch (this.tokenBuffer.getFirst()) {
            case '/': {
                this.currentState = 3;
                this.tokenBuffer.trimLeft(1);
                return 0;
            }
            case '_': {
                this.currentState = 0;
                this.tokenBuffer.trimLeft(1);
                return 0;
            }
        }
        this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
        this.currentState = 1;
        return 0;
    }

    protected int handleStopToken(String string, int n, int n2) throws IOException {
        this.params.clear();
        if (this.parseParams(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize(), this.params)) {
            this.handler.rewriteURL(this.params);
        } else if (this.handler.handleError(String.valueOf(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize()))) {
            this.handler.characters(this.startTokenFinder.getPattern(), 0, this.startTokenFinder.getPatternLen());
            this.handler.characters(new char[]{'/'}, 0, 1);
            this.handler.characters(this.paramBuffer.getData(), this.paramBuffer.getBegin(), this.paramBuffer.getSize());
            this.handler.characters(this.stopTokenFinder.getPattern(), 0, this.stopTokenFinder.getPatternLen());
        }
        this.currentState = 1;
        return 0;
    }

    protected int handleToken(String string, int n, int n2, StringMatcher stringMatcher, int n3, ContentHandler contentHandler) throws IOException {
        char[] cArray = stringMatcher.getPattern();
        int n4 = cArray.length;
        int n5 = Math.min(n2, n4 - 1);
        this.tokenBuffer.write(string, n, n5);
        if (this.tokenBuffer.getSize() < n4) {
            return n5;
        }
        int n6 = this.tokenBuffer.indexOf(stringMatcher);
        if (n6 >= 0) {
            int n7 = this.tokenBuffer.getBegin();
            if (n6 > n7) {
                contentHandler.characters(this.tokenBuffer.getData(), n7, n6 - n7);
            }
            this.tokenBuffer.trimLeft(n6 - n7 + n4);
            this.currentState = n3;
            return n5;
        }
        if (n2 >= n4) {
            contentHandler.characters(this.tokenBuffer.getData(), this.tokenBuffer.getBegin(), this.tokenBuffer.getSize() - n5);
            this.tokenBuffer.reset();
            n6 = stringMatcher.indexOf(string, n, n2);
            if (n6 >= 0) {
                int n8 = n6 - n;
                contentHandler.characters(string, n, n8);
                this.currentState = n3;
                return n8 + n4;
            }
            if (n2 > n5) {
                contentHandler.characters(string, n, n2 - n5);
            }
            this.tokenBuffer.write(string, n + n2 - n5, n5);
            return n2;
        }
        int n9 = Math.min(n5, this.tokenBuffer.getSize() - n4 + 1);
        contentHandler.characters(this.tokenBuffer.getData(), this.tokenBuffer.getBegin(), n9);
        this.tokenBuffer.trimLeft(n9);
        this.tokenBuffer.trimRight(n5 - n9);
        return n9;
    }

    private final class ParameterHandler
    implements ContentHandler {
        private ParameterHandler() {
        }

        public void characters(char[] cArray, int n, int n2) throws IOException {
            CacheFilterWriter.this.paramBuffer.write(cArray, n, n2);
        }

        public void characters(String string, int n, int n2) throws IOException {
            CacheFilterWriter.this.paramBuffer.write(string, n, n2);
        }

        public void flush() throws IOException {
            throw new IllegalStateException();
        }

        public void endDocument() throws IOException {
            throw new IllegalStateException();
        }

        public boolean handleError(String string) throws ParserException, IOException {
            throw new IllegalStateException();
        }

        public void namespacePrefix() throws IOException {
            throw new IllegalStateException();
        }

        public void rewriteURL(Map map) throws IOException {
            throw new IllegalStateException();
        }

        public void startDocument() throws IOException {
            throw new IllegalStateException();
        }
    }

    private static final class IdentityCodec
    implements Codec {
        private IdentityCodec() {
        }

        public Object decode(String string) {
            return string;
        }

        public void encode(Object object, StringBuffer stringBuffer) {
            stringBuffer.append(object.toString());
        }
    }
}

