/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.response;

import com.ibm.ws.portletcontainer.cache.CacheHelper;
import com.ibm.ws.portletcontainer.cache.parser.CacheCodec;
import com.ibm.ws.portletcontainer.cache.parser.Codec;
import com.ibm.ws.portletcontainer.cache.response.CacheContentHandler;
import com.ibm.ws.portletcontainer.cache.response.CacheFilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final String CLASS_NAME = CacheHttpServletResponseWrapper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private PrintWriter writer;
    private CacheFilterWriter cacheWriter;
    private Map paramMap = new HashMap();

    public CacheHttpServletResponseWrapper(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super(httpServletResponse);
        this.cacheWriter = this.wrapResponseWriter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        this.writer = new PrintWriter(this.cacheWriter);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        throw new IOException();
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    private CacheFilterWriter wrapResponseWriter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.entering(CLASS_NAME, "wrapResponseWriter()", new Object[]{servletRequest, servletResponse});
        }
        CacheContentHandler cacheContentHandler = new CacheContentHandler(servletRequest, servletResponse);
        Codec codec = CacheCodec.getStringArrayCodec();
        Codec codec2 = CacheCodec.getStringCodec();
        if (bl) {
            logger.exiting(CLASS_NAME, "wrapResponseWriter()", new Object[]{cacheContentHandler, codec, codec2});
        }
        return new CacheFilterWriter(this.paramMap, cacheContentHandler, codec, codec2);
    }

    public void release() throws IOException {
        this.getWriter().close();
    }

    public void disable() {
        this.writer.flush();
        this.cacheWriter.disable();
    }

    public static final void disableCacheResponseWrapper(HttpServletResponse httpServletResponse) {
        logger.entering(CLASS_NAME, "disableCacheResponseWrapper", httpServletResponse);
        if (CacheHelper.isCachingEnabled()) {
            CacheHttpServletResponseWrapper cacheHttpServletResponseWrapper = null;
            while (true) {
                if (httpServletResponse instanceof CacheHttpServletResponseWrapper) {
                    cacheHttpServletResponseWrapper = (CacheHttpServletResponseWrapper)httpServletResponse;
                    break;
                }
                if (!(httpServletResponse instanceof HttpServletResponseWrapper)) break;
                httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
            }
            if (cacheHttpServletResponseWrapper != null) {
                cacheHttpServletResponseWrapper.disable();
            }
        }
        logger.exiting(CLASS_NAME, "disableCacheResponseWrapper");
    }
}

