/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.util;

import com.ibm.ws.portletcontainer.cache.util.StringMatcher;
import java.io.IOException;
import java.io.Writer;

public class CharArray {
    static final boolean DEBUG = true;
    private final char[] buffer;
    private int idxBegin = 0;
    private int idxEnd = 0;
    private int maxSize;

    public CharArray(int n) {
        this.maxSize = n;
        this.buffer = new char[2 * this.maxSize];
    }

    public void align() {
        int n = this.idxEnd - this.idxBegin;
        System.arraycopy(this.buffer, this.idxBegin, this.buffer, 0, n);
        this.idxBegin = 0;
        this.idxEnd = n;
    }

    public boolean isEmpty() {
        return this.idxEnd <= this.idxBegin;
    }

    public char getFirst() {
        return this.buffer[this.idxBegin];
    }

    public char getLast() {
        return this.buffer[this.idxEnd - 1];
    }

    public void reset() {
        this.idxEnd = 0;
        this.idxBegin = 0;
    }

    public char[] getData() {
        return this.buffer;
    }

    public int getBegin() {
        return this.idxBegin;
    }

    public int getEnd() {
        return this.idxEnd;
    }

    public int getSize() {
        return this.idxEnd - this.idxBegin;
    }

    public void write(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalStateException("len < 0");
        }
        if (this.getSize() + n2 > this.maxSize) {
            throw new IllegalStateException("array size is out of bounds");
        }
        System.arraycopy(cArray, n, this.buffer, this.idxEnd, n2);
        this.idxEnd += n2;
    }

    public void write(String string, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalStateException("len < 0");
        }
        if (this.getSize() + n2 > this.maxSize) {
            throw new IllegalStateException("array size is out of bounds");
        }
        string.getChars(n, n + n2, this.buffer, this.idxEnd);
        this.idxEnd += n2;
    }

    public void trimLeft(int n) {
        if (n < 0) {
            throw new IllegalStateException("len < 0");
        }
        if (n > this.getSize()) {
            throw new IllegalStateException("trimming more than the current size");
        }
        this.idxBegin += n;
        if (this.idxBegin >= this.maxSize) {
            this.align();
        }
    }

    public void trimRight(int n) {
        if (n < 0) {
            throw new IllegalStateException("len < 0");
        }
        if (n > this.getSize()) {
            throw new IllegalStateException("trimming more than the current size");
        }
        this.idxEnd -= n;
    }

    public int indexOf(StringMatcher stringMatcher) {
        return stringMatcher.indexOf(this.buffer, this.idxBegin, this.idxEnd - this.idxBegin);
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.buffer, this.idxBegin, this.idxEnd - this.idxBegin);
    }

    public String toString() {
        return String.valueOf(this.buffer, this.idxBegin, this.idxEnd - this.idxBegin);
    }
}

