/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.cache.util;

import com.ibm.ws.portletcontainer.cache.util.StringMatcher;
import java.io.IOException;
import java.io.Writer;

public class CharWriter
extends Writer {
    protected char[] buffer;
    protected int size;

    private static final int getGrowthSize(int n, int n2) {
        return 2 * n + n2;
    }

    public CharWriter() {
        this(256);
    }

    public CharWriter(int n) {
        this.buffer = new char[n];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    private final void assertSize(int n) {
        if (this.buffer.length - this.size < n) {
            char[] cArray = new char[CharWriter.getGrowthSize(this.buffer.length, n)];
            System.arraycopy(this.buffer, 0, cArray, 0, this.size);
            this.buffer = cArray;
        }
    }

    public void close() throws IOException {
        this.reset();
    }

    public void flush() throws IOException {
    }

    public int getBegin() {
        return 0;
    }

    public char[] getData() {
        return this.buffer;
    }

    public int getEnd() {
        return this.size;
    }

    public int getSize() {
        return this.size;
    }

    public int indexOf(StringMatcher stringMatcher) {
        return stringMatcher.indexOf(this.buffer, 0, this.size);
    }

    public void reset() {
        this.size = 0;
    }

    public String toString() {
        return String.valueOf(this.buffer, 0, this.size);
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.assertSize(n2);
        System.arraycopy(cArray, n, this.buffer, this.size, n2);
        this.size += n2;
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        this.assertSize(n2);
        string.getChars(n, n + n2, this.buffer, this.size);
        this.size += n2;
    }
}

