/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.collaborator.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.ext.ExtensionScope;
import com.ibm.ws.portletcontainer.util.XmlParser;
import com.ibm.wsspi.portletcontainer.collaborator.Collaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletContainerInvokerCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletInvokerCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletServletCollaborator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CollaboratorRegistry {
    private static final String CLASS_NAME = CollaboratorRegistry.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static final String DEFAULT_NAMESPACE = "default";
    public static final String XMLFILENAME = "portlet-container-collaborator.xml";
    public static final String DEFAULT_MAPPING_XML = "META-INF/portlet-container-collaborator.xml";
    private static final String COLLABORATOR_XSD_NAME = "/PortletContainerCollaborator.xsd";
    private static final String[] COLLABORATOR_XSD_PATHS = new String[]{"/com/ibm/ws/portletcontainer/deployment/XMLSchema.dtd", "/com/ibm/ws/portletcontainer/collaborator/impl/PortletContainerCollaborator.xsd"};
    private static final String[] COLLABORATOR_XSD_NAMES = new String[]{"XMLSchema.dtd", "PortletContainerCollaborator.xsd"};
    private List portletInvokerCollList;
    private Map portletInvokerCollByOrderMap = new TreeMap();
    private boolean isPortletInvokerCollListCurrent;
    private List portletServletCollList;
    private Map portletServletCollByOrderMap = new TreeMap();
    private boolean isPortletServletCollListCurrent;
    private List pcInvokerCollList;
    private Map pcInvokerCollByOrderMap = new TreeMap();
    private boolean isPCInvokerCollListCurrent;
    private static CollaboratorRegistry instance = new CollaboratorRegistry();

    public static CollaboratorRegistry getInstance() {
        return instance;
    }

    private CollaboratorRegistry() {
        logger.entering(CLASS_NAME, "CollaboratorRegistry");
        this.registerAllCollaborators();
        logger.exiting(CLASS_NAME, "CollaboratorRegistry");
    }

    public List getPortletInvokerCollaborators() {
        logger.entering(CLASS_NAME, "getPortletInvokerCollaborators");
        if (!this.isPortletInvokerCollListCurrent) {
            this.isPortletInvokerCollListCurrent = true;
            this.copyCollaboratorMapToList(this.portletInvokerCollByOrderMap, this.getPortletInvokerCollList(true));
        }
        logger.exiting(CLASS_NAME, "getPortletInvokerCollaborators", this.portletInvokerCollList);
        return this.portletInvokerCollList;
    }

    public List getPortletServletCollaborators() {
        logger.entering(CLASS_NAME, "getPortletServletCollaborators");
        if (!this.isPortletServletCollListCurrent) {
            this.isPortletServletCollListCurrent = true;
            this.copyCollaboratorMapToList(this.portletServletCollByOrderMap, this.getPortletServletCollList(true));
        }
        logger.exiting(CLASS_NAME, "getPortletServletCollaborators", this.portletServletCollList);
        return this.portletServletCollList;
    }

    public List getPortletContainerInvokerCollaborators() {
        logger.entering(CLASS_NAME, "getPortletContainerInvokerCollaborators");
        if (!this.isPCInvokerCollListCurrent) {
            this.isPCInvokerCollListCurrent = true;
            this.copyCollaboratorMapToList(this.pcInvokerCollByOrderMap, this.getPCInvokerCollList(true));
        }
        logger.exiting(CLASS_NAME, "getPortletContainerInvokerCollaborators", this.pcInvokerCollList);
        return this.pcInvokerCollList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollaborator(Collaborator collaborator, String string, String string2, ClassLoader classLoader, Integer n) throws IllegalArgumentException {
        List list;
        List list2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addCollaborator", new Object[]{collaborator, string, string2, classLoader});
        }
        Integer n2 = CollaboratorRegistry.getCollaboratorOrder(string);
        boolean bl = true;
        if (collaborator instanceof PortletInvokerCollaborator) {
            list = list2 = this.getCollaboratorListOfOrder(this.portletInvokerCollByOrderMap, n2);
            synchronized (list) {
                list2.add(new Object[]{collaborator, string2, classLoader, n});
            }
            this.isPortletInvokerCollListCurrent = false;
            bl = false;
        }
        if (collaborator instanceof PortletServletCollaborator) {
            list = list2 = this.getCollaboratorListOfOrder(this.portletServletCollByOrderMap, n2);
            synchronized (list) {
                list2.add(new Object[]{collaborator, string2, classLoader, n});
            }
            this.isPortletServletCollListCurrent = false;
            bl = false;
        }
        if (collaborator instanceof PortletContainerInvokerCollaborator) {
            list = list2 = this.getCollaboratorListOfOrder(this.pcInvokerCollByOrderMap, n2);
            synchronized (list) {
                list2.add(new Object[]{collaborator, string2, classLoader, n});
            }
            this.isPCInvokerCollListCurrent = false;
            bl = false;
        }
        if (bl) {
            logger.logp(Level.SEVERE, CLASS_NAME, "addCollaborator", "collaborator.create.unknown.class.1", collaborator);
            throw new IllegalArgumentException("Collaborator class is not of a known type.");
        }
        logger.exiting(CLASS_NAME, "addCollaborator");
    }

    public void removeCollaborator(String string, String string2, String string3) throws IllegalArgumentException {
        Integer n;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeCollaborator", new Object[]{string, string2});
        }
        if (!this._removeCollaborator(this.pcInvokerCollByOrderMap, n = CollaboratorRegistry.getCollaboratorOrder(string2), string3, string)) {
            this.isPortletInvokerCollListCurrent = false;
        }
        if (!this._removeCollaborator(this.portletServletCollByOrderMap, n, string3, string)) {
            this.isPortletServletCollListCurrent = false;
        }
        if (!this._removeCollaborator(this.portletInvokerCollByOrderMap, n, string3, string)) {
            this.isPCInvokerCollListCurrent = false;
        }
        logger.exiting(CLASS_NAME, "removeCollaborator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeCollaborator(Map map, Integer n, String string, String string2) {
        List list;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "_removeCollaborator", new Object[]{map, n, string, string2});
        }
        List list2 = list = this.getCollaboratorListOfOrder(map, n);
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                String string3 = objectArray[0].getClass().getName();
                String string4 = (String)objectArray[1];
                if (!string3.equals(string2) || !string4.equals(string)) continue;
                iterator.remove();
                logger.exiting(CLASS_NAME, "_removeCollaborator", Boolean.TRUE);
                return true;
            }
            logger.exiting(CLASS_NAME, "_removeCollaborator", Boolean.FALSE);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCollaboratorListOfOrder(Map map, Integer n) {
        ArrayList arrayList = (ArrayList)map.get(n);
        if (arrayList == null) {
            Map map2 = map;
            synchronized (map2) {
                arrayList = (List)map.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    map.put(n, arrayList);
                }
            }
        }
        return arrayList;
    }

    private void registerAllCollaborators() {
        logger.entering(CLASS_NAME, "registerAllCollaborators");
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(DEFAULT_MAPPING_XML);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                Document document = null;
                try {
                    InputStream inputStream = uRL.openStream();
                    document = XmlParser.getInstance().parseXml(inputStream, COLLABORATOR_XSD_NAME, COLLABORATOR_XSD_PATHS, COLLABORATOR_XSD_NAMES);
                    if (document == null) continue;
                    this.analyzeDocument(document);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.registerAllCollaborators", (String)"248", (Object)this);
                    logger.logp(Level.WARNING, CLASS_NAME, "addCollaborators", "portletserving.filter.io.error.0", iOException);
                }
                catch (SAXException sAXException) {
                    FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.registerAllCollaborators", (String)"252", (Object)this);
                    logger.logp(Level.WARNING, CLASS_NAME, "addCollaborators", "portletserving.filter.validate.sax.error.0", sAXException);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.registerAllCollaborators", (String)"259", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "registerAllCollaborators", "portletserving.filter.io.error.0", iOException);
        }
        logger.exiting(CLASS_NAME, "registerAllCollaborators");
    }

    private void analyzeDocument(Document document) {
        logger.entering(CLASS_NAME, "analyzeDocument", document);
        boolean bl = logger.isLoggable(Level.FINEST);
        NodeList nodeList = document.getElementsByTagName("collaborator");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = "";
            Node node2 = namedNodeMap.getNamedItem("class-name");
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            String string2 = null;
            Node node3 = namedNodeMap.getNamedItem("order");
            if (node3 != null) {
                string2 = node3.getNodeValue();
            }
            if (string == "") {
                logger.logp(Level.WARNING, CLASS_NAME, "analyzeDocument", "collaborator.parse.validate.error.2", new Object[]{string, string2});
                continue;
            }
            try {
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzeDocument", "Creating collaborator {0} with order {1}", new Object[]{string, string2});
                }
                Collaborator collaborator = (Collaborator)this.getClass().getClassLoader().loadClass(string).newInstance();
                if (bl) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzeDocument", "Created collaborator {0} with order {1}", new Object[]{collaborator, string2});
                }
                this.addCollaborator(collaborator, string2, DEFAULT_NAMESPACE, collaborator.getClass().getClassLoader(), ExtensionScope.GLOBAL);
                continue;
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.analyzeDocument", (String)"319", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.analyzeDocument", (String)"323", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", illegalAccessException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.analyzeDocument", (String)"327", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", classNotFoundException);
                continue;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.analyzeDocument", (String)"331", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "analyzeDocument", "collaborator.create.error.0", classCastException);
            }
        }
        logger.exiting(CLASS_NAME, "analyzeDocument");
    }

    private List getPCInvokerCollList(boolean bl) {
        if (this.pcInvokerCollList == null) {
            this.pcInvokerCollList = new LinkedList();
        } else if (bl) {
            this.pcInvokerCollList.clear();
        }
        return this.pcInvokerCollList;
    }

    private List getPortletInvokerCollList(boolean bl) {
        if (this.portletInvokerCollList == null) {
            this.portletInvokerCollList = new LinkedList();
        } else if (bl) {
            this.portletInvokerCollList.clear();
        }
        return this.portletInvokerCollList;
    }

    private List getPortletServletCollList(boolean bl) {
        if (this.portletServletCollList == null) {
            this.portletServletCollList = new LinkedList();
        } else if (bl) {
            this.portletServletCollList.clear();
        }
        return this.portletServletCollList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCollaboratorMapToList(Map map, List list) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            List list2;
            Integer n = (Integer)iterator.next();
            List list3 = list2 = (List)map.get(n);
            synchronized (list3) {
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Object[] objectArray = (Object[])iterator2.next();
                    list.add(objectArray[0]);
                }
            }
        }
    }

    private static Integer getCollaboratorOrder(String string) throws IllegalArgumentException {
        Integer n = null;
        if (string != null && !"".equals(string)) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry.getCollaboratorOrder", (String)"390");
                logger.logp(Level.WARNING, CLASS_NAME, "getCollaboratorOrder", "collaborator.init.error.0", numberFormatException);
            }
        }
        if (n == null) {
            throw new IllegalArgumentException("Collaborator order could not be identified");
        }
        return n;
    }
}

