/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.Constants;
import com.ibm.ws.portletcontainer.collaborator.impl.CollaboratorRegistry;
import com.ibm.ws.portletcontainer.core.CoreUtils;
import com.ibm.ws.portletcontainer.core.InternalPortletRequest;
import com.ibm.ws.portletcontainer.core.InternalPortletResponse;
import com.ibm.ws.portletcontainer.core.PortletServletCollaboratorChainImpl;
import com.ibm.ws.portletcontainer.factory.PortletObjectAccess;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.PortletCloneIdentifier;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletServlet
extends HttpServlet {
    private static final long serialVersionUID = 1375888042820384122L;
    private boolean portletInitialized = false;
    private Class portletClass = null;
    private Map portletClones = new HashMap();
    private static final String CLASS_NAME = PortletServlet.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.entering(CLASS_NAME, "init", servletConfig);
        super.init(servletConfig);
        this.portletInitialized = false;
        String string = servletConfig.getInitParameter("portlet.class");
        try {
            this.portletClass = Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.init", (String)"58", (Object)((Object)this));
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "portlet.servlet.init.ex.0", classNotFoundException.getMessage());
            throw new ServletException((Throwable)classNotFoundException);
        }
        this.portletInitialized = true;
        logger.exiting(CLASS_NAME, "init");
    }

    public void init() throws ServletException {
    }

    public final ServletConfig getServletConfig() {
        return super.getServletConfig();
    }

    public final String getInitParameter(String string) {
        return this.getServletConfig().getInitParameter(string);
    }

    public final Enumeration getInitParameterNames() {
        return this.getServletConfig().getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    public String getServletInfo() {
        return "";
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.dispatch(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.dispatch(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.dispatch(httpServletRequest, httpServletResponse);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doDelete(httpServletRequest, httpServletResponse);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doOptions(httpServletRequest, httpServletResponse);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doTrace(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
        logger.entering(CLASS_NAME, "destroy");
        Iterator iterator = this.portletClones.values().iterator();
        while (iterator.hasNext()) {
            PortletClone portletClone = (PortletClone)iterator.next();
            portletClone.portletObject.destroy();
        }
        super.destroy();
        logger.exiting(CLASS_NAME, "destroy");
    }

    private void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "dispatch", new Object[]{httpServletRequest, httpServletResponse});
        }
        if (!this.portletInitialized) {
            throw new ServletException("Internal portlet container error: This portlet has not been initialized.");
        }
        List list = CollaboratorRegistry.getInstance().getPortletServletCollaborators();
        if (list.size() == 0) {
            this.doDispatch(httpServletRequest, httpServletResponse);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "dispatch", "Calling collaborators. Count: " + list.size());
            }
            Iterator iterator = list.iterator();
            PortletServletCollaboratorChainImpl portletServletCollaboratorChainImpl = new PortletServletCollaboratorChainImpl(iterator, this, null);
            portletServletCollaboratorChainImpl.doCollaborator(httpServletRequest, httpServletResponse);
        }
        logger.exiting(CLASS_NAME, "dispatch");
    }

    void doDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doDispatch", new Object[]{httpServletRequest, httpServletResponse});
        }
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        InternalPortletRequest internalPortletRequest = CoreUtils.getInternalRequest(portletRequest);
        PortletWindow portletWindow = internalPortletRequest.getPortletWindow();
        PortletClone portletClone = this.getPortletClone(portletWindow);
        Object object = httpServletRequest.getAttribute("javax.portlet.config");
        httpServletRequest.setAttribute("javax.portlet.config", (Object)portletClone.portletConfig);
        HttpServletRequest httpServletRequest2 = null;
        HttpServletResponse httpServletResponse2 = null;
        try {
            block17: {
                try {
                    List list;
                    Integer n = (Integer)httpServletRequest.getAttribute("com.ibm.ws.portletcontainer.core.method");
                    if (n == Constants.METHOD_RENDER) {
                        List list2;
                        RenderRequest renderRequest = (RenderRequest)portletRequest;
                        RenderResponse renderResponse = (RenderResponse)portletResponse;
                        httpServletRequest2 = this.preprocessRequest(renderRequest, httpServletRequest);
                        httpServletResponse2 = this.preprocessResponse(renderResponse, httpServletRequest, httpServletResponse);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "doDispatch", "Calling portlet.render with " + renderRequest + ", " + renderResponse);
                        }
                        if ((list2 = CollaboratorRegistry.getInstance().getPortletServletCollaborators()).size() == 0) {
                            this.doDispatch(renderRequest, renderResponse, portletClone);
                        } else {
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, CLASS_NAME, "doDispatch", "Calling collaborators. Count: " + list2.size());
                            }
                            Iterator iterator = list2.iterator();
                            PortletServletCollaboratorChainImpl portletServletCollaboratorChainImpl = new PortletServletCollaboratorChainImpl(iterator, this, portletClone);
                            portletServletCollaboratorChainImpl.doCollaborator(renderRequest, renderResponse);
                        }
                        break block17;
                    }
                    if (n != Constants.METHOD_ACTION) break block17;
                    ActionRequest actionRequest = (ActionRequest)portletRequest;
                    ActionResponse actionResponse = (ActionResponse)portletResponse;
                    httpServletRequest2 = this.preprocessRequest(actionRequest, httpServletRequest);
                    httpServletResponse2 = this.preprocessResponse(actionResponse, httpServletRequest, httpServletResponse);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "doDispatch", "Calling portlet.processAction with " + actionRequest + ", " + actionResponse);
                    }
                    if ((list = CollaboratorRegistry.getInstance().getPortletServletCollaborators()).size() == 0) {
                        this.doDispatch(actionRequest, actionResponse, portletClone);
                        break block17;
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "doDispatch", "Calling collaborators. Count: " + list.size());
                    }
                    Iterator iterator = list.iterator();
                    PortletServletCollaboratorChainImpl portletServletCollaboratorChainImpl = new PortletServletCollaboratorChainImpl(iterator, this, portletClone);
                    portletServletCollaboratorChainImpl.doCollaborator(actionRequest, actionResponse);
                }
                catch (UnavailableException unavailableException) {
                    FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.dispatch", (String)"248", (Object)((Object)this));
                    logger.logp(Level.SEVERE, CLASS_NAME, "doDispatch", "portlet.servlet.dispatch.ex.0", unavailableException);
                    if (unavailableException.isPermanent()) {
                        throw new javax.servlet.UnavailableException(unavailableException.getMessage());
                    }
                    throw new javax.servlet.UnavailableException(unavailableException.getMessage(), unavailableException.getUnavailableSeconds());
                }
                catch (PortletException portletException) {
                    FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.dispatch", (String)"255", (Object)((Object)this));
                    logger.logp(Level.SEVERE, CLASS_NAME, "doDispatch", "portlet.servlet.dispatch.ex.0", portletException);
                    throw new ServletException((Throwable)portletException);
                }
                catch (RuntimeException runtimeException) {
                    FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.dispatch", (String)"260", (Object)((Object)this));
                    logger.logp(Level.SEVERE, CLASS_NAME, "doDispatch", "portlet.servlet.dispatch.ex.0", runtimeException);
                    throw new ServletException((Throwable)new PortletException(runtimeException));
                }
            }
            Object var18_25 = null;
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            httpServletRequest.setAttribute("javax.portlet.config", object);
            this.postprocess(portletRequest, portletResponse, httpServletRequest2, httpServletResponse2);
            throw throwable;
        }
        httpServletRequest.setAttribute("javax.portlet.config", object);
        this.postprocess(portletRequest, portletResponse, httpServletRequest2, httpServletResponse2);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doDispatch");
        }
    }

    void doDispatch(PortletRequest portletRequest, PortletResponse portletResponse, PortletClone portletClone) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doDispatch", new Object[]{portletRequest, portletResponse});
        }
        if (portletRequest instanceof ActionRequest) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "doDispatch", "Calling portlet.processAction with " + portletRequest + ", " + portletResponse);
            }
            portletClone.portletObject.processAction((ActionRequest)portletRequest, (ActionResponse)portletResponse);
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "doDispatch", "Calling portlet.render with " + portletRequest + ", " + portletResponse);
            }
            portletClone.portletObject.render((RenderRequest)portletRequest, (RenderResponse)portletResponse);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doDispatch");
        }
    }

    private void initClone(PortletClone portletClone) throws ServletException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "init", new Object[]{portletClone});
        }
        try {
            List list = CollaboratorRegistry.getInstance().getPortletServletCollaborators();
            if (list.size() == 0) {
                this.doInit(portletClone);
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "init", "Calling collaborators. Count: " + list.size());
                }
                Iterator iterator = list.iterator();
                PortletServletCollaboratorChainImpl portletServletCollaboratorChainImpl = new PortletServletCollaboratorChainImpl(iterator, this, portletClone);
                portletServletCollaboratorChainImpl.doCollaborator(portletClone.portletConfig);
            }
        }
        catch (UnavailableException unavailableException) {
            FFDCFilter.processException((Throwable)unavailableException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.init", (String)"99", (Object)((Object)this));
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "portlet.servlet.init.ex.0", unavailableException.getMessage());
            if (unavailableException.isPermanent()) {
                throw new javax.servlet.UnavailableException(unavailableException.getMessage());
            }
            throw new javax.servlet.UnavailableException(unavailableException.getMessage(), unavailableException.getUnavailableSeconds());
        }
        catch (PortletException portletException) {
            FFDCFilter.processException((Throwable)portletException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.init", (String)"89", (Object)((Object)this));
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "portlet.servlet.init.ex.0", portletException.getMessage());
            throw new ServletException((Throwable)portletException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doDispatch");
        }
    }

    void doInit(PortletClone portletClone) throws PortletException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "init", "Calling portlet.init with " + portletClone.portletConfig);
        }
        portletClone.portletObject.init(portletClone.portletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletClone getPortletClone(PortletWindow portletWindow) throws ServletException {
        PortletClone portletClone;
        ObjectID objectID = null;
        PortletWindowIdentifier portletWindowIdentifier = portletWindow.getPortletWindowIdentifier();
        if (portletWindowIdentifier instanceof PortletCloneIdentifier) {
            objectID = ((PortletCloneIdentifier)((Object)portletWindowIdentifier)).getCloneID();
        }
        if ((portletClone = (PortletClone)this.portletClones.get(objectID)) == null) {
            PortletServlet portletServlet = this;
            synchronized (portletServlet) {
                portletClone = (PortletClone)this.portletClones.get(objectID);
                if (portletClone == null) {
                    portletClone = new PortletClone(portletWindow.getPortletDefinition(), objectID);
                    this.initClone(portletClone);
                    this.portletClones.put(objectID, portletClone);
                }
            }
        }
        return portletClone;
    }

    private HttpServletRequest preprocessRequest(PortletRequest portletRequest, HttpServletRequest httpServletRequest) {
        InternalPortletRequest internalPortletRequest = CoreUtils.getInternalRequest(portletRequest);
        return internalPortletRequest.lateInit(httpServletRequest);
    }

    private HttpServletResponse preprocessResponse(PortletResponse portletResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        InternalPortletResponse internalPortletResponse = CoreUtils.getInternalResponse(portletResponse);
        return internalPortletResponse.lateInit(httpServletRequest, httpServletResponse);
    }

    private void postprocess(PortletRequest portletRequest, PortletResponse portletResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        if (httpServletRequest != null) {
            object = CoreUtils.getInternalRequest(portletRequest);
            object.reverseInit(httpServletRequest);
        }
        if (httpServletResponse != null) {
            object = CoreUtils.getInternalResponse(portletResponse);
            object.reverseInit(httpServletRequest, httpServletResponse);
        }
    }

    class PortletClone {
        ObjectID cloneId;
        Portlet portletObject;
        PortletConfig portletConfig;

        PortletClone(PortletDefinition portletDefinition, ObjectID objectID) throws ServletException {
            this.cloneId = objectID;
            try {
                this.portletObject = (Portlet)PortletServlet.this.portletClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.init", (String)"64", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "init", "portlet.servlet.init.ex.0", illegalAccessException.getMessage());
                throw new ServletException((Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.portletcontainer.core.PortletServlet.init", (String)"70", (Object)this);
                logger.logp(Level.SEVERE, CLASS_NAME, "init", "portlet.servlet.init.ex.0", instantiationException.getMessage());
                throw new ServletException((Throwable)instantiationException);
            }
            PortletContext portletContext = PortletObjectAccess.getPortletContext(PortletServlet.this.getServletContext(), portletDefinition.getPortletApplicationDefinition());
            this.portletConfig = PortletObjectAccess.getPortletConfig(PortletServlet.this.getServletConfig(), portletContext, portletDefinition);
        }

        public void updatePortletConfig(PortletConfig portletConfig) {
            if (this.portletConfig != portletConfig) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "updatePortletConfig", "Exchanging portlet config for " + this + " with " + portletConfig);
                }
                this.portletConfig = portletConfig;
            }
        }
    }
}

