/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core;

import com.ibm.ws.portletcontainer.core.PortletServlet;
import com.ibm.wsspi.portletcontainer.ObjectID;
import com.ibm.wsspi.portletcontainer.collaborator.PortletServletCollaborator;
import com.ibm.wsspi.portletcontainer.collaborator.PortletServletCollaboratorChain;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletServletCollaboratorChainImpl
implements PortletServletCollaboratorChain {
    private static final String CLASS_NAME = PortletServletCollaboratorChainImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private Iterator iter;
    private PortletServlet servlet;
    private PortletServlet.PortletClone clone;

    PortletServletCollaboratorChainImpl(Iterator iterator, PortletServlet portletServlet, PortletServlet.PortletClone portletClone) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "PortletServletCollaboratorChainImpl", new Object[]{iterator, portletServlet, portletClone});
        }
        this.iter = iterator;
        this.servlet = portletServlet;
        this.clone = portletClone;
        logger.exiting(CLASS_NAME, "PortletServletCollaboratorChainImpl");
    }

    public Portlet getPortlet() {
        return this.clone.portletObject;
    }

    public PortletConfig getPortletConfig() {
        return this.clone.portletConfig;
    }

    public ObjectID getCloneID() {
        return this.clone.cloneId;
    }

    public void doCollaborator(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doCollaborator", new Object[]{httpServletRequest, httpServletResponse});
        }
        if (this.iter.hasNext()) {
            PortletServletCollaborator portletServletCollaborator = (PortletServletCollaborator)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Calling doDispatch of collaborator: " + portletServletCollaborator);
            }
            portletServletCollaborator.doDispatch(httpServletRequest, httpServletResponse, this);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Last collaborator called. Proceeding with normal execution.");
            }
            this.servlet.doDispatch(httpServletRequest, httpServletResponse);
        }
        logger.exiting(CLASS_NAME, "doCollaborator");
    }

    public void doCollaborator(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doCollaborator", new Object[]{portletRequest, portletResponse});
        }
        if (this.iter.hasNext()) {
            PortletServletCollaborator portletServletCollaborator = (PortletServletCollaborator)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Calling doDispatch of collaborator: " + portletServletCollaborator);
            }
            if (portletRequest instanceof ActionRequest) {
                portletServletCollaborator.doAction((ActionRequest)portletRequest, (ActionResponse)portletResponse, this);
            } else {
                portletServletCollaborator.doRender((RenderRequest)portletRequest, (RenderResponse)portletResponse, this);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Last collaborator called. Proceeding with normal execution.");
            }
            this.servlet.doDispatch(portletRequest, portletResponse, this.clone);
        }
        logger.exiting(CLASS_NAME, "doCollaborator");
    }

    public void doCollaborator(PortletConfig portletConfig) throws PortletException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doCollaborator", new Object[]{portletConfig});
        }
        this.clone.updatePortletConfig(portletConfig);
        if (this.iter.hasNext()) {
            PortletServletCollaborator portletServletCollaborator = (PortletServletCollaborator)this.iter.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Calling doDispatch of collaborator: " + portletServletCollaborator);
            }
            portletServletCollaborator.doInit(portletConfig, this);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "doCollaborator", "Last collaborator called. Proceeding with normal execution.");
            }
            this.servlet.doInit(this.clone);
        }
        logger.exiting(CLASS_NAME, "doCollaborator");
    }
}

