/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.core.impl;

import com.ibm.ws.portletcontainer.Constants;
import com.ibm.ws.portletcontainer.core.impl.PortletRequestImpl;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;

public class ActionRequestImpl
extends PortletRequestImpl
implements ActionRequest {
    private static final String CLASS_NAME = ActionRequestImpl.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");

    public ActionRequestImpl(PortletWindow portletWindow, HttpServletRequest httpServletRequest) {
        super(portletWindow, httpServletRequest);
    }

    public InputStream getPortletInputStream() throws IOException {
        String string;
        logger.entering(CLASS_NAME, "getPortletInputStream");
        HttpServletRequest httpServletRequest = (HttpServletRequest)super.getRequest();
        if (httpServletRequest.getMethod().equals("POST")) {
            string = httpServletRequest.getContentType();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "getPortletInputStream", "Checking content type " + string);
            }
            if (string == null || string.equals("application/x-www-form-urlencoded")) {
                logger.logp(Level.SEVERE, CLASS_NAME, "getPortletInputStream", "action.request.ex.0");
                throw new IllegalStateException("User request HTTP POST data is of type application/x-www-form-urlencoded. This data has been already processed by the portal/portlet-container and is available as request parameters.");
            }
        }
        string = httpServletRequest.getInputStream();
        logger.exiting(CLASS_NAME, "getPortletInputStream", string);
        return string;
    }

    public PortletPreferences getPreferences() {
        return super.getPreferences(Constants.METHOD_ACTION);
    }
}

